/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.PNGImageDataEnumeration;
import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PNGImageReader
extends ImageReader {
    static final int IHDR_TYPE = PNGImageReader.chunkType("IHDR");
    static final int PLTE_TYPE = PNGImageReader.chunkType("PLTE");
    static final int IDAT_TYPE = PNGImageReader.chunkType("IDAT");
    static final int IEND_TYPE = PNGImageReader.chunkType("IEND");
    static final int bKGD_TYPE = PNGImageReader.chunkType("bKGD");
    static final int cHRM_TYPE = PNGImageReader.chunkType("cHRM");
    static final int gAMA_TYPE = PNGImageReader.chunkType("gAMA");
    static final int hIST_TYPE = PNGImageReader.chunkType("hIST");
    static final int iCCP_TYPE = PNGImageReader.chunkType("iCCP");
    static final int iTXt_TYPE = PNGImageReader.chunkType("iTXt");
    static final int pHYs_TYPE = PNGImageReader.chunkType("pHYs");
    static final int sBIT_TYPE = PNGImageReader.chunkType("sBIT");
    static final int sPLT_TYPE = PNGImageReader.chunkType("sPLT");
    static final int sRGB_TYPE = PNGImageReader.chunkType("sRGB");
    static final int tEXt_TYPE = PNGImageReader.chunkType("tEXt");
    static final int tIME_TYPE = PNGImageReader.chunkType("tIME");
    static final int tRNS_TYPE = PNGImageReader.chunkType("tRNS");
    static final int zTXt_TYPE = PNGImageReader.chunkType("zTXt");
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] inputBandsForColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    static final int[] adam7XOffset = new int[]{0, 4, 0, 2, 0, 1, 0};
    static final int[] adam7YOffset = new int[]{0, 0, 4, 0, 2, 0, 1};
    static final int[] adam7XSubsampling = new int[]{8, 8, 4, 4, 2, 2, 1, 1};
    static final int[] adam7YSubsampling = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private static final boolean debug = true;
    ImageInputStream stream = null;
    boolean gotHeader = false;
    boolean gotMetadata = false;
    ImageReadParam lastParam = null;
    long imageStartPosition = -1L;
    Rectangle sourceRegion = null;
    int sourceXSubsampling = -1;
    int sourceYSubsampling = -1;
    int sourceMinProgressivePass = 0;
    int sourceMaxProgressivePass = 6;
    int[] sourceBands = null;
    int[] destinationBands = null;
    Point destinationOffset = new Point(0, 0);
    PNGMetadata metadata = new PNGMetadata();
    DataInputStream pixelStream = null;
    BufferedImage theImage = null;
    int pixelsDone = 0;
    int totalPixels;
    private static final int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};

    public PNGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl) {
        super.setInput(object, bl);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
    }

    static int chunkType(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        char c3 = string.charAt(2);
        char c4 = string.charAt(3);
        int n = c << 24 | c2 << 16 | c3 << 8 | c4;
        return n;
    }

    private String readNullTerminatedString() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.stream.read()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input source not set!");
        }
        try {
            byte[] byArray = new byte[8];
            this.stream.readFully(byArray);
            if (byArray[0] != -119 || byArray[1] != 80 || byArray[2] != 78 || byArray[3] != 71 || byArray[4] != 13 || byArray[5] != 10 || byArray[6] != 26 || byArray[7] != 10) {
                throw new IIOException("Bad PNG signature!");
            }
            int n = this.stream.readInt();
            if (n != 13) {
                throw new IIOException("Bad length for IHDR chunk!");
            }
            int n2 = this.stream.readInt();
            if (n2 != IHDR_TYPE) {
                throw new IIOException("Bad type for IHDR chunk!");
            }
            this.metadata = new PNGMetadata();
            int n3 = this.stream.readInt();
            int n4 = this.stream.readInt();
            int n5 = this.stream.readUnsignedByte();
            int n6 = this.stream.readUnsignedByte();
            int n7 = this.stream.readUnsignedByte();
            int n8 = this.stream.readUnsignedByte();
            int n9 = this.stream.readUnsignedByte();
            int n10 = this.stream.readInt();
            this.stream.flushBefore(this.stream.getStreamPosition());
            if (n3 == 0) {
                throw new IIOException("Image width == 0!");
            }
            if (n4 == 0) {
                throw new IIOException("Image height == 0!");
            }
            if (n5 != 1 && n5 != 2 && n5 != 4 && n5 != 8 && n5 != 16) {
                throw new IIOException("Bit depth must be 1, 2, 4, 8, or 16!");
            }
            if (n6 != 0 && n6 != 2 && n6 != 3 && n6 != 4 && n6 != 6) {
                throw new IIOException("Color type must be 0, 2, 3, 4, or 6!");
            }
            if (n6 == 3 && n5 == 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if ((n6 == 2 || n6 == 6 || n6 == 4) && n5 != 8 && n5 != 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if (n7 != 0) {
                throw new IIOException("Unknown compression method (not 0)!");
            }
            if (n8 != 0) {
                throw new IIOException("Unknown filter method (not 0)!");
            }
            if (n9 != 0 && n9 != 1) {
                throw new IIOException("Unknown interlace method (not 0 or 1)!");
            }
            this.metadata.IHDR_present = true;
            this.metadata.IHDR_width = n3;
            this.metadata.IHDR_height = n4;
            this.metadata.IHDR_bitDepth = n5;
            this.metadata.IHDR_colorType = n6;
            this.metadata.IHDR_compressionMethod = n7;
            this.metadata.IHDR_filterMethod = n8;
            this.metadata.IHDR_interlaceMethod = n9;
            this.gotHeader = true;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading PNG header!", iOException);
        }
    }

    private void parse_PLTE_chunk(int n) throws IOException {
        int n2;
        if (this.metadata.PLTE_present) {
            this.processWarningOccurred("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.processWarningOccurred("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            return;
        }
        byte[] byArray = new byte[n];
        this.stream.readFully(byArray);
        int n3 = n / 3;
        if (this.metadata.IHDR_colorType == 3) {
            n2 = 1 << this.metadata.IHDR_bitDepth;
            if (n3 > n2) {
                this.processWarningOccurred("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                n3 = n2;
            }
            n3 = Math.min(n3, n2);
        }
        this.metadata.PLTE_present = true;
        this.metadata.PLTE_red = new byte[n3];
        this.metadata.PLTE_green = new byte[n3];
        this.metadata.PLTE_blue = new byte[n3];
        n2 = 0;
        int n4 = 0;
        while (n4 < n3) {
            this.metadata.PLTE_red[n4] = byArray[n2++];
            this.metadata.PLTE_green[n4] = byArray[n2++];
            this.metadata.PLTE_blue[n4] = byArray[n2++];
            ++n4;
        }
    }

    private void parse_bKGD_chunk() throws IOException {
        if (this.metadata.IHDR_colorType == 3) {
            this.metadata.bKGD_index = this.stream.readUnsignedByte();
        } else if (this.metadata.IHDR_colorType == 0 || this.metadata.IHDR_colorType == 4) {
            this.metadata.bKGD_gray = this.stream.readUnsignedShort();
        } else {
            this.metadata.bKGD_red = this.stream.readUnsignedShort();
            this.metadata.bKGD_green = this.stream.readUnsignedShort();
            this.metadata.bKGD_blue = this.stream.readUnsignedShort();
        }
        this.metadata.bKGD_present = true;
    }

    private void parse_cHRM_chunk() throws IOException {
        this.metadata.cHRM_whitePointX = this.stream.readInt();
        this.metadata.cHRM_whitePointY = this.stream.readInt();
        this.metadata.cHRM_redX = this.stream.readInt();
        this.metadata.cHRM_redY = this.stream.readInt();
        this.metadata.cHRM_greenX = this.stream.readInt();
        this.metadata.cHRM_greenY = this.stream.readInt();
        this.metadata.cHRM_blueX = this.stream.readInt();
        this.metadata.cHRM_blueY = this.stream.readInt();
        this.metadata.cHRM_present = true;
    }

    private void parse_gAMA_chunk() throws IOException {
        int n;
        this.metadata.gAMA_gamma = n = this.stream.readInt();
        this.metadata.gAMA_present = true;
    }

    private void parse_hIST_chunk() throws IOException, IIOException {
        if (!this.metadata.PLTE_present) {
            throw new IIOException("hIST chunk without prior PLTE chunk!");
        }
        this.metadata.hIST_histogram = new char[this.metadata.PLTE_red.length];
        this.stream.readFully(this.metadata.hIST_histogram, 0, this.metadata.hIST_histogram.length);
        this.metadata.hIST_present = true;
    }

    private void parse_iCCP_chunk(int n) throws IOException {
        String string;
        this.metadata.iCCP_profileName = string = this.readNullTerminatedString();
        this.metadata.iCCP_compressionMethod = this.stream.readUnsignedByte();
        byte[] byArray = new byte[n - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.iCCP_compressedProfile = byArray;
        this.metadata.iCCP_present = true;
    }

    private void parse_iTXt_chunk() throws IOException {
        this.metadata.iTXt_keyword.add(this.readNullTerminatedString());
        int n = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionFlag.add(new Integer(n));
        int n2 = this.stream.readUnsignedByte();
        this.metadata.iTXt_compressionMethod.add(new Integer(n2));
        this.metadata.iTXt_languageTag.add(this.readNullTerminatedString());
        this.metadata.iTXt_translatedKeyword.add(this.stream.readUTF());
        this.stream.skipBytes(1);
        this.metadata.iTXt_text.add(this.stream.readUTF());
    }

    private void parse_pHYs_chunk() throws IOException {
        this.metadata.pHYs_pixelsPerUnitXAxis = this.stream.readInt();
        this.metadata.pHYs_pixelsPerUnitYAxis = this.stream.readInt();
        this.metadata.pHYs_unitSpecifier = this.stream.readUnsignedByte();
        this.metadata.pHYs_present = true;
    }

    private void parse_sBIT_chunk() throws IOException {
        int n = this.metadata.IHDR_colorType;
        if (n == 0 || n == 4) {
            this.metadata.sBIT_grayBits = this.stream.readUnsignedByte();
        } else if (n == 2 || n == 3 || n == 6) {
            this.metadata.sBIT_redBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_greenBits = this.stream.readUnsignedByte();
            this.metadata.sBIT_blueBits = this.stream.readUnsignedByte();
        }
        if (n == 4 || n == 6) {
            this.metadata.sBIT_alphaBits = this.stream.readUnsignedByte();
        }
        this.metadata.sBIT_present = true;
    }

    private void parse_sPLT_chunk(int n) throws IOException, IIOException {
        int n2;
        this.metadata.sPLT_paletteName = this.readNullTerminatedString();
        this.metadata.sPLT_sampleDepth = n2 = this.stream.readUnsignedByte();
        int n3 = (n -= this.metadata.sPLT_paletteName.length() + 1) / (4 * (n2 / 8) + 2);
        this.metadata.sPLT_red = new int[n3];
        this.metadata.sPLT_green = new int[n3];
        this.metadata.sPLT_blue = new int[n3];
        this.metadata.sPLT_alpha = new int[n3];
        this.metadata.sPLT_frequency = new int[n3];
        if (n2 == 8) {
            int n4 = 0;
            while (n4 < n3) {
                this.metadata.sPLT_red[n4] = this.stream.readUnsignedByte();
                this.metadata.sPLT_green[n4] = this.stream.readUnsignedByte();
                this.metadata.sPLT_blue[n4] = this.stream.readUnsignedByte();
                this.metadata.sPLT_alpha[n4] = this.stream.readUnsignedByte();
                this.metadata.sPLT_frequency[n4] = this.stream.readUnsignedShort();
                ++n4;
            }
        } else if (n2 == 16) {
            int n5 = 0;
            while (n5 < n3) {
                this.metadata.sPLT_red[n5] = this.stream.readUnsignedShort();
                this.metadata.sPLT_green[n5] = this.stream.readUnsignedShort();
                this.metadata.sPLT_blue[n5] = this.stream.readUnsignedShort();
                this.metadata.sPLT_alpha[n5] = this.stream.readUnsignedShort();
                this.metadata.sPLT_frequency[n5] = this.stream.readUnsignedShort();
                ++n5;
            }
        } else {
            throw new IIOException("sPLT sample depth not 8 or 16!");
        }
        this.metadata.sPLT_present = true;
    }

    private void parse_sRGB_chunk() throws IOException {
        this.metadata.sRGB_renderingIntent = this.stream.readUnsignedByte();
        this.metadata.sRGB_present = true;
    }

    private void parse_tEXt_chunk(int n) throws IOException {
        String string = this.readNullTerminatedString();
        this.metadata.tEXt_keyword.add(string);
        byte[] byArray = new byte[n - string.length() - 1];
        this.stream.readFully(byArray);
        this.metadata.tEXt_text.add(new String(byArray));
    }

    private void parse_tIME_chunk() throws IOException {
        this.metadata.tIME_year = this.stream.readUnsignedShort();
        this.metadata.tIME_month = this.stream.readUnsignedByte();
        this.metadata.tIME_day = this.stream.readUnsignedByte();
        this.metadata.tIME_hour = this.stream.readUnsignedByte();
        this.metadata.tIME_minute = this.stream.readUnsignedByte();
        this.metadata.tIME_second = this.stream.readUnsignedByte();
        this.metadata.tIME_present = true;
    }

    private void parse_tRNS_chunk(int n) throws IOException {
        int n2 = this.metadata.IHDR_colorType;
        if (n2 == 3) {
            if (!this.metadata.PLTE_present) {
                this.processWarningOccurred("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int n3 = this.metadata.PLTE_red.length;
            this.metadata.tRNS_alpha = new byte[n3];
            int n4 = n;
            if (n4 > n3) {
                this.processWarningOccurred("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                n4 = n3;
            }
            this.stream.read(this.metadata.tRNS_alpha, 0, n4);
            this.stream.skipBytes(n - n4);
            int n5 = n4;
            while (n5 < n3) {
                this.metadata.tRNS_alpha[n5] = -1;
                ++n5;
            }
        } else if (n2 == 0) {
            if (n != 2) {
                this.processWarningOccurred("tRNS chunk for gray image must have length 2, ignoring chunk.");
                this.stream.skipBytes(n);
                return;
            }
            this.metadata.tRNS_gray = this.stream.readUnsignedShort();
        } else if (n2 == 2) {
            if (n != 6) {
                this.processWarningOccurred("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                this.stream.skipBytes(n);
                return;
            }
            this.metadata.tRNS_red = this.stream.readUnsignedShort();
            this.metadata.tRNS_green = this.stream.readUnsignedShort();
            this.metadata.tRNS_blue = this.stream.readUnsignedShort();
        } else {
            this.processWarningOccurred("Gray+Alpha and RGBS images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.metadata.tRNS_present = true;
    }

    private void parse_zTXt_chunk(int n) throws IOException {
        String string = this.readNullTerminatedString();
        this.metadata.zTXt_keyword.add(string);
        int n2 = this.stream.readUnsignedByte();
        this.metadata.zTXt_compressionMethod.add(new Integer(n2));
        byte[] byArray = new byte[n - string.length() - 2];
        this.stream.readFully(byArray);
        this.metadata.zTXt_compressedText.add(byArray);
    }

    private void readMetadata() throws IIOException {
        if (this.gotMetadata) {
            return;
        }
        this.readHeader();
        try {
            while (true) {
                int n = this.stream.readInt();
                int n2 = this.stream.readInt();
                if (n2 == IDAT_TYPE) {
                    this.stream.skipBytes(-8);
                    this.imageStartPosition = this.stream.getStreamPosition();
                    break;
                }
                if (n2 == PLTE_TYPE) {
                    this.parse_PLTE_chunk(n);
                } else if (n2 == bKGD_TYPE) {
                    this.parse_bKGD_chunk();
                } else if (n2 == cHRM_TYPE) {
                    this.parse_cHRM_chunk();
                } else if (n2 == gAMA_TYPE) {
                    this.parse_gAMA_chunk();
                } else if (n2 == hIST_TYPE) {
                    this.parse_hIST_chunk();
                } else if (n2 == iCCP_TYPE) {
                    this.parse_iCCP_chunk(n);
                } else if (n2 == iTXt_TYPE) {
                    this.parse_iTXt_chunk();
                } else if (n2 == pHYs_TYPE) {
                    this.parse_pHYs_chunk();
                } else if (n2 == sBIT_TYPE) {
                    this.parse_sBIT_chunk();
                } else if (n2 == sPLT_TYPE) {
                    this.parse_sPLT_chunk(n);
                } else if (n2 == sRGB_TYPE) {
                    this.parse_sRGB_chunk();
                } else if (n2 == tEXt_TYPE) {
                    this.parse_tEXt_chunk(n);
                } else if (n2 == tIME_TYPE) {
                    this.parse_tIME_chunk();
                } else if (n2 == tRNS_TYPE) {
                    this.parse_tRNS_chunk(n);
                } else if (n2 == zTXt_TYPE) {
                    this.parse_zTXt_chunk(n);
                } else {
                    byte[] byArray = new byte[n];
                    this.stream.readFully(byArray);
                    StringBuffer stringBuffer = new StringBuffer(4);
                    stringBuffer.append((char)(n2 >>> 24));
                    stringBuffer.append((char)(n2 >> 16 & 0xFF));
                    stringBuffer.append((char)(n2 >> 8 & 0xFF));
                    stringBuffer.append((char)(n2 & 0xFF));
                    int n3 = n2 >>> 28;
                    if (n3 == 0) {
                        this.processWarningOccurred("Encountered unknown chunk with critical bit set!");
                    }
                    this.metadata.unknownChunkType.add(stringBuffer.toString());
                    this.metadata.unknownChunkData.add(byArray);
                }
                int n4 = this.stream.readInt();
                this.stream.flushBefore(this.stream.getStreamPosition());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("Error reading PNG metadata", iOException);
        }
        this.gotMetadata = true;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3;
        while (n4 < n2) {
            int n5 = byArray[n4 + n] & 0xFF;
            byArray[n4 + n] = (byte)(n5 += byArray[n4 + n - n3] & 0xFF);
            ++n4;
        }
    }

    private static void decodeUpFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = byArray[n4 + n] & 0xFF;
            int n6 = byArray2[n4 + n2] & 0xFF;
            byArray[n4 + n] = (byte)(n5 + n6);
            ++n4;
        }
    }

    private static void decodeAverageFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        while (n7 < n4) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5 / 2);
            ++n7;
        }
        int n8 = n4;
        while (n8 < n3) {
            n6 = byArray[n8 + n] & 0xFF;
            int n9 = byArray[n8 + n - n4] & 0xFF;
            n5 = byArray2[n8 + n2] & 0xFF;
            byArray[n8 + n] = (byte)(n6 + (n9 + n5) / 2);
            ++n8;
        }
    }

    private static int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static void decodePaethFilter(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        while (n7 < n4) {
            n6 = byArray[n7 + n] & 0xFF;
            n5 = byArray2[n7 + n2] & 0xFF;
            byArray[n7 + n] = (byte)(n6 + n5);
            ++n7;
        }
        int n8 = n4;
        while (n8 < n3) {
            n6 = byArray[n8 + n] & 0xFF;
            int n9 = byArray[n8 + n - n4] & 0xFF;
            n5 = byArray2[n8 + n2] & 0xFF;
            int n10 = byArray2[n8 + n2 - n4] & 0xFF;
            byArray[n8 + n] = (byte)(n6 + PNGImageReader.paethPredictor(n9, n5, n10));
            ++n8;
        }
    }

    private WritableRaster createRaster(int n, int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = null;
        Point point = new Point(0, 0);
        if (n5 < 8 && n3 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n5, point);
        } else if (n5 <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n4, n3, bandOffsets[n3], point);
        } else {
            DataBufferUShort dataBufferUShort = new DataBufferUShort(n2 * n4);
            writableRaster = Raster.createInterleavedRaster(dataBufferUShort, n, n2, n4, n3, bandOffsets[n3], point);
        }
        return writableRaster;
    }

    private void skipPass(int n, int n2) throws IOException, IIOException {
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n4 = (n3 * n * this.metadata.IHDR_bitDepth + 7) / 8;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = this.pixelStream.read();
            this.pixelStream.readFully(byArray, 0, n4);
            ++n5;
        }
    }

    private static void computeUpdatedPixels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10) {
        boolean bl = false;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        while (n14 < n8) {
            int n15 = n7 + n14 * n9;
            if (n15 >= n && (n15 - n) % n6 == 0) {
                if (n15 >= n + n2) break;
                int n16 = n3 + (n15 - n) / n6;
                if (n16 >= n4) {
                    if (n16 > n5) break;
                    if (!bl) {
                        n11 = n16;
                        bl = true;
                    } else if (n12 == -1) {
                        n12 = n16;
                    }
                    n13 = n16;
                }
            }
            ++n14;
        }
        nArray[n10] = n11;
        nArray[n10 + 2] = !bl ? 0 : n13 - n11 + 1;
        nArray[n10 + 4] = Math.max(n12 - n11, 1);
    }

    private static int[] computeUpdatedPixels(Rectangle rectangle, Point point, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int[] nArray = new int[6];
        PNGImageReader.computeUpdatedPixels(rectangle.x, rectangle.width, point.x, n, n3, n5, n7, n9, n11, nArray, 0);
        PNGImageReader.computeUpdatedPixels(rectangle.y, rectangle.height, point.y, n2, n4, n6, n8, n10, n12, nArray, 1);
        return nArray;
    }

    private void decodePass(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IOException, IIOException {
        int n8;
        if (n6 == 0 || n7 == 0) {
            return;
        }
        WritableRaster writableRaster = this.theImage.getWritableTile(0, 0);
        int n9 = writableRaster.getMinX();
        int n10 = n9 + writableRaster.getWidth() - 1;
        int n11 = writableRaster.getMinY();
        int n12 = n11 + writableRaster.getHeight() - 1;
        int[] nArray = PNGImageReader.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, n9, n11, n10, n12, this.sourceXSubsampling, this.sourceYSubsampling, n2, n3, n6, n7, n4, n5);
        int n13 = nArray[0];
        int n14 = nArray[2];
        int n15 = nArray[4];
        int n16 = this.metadata.IHDR_bitDepth;
        int n17 = inputBandsForColorType[this.metadata.IHDR_colorType];
        int n18 = n16 == 16 ? 2 : 1;
        n18 *= n17;
        int n19 = (n17 * n6 * n16 + 7) / 8;
        int n20 = n16 == 16 ? n19 / 2 : n19;
        byte[] byArray = new byte[n19];
        byte[] byArray2 = new byte[n19];
        WritableRaster writableRaster2 = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        byte[] byArray3 = null;
        short[] sArray = null;
        if (n14 > 0) {
            writableRaster2 = this.createRaster(n6, 1, n17, n20, n16);
            nArray2 = writableRaster2.getPixel(0, 0, (int[])null);
            nArray3 = writableRaster2.getPixels(0, 0, n6, 1, (int[])null);
            DataBuffer dataBuffer = writableRaster2.getDataBuffer();
            n8 = dataBuffer.getDataType();
            if (n8 == 0) {
                byArray3 = ((DataBufferByte)dataBuffer).getData();
            } else {
                sArray = ((DataBufferUShort)dataBuffer).getData();
            }
            this.processPassStarted(this.theImage, n, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, n2, n3, n4, n5, this.destinationBands);
            if (this.sourceBands != null) {
                writableRaster2 = writableRaster2.createWritableChild(0, 0, writableRaster2.getWidth(), 1, 0, 0, this.sourceBands);
            }
            if (this.destinationBands != null) {
                writableRaster = writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, this.destinationBands);
            }
        }
        int n21 = 0;
        while (n21 < n7) {
            block25: {
                block26: {
                    int n22;
                    int n23;
                    block24: {
                        this.pixelsDone += n6;
                        this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
                        if (n14 != 0) break block24;
                        this.pixelStream.skipBytes(1 + n19);
                        break block25;
                    }
                    n8 = this.pixelStream.read();
                    this.pixelStream.readFully(byArray, 0, n19);
                    switch (n8) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            PNGImageReader.decodeSubFilter(byArray, 0, n19, n18);
                            break;
                        }
                        case 2: {
                            PNGImageReader.decodeUpFilter(byArray, 0, byArray2, 0, n19);
                            break;
                        }
                        case 3: {
                            PNGImageReader.decodeAverageFilter(byArray, 0, byArray2, 0, n19, n18);
                            break;
                        }
                        case 4: {
                            PNGImageReader.decodePaethFilter(byArray, 0, byArray2, 0, n19, n18);
                            break;
                        }
                        default: {
                            throw new IIOException("Unknown row filter type (= " + n8 + ")!");
                        }
                    }
                    if (n16 < 16) {
                        System.arraycopy(byArray, 0, byArray3, 0, n19);
                    } else {
                        n23 = 0;
                        n22 = 0;
                        while (n22 < n20) {
                            sArray[n22] = (short)(byArray[n23] << 8 | byArray[n23 + 1] & 0xFF);
                            n23 += 2;
                            ++n22;
                        }
                    }
                    n23 = n21 * n5 + n3;
                    if (n23 < this.sourceRegion.y || n23 >= this.sourceRegion.y + this.sourceRegion.height || (n23 - this.sourceRegion.y) % this.sourceYSubsampling != 0) break block26;
                    n22 = this.destinationOffset.y + (n23 - this.sourceRegion.y) / this.sourceYSubsampling;
                    if (n22 < n11) break block25;
                    if (n22 > n12) break;
                    int n24 = (n13 - this.destinationOffset.x) * this.sourceXSubsampling + this.sourceRegion.x;
                    int n25 = (n24 - n2) / n4;
                    int n26 = n15 * this.sourceXSubsampling / n4;
                    if (n26 == 1 && n15 == 1) {
                        writableRaster2.getPixels(n25, 0, n14, 1, nArray3);
                        writableRaster.setPixels(n13, n22, n14, 1, nArray3);
                    } else {
                        int n27 = n13;
                        while (n27 < n13 + n14) {
                            writableRaster2.getPixel(n25, 0, nArray2);
                            writableRaster.setPixel(n27, n22, nArray2);
                            n25 += n26;
                            n27 += n15;
                        }
                    }
                    this.processImageUpdate(this.theImage, n13, n22, n14, 1, n15, 1, this.destinationBands);
                }
                byte[] byArray4 = byArray2;
                byArray2 = byArray;
                byArray = byArray4;
            }
            ++n21;
        }
        if (n14 > 0) {
            this.processPassComplete(this.theImage);
        }
    }

    private void decodeImage() throws IOException, IIOException {
        int n = this.metadata.IHDR_width;
        int n2 = this.metadata.IHDR_height;
        this.pixelsDone = 0;
        this.totalPixels = n * n2;
        if (this.metadata.IHDR_interlaceMethod == 0) {
            this.decodePass(0, 0, 0, 1, 1, n, n2);
        } else {
            int n3 = 0;
            while (n3 <= this.sourceMaxProgressivePass) {
                int n4 = adam7XOffset[n3];
                int n5 = adam7YOffset[n3];
                int n6 = adam7XSubsampling[n3];
                int n7 = adam7YSubsampling[n3];
                int n8 = adam7XSubsampling[n3 + 1] - 1;
                int n9 = adam7YSubsampling[n3 + 1] - 1;
                if (n3 >= this.sourceMinProgressivePass) {
                    this.decodePass(n3, n4, n5, n6, n7, (n + n8) / n6, (n2 + n9) / n7);
                } else {
                    this.skipPass((n + n8) / n6, (n2 + n9) / n7);
                }
                ++n3;
            }
        }
    }

    private void readImage(ImageReadParam imageReadParam) throws IIOException {
        this.readMetadata();
        int n = this.metadata.IHDR_width;
        int n2 = this.metadata.IHDR_height;
        this.sourceRegion = this.getSourceRegion(imageReadParam, n, n2);
        this.sourceXSubsampling = 1;
        this.sourceYSubsampling = 1;
        this.sourceMinProgressivePass = 0;
        this.sourceMaxProgressivePass = 6;
        this.sourceBands = null;
        this.destinationBands = null;
        this.destinationOffset = new Point(0, 0);
        if (imageReadParam != null) {
            this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
            this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
            this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
            this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 6);
            this.sourceBands = imageReadParam.getSourceBands();
            this.destinationBands = imageReadParam.getDestinationBands();
            this.destinationOffset = imageReadParam.getDestinationOffset();
        }
        try {
            this.stream.seek(this.imageStartPosition);
            PNGImageDataEnumeration pNGImageDataEnumeration = new PNGImageDataEnumeration(this.stream);
            InputStream inputStream = new SequenceInputStream(pNGImageDataEnumeration);
            inputStream = new InflaterInputStream(inputStream, new Inflater());
            inputStream = new BufferedInputStream(inputStream);
            this.pixelStream = new DataInputStream(inputStream);
            this.theImage = ImageReader.getDestination(imageReadParam, this.getImageTypes(0), n, n2);
            int n3 = this.metadata.IHDR_colorType;
            this.checkReadParamBandSettings(imageReadParam, inputBandsForColorType[n3], this.theImage.getSampleModel().getNumBands());
            this.processImageStarted(0);
            this.decodeImage();
            this.processImageComplete();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("Error reading PNG image data", iOException);
        }
    }

    public int getNumImages(boolean bl) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("No input source set!");
        }
        return 1;
    }

    public int getWidth(int n) throws IIOException {
        this.readHeader();
        return this.metadata.IHDR_width;
    }

    public int getHeight(int n) throws IIOException {
        this.readHeader();
        return this.metadata.IHDR_height;
    }

    public Iterator getImageTypes(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readHeader();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        int n2 = this.metadata.IHDR_bitDepth;
        int n3 = this.metadata.IHDR_colorType;
        int n4 = n2 <= 8 ? 0 : 1;
        switch (n3) {
            case 0: {
                arrayList.add(ImageTypeSpecifier.createGrayscale(n2, n4, false));
                break;
            }
            case 2: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, false, false));
                break;
            }
            case 3: {
                this.readMetadata();
                byte[] byArray = null;
                if (this.metadata.tRNS_alpha != null) {
                    if (this.metadata.tRNS_alpha.length == this.metadata.PLTE_red.length) {
                        byArray = this.metadata.tRNS_alpha;
                    } else {
                        byArray = new byte[this.metadata.PLTE_red.length];
                        System.arraycopy(this.metadata.tRNS_alpha, 0, byArray, 0, this.metadata.tRNS_alpha.length);
                        Arrays.fill(byArray, this.metadata.tRNS_alpha.length, this.metadata.PLTE_red.length, (byte)-1);
                    }
                }
                arrayList.add(ImageTypeSpecifier.createIndexed(this.metadata.PLTE_red, this.metadata.PLTE_green, this.metadata.PLTE_blue, byArray, n2, 0));
                break;
            }
            case 4: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{0, 1};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, true, false));
                break;
            }
            case 6: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{0, 1, 2, 3};
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, n4, true, false));
                break;
            }
        }
        return ((AbstractList)arrayList).iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam(false);
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int n) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readMetadata();
        return this.metadata;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IIOException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0!");
        }
        this.readImage(imageReadParam);
        return this.theImage;
    }

    public void reset() {
        super.reset();
        this.gotHeader = false;
        this.gotMetadata = false;
        this.metadata = null;
        this.pixelStream = null;
    }
}

