/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    public abstract void write(int var1) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        if (this.networkByteOrder) {
            this.write(n >>> 8 & 0xFF);
            this.write(n >>> 0 & 0xFF);
        } else {
            this.write(n >>> 0 & 0xFF);
            this.write(n >>> 8 & 0xFF);
        }
    }

    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeInt(int n) throws IOException {
        if (this.networkByteOrder) {
            this.write(n >>> 24 & 0xFF);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n >>> 0 & 0xFF);
        } else {
            this.write(n >>> 0 & 0xFF);
            this.write(n >>> 8 & 0xFF);
            this.write(n >>> 16 & 0xFF);
            this.write(n >>> 24 & 0xFF);
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.networkByteOrder) {
            this.write((int)(l >>> 56) & 0xFF);
            this.write((int)(l >>> 48) & 0xFF);
            this.write((int)(l >>> 40) & 0xFF);
            this.write((int)(l >>> 32) & 0xFF);
            this.write((int)(l >>> 24) & 0xFF);
            this.write((int)(l >>> 16) & 0xFF);
            this.write((int)(l >>> 8) & 0xFF);
            this.write((int)(l >>> 0) & 0xFF);
        } else {
            this.write((int)(l >>> 0) & 0xFF);
            this.write((int)(l >>> 8) & 0xFF);
            this.write((int)(l >>> 16) & 0xFF);
            this.write((int)(l >>> 24) & 0xFF);
            this.write((int)(l >>> 32) & 0xFF);
            this.write((int)(l >>> 40) & 0xFF);
            this.write((int)(l >>> 48) & 0xFF);
            this.write((int)(l >>> 56) & 0xFF);
        }
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n5;
        }
        this.write(byArray);
    }

    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > sArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                short s = sArray[n + n4];
                byArray[n3++] = (byte)(s >>> 8);
                byArray[n3++] = (byte)(s >>> 0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                short s = sArray[n + n5];
                byArray[n3++] = (byte)(s >>> 0);
                byArray[n3++] = (byte)(s >>> 8);
                ++n5;
            }
        }
        this.write(byArray, 0, n2 * 2);
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > cArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                char c = cArray[n + n4];
                byArray[n3++] = (byte)(c >>> 8);
                byArray[n3++] = (byte)(c >>> 0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                char c = cArray[n + n5];
                byArray[n3++] = (byte)(c >>> 0);
                byArray[n3++] = (byte)(c >>> 8);
                ++n5;
            }
        }
        this.write(byArray, 0, n2 * 2);
    }

    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > nArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = nArray[n + n4];
                byArray[n3++] = (byte)(n5 >>> 24);
                byArray[n3++] = (byte)(n5 >>> 16);
                byArray[n3++] = (byte)(n5 >>> 8);
                byArray[n3++] = (byte)(n5 >>> 0);
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = nArray[n + n6];
                byArray[n3++] = (byte)(n7 >>> 0);
                byArray[n3++] = (byte)(n7 >>> 8);
                byArray[n3++] = (byte)(n7 >>> 16);
                byArray[n3++] = (byte)(n7 >>> 24);
                ++n6;
            }
        }
        this.write(byArray, 0, n2 * 4);
    }

    public void writeLongs(long[] lArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > lArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 8];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                long l = lArray[n + n4];
                byArray[n3++] = (byte)(l >>> 56);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                long l = lArray[n + n5];
                byArray[n3++] = (byte)(l >>> 0);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 56);
                ++n5;
            }
        }
        this.write(byArray, 0, n2 * 8);
    }

    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > fArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = Float.floatToIntBits(fArray[n + n4]);
                byArray[n3++] = (byte)(n5 >>> 24);
                byArray[n3++] = (byte)(n5 >>> 16);
                byArray[n3++] = (byte)(n5 >>> 8);
                byArray[n3++] = (byte)(n5 >>> 0);
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = Float.floatToIntBits(fArray[n + n6]);
                byArray[n3++] = (byte)(n7 >>> 0);
                byArray[n3++] = (byte)(n7 >>> 8);
                byArray[n3++] = (byte)(n7 >>> 16);
                byArray[n3++] = (byte)(n7 >>> 24);
                ++n6;
            }
        }
        this.write(byArray, 0, n2 * 4);
    }

    public void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > dArray.length) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2 * 8];
        int n3 = 0;
        if (this.networkByteOrder) {
            int n4 = 0;
            while (n4 < n2) {
                long l = Double.doubleToLongBits(dArray[n + n4]);
                byArray[n3++] = (byte)(l >>> 56);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 0);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                long l = Double.doubleToLongBits(dArray[n + n5]);
                byArray[n3++] = (byte)(l >>> 0);
                byArray[n3++] = (byte)(l >>> 8);
                byArray[n3++] = (byte)(l >>> 16);
                byArray[n3++] = (byte)(l >>> 24);
                byArray[n3++] = (byte)(l >>> 32);
                byArray[n3++] = (byte)(l >>> 40);
                byArray[n3++] = (byte)(l >>> 48);
                byArray[n3++] = (byte)(l >>> 56);
                ++n5;
            }
        }
        this.write(byArray, 0, n2 * 8);
    }

    public void writeBit(int n) throws IOException {
        this.writeBits(1L & (long)n, 1);
    }

    public void writeBits(long l, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        this.checkClosed();
        if (this.bitOffset != 0) {
            n5 = this.bitOffset;
            n4 = this.read();
            this.seek(this.getStreamPosition() - 1L);
            if (n + n5 < 8) {
                n3 = 8 - (n5 + n);
                n2 = -1 >>> 32 - n;
                n4 &= ~(n2 << n3);
                n4 = (int)((long)n4 | (l & (long)n2) << n3);
                this.write(n4);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = n5 + n;
                n = 0;
            } else {
                n3 = 8 - n5;
                n2 = -1 >>> 32 - n3;
                n4 &= ~n2;
                n4 = (int)((long)n4 | l >> n - n3 & (long)n2);
                this.write(n4);
                n -= n3;
            }
        }
        if (n > 7) {
            n5 = n % 8;
            n4 = n / 8;
            while (n4 > 0) {
                n3 = (n4 - 1) * 8 + n5;
                n2 = n3 == 0 ? (int)(l & 0xFFL) : (int)(l >> n3 & 0xFFL);
                this.write(n2);
                --n4;
            }
            n = n5;
        }
        if (n != 0) {
            n5 = 0;
            try {
                n5 = this.read();
                this.seek(this.getStreamPosition() - 1L);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n5 = 0;
            }
            int n6 = 8 - n;
            n3 = -1 >>> 32 - n;
            n5 &= ~(n3 << n6);
            n5 = (int)((long)n5 | (l & (long)n3) << n6);
            this.write(n5);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = n;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int n = this.bitOffset;
            int n2 = this.read();
            this.seek(this.getStreamPosition() - 1L);
            this.write(n2 &= ~(-1 >> 24 + n));
        }
    }
}

