/*
 * Decompiled with CFR 0.152.
 */
package iDSS;

import iDSS.disp.DisplayFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VerticalSlider
extends DisplayFrame
implements ChangeListener,
ActionListener {
    private JTextField sliderLabel;
    private JTextField movementLabel;
    private JSlider slider;
    private String units;
    private JTextField dependentTextField;
    private JButton selectButton;

    public VerticalSlider(String string, int n, int n2, int n3, String string2, JTextField jTextField) {
        super(string, true, false, false, true, null);
        this.setBackground(Color.lightGray);
        this.slider = new JSlider(1, n, n2, n3);
        this.units = string2;
        if (jTextField != null) {
            this.dependentTextField = jTextField;
        }
        this.slider.setMajorTickSpacing((n2 - n) / 5);
        this.slider.setMinorTickSpacing((n2 - n) / 100);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        this.slider.setAlignmentY(10.0f);
        this.sliderLabel = new JTextField(string);
        this.movementLabel = new JTextField(Integer.toString(n3) + " " + this.units);
        this.sliderLabel.setHorizontalAlignment(0);
        this.movementLabel.setHorizontalAlignment(0);
        this.sliderLabel.setEditable(false);
        this.movementLabel.setEditable(false);
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("select");
        this.selectButton.setHorizontalTextPosition(0);
        this.selectButton.setHorizontalAlignment(0);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.sliderLabel);
        this.getContentPane().add(this.slider);
        this.getContentPane().add(this.movementLabel);
        this.getContentPane().add(this.selectButton);
        this.pack();
        this.setVisible(true);
        Dimension dimension = this.getSize();
        if (dimension.height > 5) {
            dimension.height -= 5;
            this.setSize(dimension);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("select")) {
            this.firePropertyChange("setIsostaticMovement", null, new Integer(this.slider.getValue()));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.slider && this.slider.getValueIsAdjusting()) {
            int n = this.slider.getValue();
            this.movementLabel.setText(Integer.toString(n) + " " + this.units);
            if (this.dependentTextField != null) {
                this.dependentTextField.setText(Integer.toString(n) + " " + this.units);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Canvas test");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        VerticalSlider verticalSlider = new VerticalSlider("Select Isostatic\nMovement", -50, 50, 0, "mm/year", null);
        JDesktopPane jDesktopPane = new JDesktopPane();
        jDesktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        jDesktopPane.add(verticalSlider);
        jFrame.setContentPane(jDesktopPane);
        jFrame.pack();
        ((Component)jFrame).setSize(600, 500);
        ((Component)jFrame).setVisible(true);
    }
}

