/*
 * Decompiled with CFR 0.152.
 */
package iDSS.grids;

import iDSS.grids.GenericGrid;
import iDSS.grids.Grid;
import iDSS.grids.Grid2;
import iDSS.grids.GridCell;
import iDSS.grids.LandCover;
import iDSS.sm.SurvivalModel;
import iDSS.utils.FileNameDialog;
import iDSS.utils.ObjectReadWrite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class LCGrid2
implements GenericGrid,
Serializable {
    private String name;
    private int units;
    private final int UNKNOWN = 0;
    private final int FT = 1;
    private final int IN = 2;
    private final int M = 3;
    private final int MM = 4;
    private double cellSize;
    private int nRows;
    private int nColumns;
    private double xLLCorner;
    private double yLLCorner;
    private double xURCorner;
    private double yURCorner;
    private double xLLC;
    private double yLLC;
    private double xURC;
    private double yURC;
    private String fileName = "";
    private File file;
    private boolean gridReadDone = false;
    private Vector z;

    public LCGrid2(String string, File file, Grid grid, Hashtable hashtable) {
        System.out.println("Creating LCGrid2 " + string);
        this.name = string;
        if (file != null) {
            this.file = file;
            this.fileName = file.toString();
        }
        this.units = grid.getUnits();
        this.nRows = grid.getNRows();
        this.nColumns = grid.getNColumns();
        this.cellSize = grid.getCellSize();
        this.xLLCorner = grid.getxLLCorner();
        this.yLLCorner = grid.getyLLCorner();
        this.xURCorner = (double)(this.nColumns - 1) * this.cellSize;
        this.yURCorner = (double)(this.nRows - 1) * this.cellSize;
        this.xLLC = this.xLLCorner + this.cellSize / 2.0;
        this.yLLC = this.yLLCorner + this.cellSize / 2.0;
        this.xURC = this.xLLC + (double)(this.nColumns - 1) * this.cellSize;
        this.yURC = this.yLLC + (double)(this.nRows - 1) * this.cellSize;
        this.z = new Vector();
        int n = 0;
        while (n < this.nRows) {
            Vector<LandCover> vector = new Vector<LandCover>();
            int n2 = 0;
            while (n2 < this.nColumns) {
                int n3 = grid.getIntValue(n2, n);
                System.out.println("lcId : " + n3);
                String string2 = String.valueOf(n3);
                if (!string2.endsWith(".0")) {
                    string2 = string2 + ".0";
                }
                System.out.println("lcString : " + string2);
                String string3 = (String)hashtable.get(string2);
                System.out.println("LCGrid2.constructor(..), smFileName : " + string3);
                File file2 = new File(string3);
                if (file2 == null) {
                    System.out.println("LCGrid2.constructor(..), file not made from " + string3);
                } else {
                    System.out.println("LCGrid2.constructor(..), file made from " + string3);
                }
                SurvivalModel survivalModel = (SurvivalModel)ObjectReadWrite.read(file2);
                if (survivalModel == null) {
                    System.out.println("LCGrid2.constructor(..), sm not read from file");
                } else {
                    System.out.println("LCGrid2.constructor(..), sm read from file");
                }
                LandCover landCover = new LandCover(n3, survivalModel);
                vector.add(landCover);
                ++n2;
            }
            this.z.add(vector);
            ++n;
        }
        System.out.println("nRows/nColumns : " + this.nRows + "/" + this.nColumns);
    }

    public LCGrid2() {
        this.name = "";
        this.file = null;
        this.fileName = null;
        this.units = 0;
        this.nRows = 0;
        this.nColumns = 0;
        this.cellSize = 0.0;
        this.xLLCorner = 0.0;
        this.yLLCorner = 0.0;
        this.xURCorner = 0.0;
        this.yURCorner = 0.0;
        this.xLLC = 0.0;
        this.yLLC = 0.0;
        this.xURC = 0.0;
        this.yURC = 0.0;
        this.z = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public LandCover getLandCover(int n, int n2) {
        LandCover landCover = null;
        if (n >= 0 && n < this.nColumns && n2 >= 0 && n2 < this.nRows) {
            Vector vector = (Vector)this.z.elementAt(n2);
            landCover = (LandCover)vector.elementAt(n);
        } else {
            System.out.println("LCGrid2.getLandCover(), i,j : " + n + "," + n2);
            System.out.println("LCGrid2.getLandCover(), nColumns,nRows : " + this.nColumns + "," + this.nRows);
        }
        return landCover;
    }

    private void setLandCoverAt(int n, int n2, LandCover landCover) {
        Vector vector = (Vector)this.z.elementAt(n2);
        vector.remove(n);
        vector.insertElementAt(landCover, n);
        this.z.remove(n2);
        this.z.insertElementAt(vector, n2);
    }

    public void setFile(File file) {
        if (file != null) {
            this.file = file;
            this.fileName = file.toString();
        }
    }

    public void appendHistory(Grid2 grid2, int n) {
        int n2 = 0;
        while (n2 < this.z.size()) {
            Vector vector = (Vector)this.z.elementAt(n2);
            int n3 = 0;
            while (n3 < vector.size()) {
                LandCover landCover = (LandCover)vector.elementAt(n3);
                GridCell gridCell = grid2.getGridCell(n3, n2);
                landCover.appendHistory(n, gridCell);
                ++n3;
            }
            ++n2;
        }
    }

    public void writeLCGrid2Object() {
        block12: {
            if (this.file != null) {
                try {
                    if (this.file.exists()) {
                        int n = JOptionPane.showConfirmDialog(null, "File already exists, overwrite?", "Confirm file overwrite", 1, 3);
                        switch (n) {
                            case 0: {
                                this.file.delete();
                                break;
                            }
                            case 1: {
                                this.file = FileNameDialog.getOutputFileName("Pick output file", null, null);
                                break;
                            }
                            case 2: {
                                this.file = null;
                                break;
                            }
                        }
                    }
                    if (this.file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(this);
                        objectOutputStream.flush();
                        fileOutputStream.close();
                        break block12;
                    }
                    System.out.println("Failed to create file " + this.file.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.print("In LCGrid2.writeGridObject()");
                    System.out.println("File not found : " + fileNotFoundException);
                }
                catch (IOException iOException) {
                    System.out.print("In LCGrid2.writeGridObject()");
                    System.out.println("IOException : " + iOException);
                }
            } else {
                JOptionPane.showMessageDialog(null, "LCGrid2 couldn't write, file is null", "Warning", 2);
            }
        }
    }

    public static LCGrid2 readLCGrid2Object(File file) {
        LCGrid2 lCGrid2 = new LCGrid2();
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                lCGrid2 = (LCGrid2)objectInputStream.readObject();
                fileInputStream.close();
            } else {
                System.out.println("Input file " + file.toString() + " doesn't exist");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.print("In LCGrid2.readGridObject()");
            System.out.println("File not found : " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.print("In LCGrid2.readGridObject()");
            System.out.println("IOException : " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.print("In LCGrid2.readGridObject()");
            System.out.println("ClassNotFoundException : " + classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            System.out.println("ClassCastException : " + classCastException);
            return null;
        }
        lCGrid2.gridIsRead(true);
        return lCGrid2;
    }

    public boolean isGridRead() {
        return this.gridReadDone;
    }

    private void gridIsRead(boolean bl) {
        this.gridReadDone = bl;
    }

    public void describe() {
        System.out.println("Describing LCGrid2");
        System.out.println("\nName        = " + this.name + "\nnRows       = " + this.nRows + "\nnColumns    = " + this.nColumns + "\nxLLCorner   = " + this.xLLCorner + "\nyLLCorner   = " + this.yLLCorner + "\ncellSize    = " + this.cellSize);
    }

    public Grid getGrid(String string, int n) {
        Grid grid = new Grid(this.name + ":" + string + ":" + n, 1, this.units, null);
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.z.size()) {
            Vector vector2 = (Vector)this.z.elementAt(n2);
            Vector<String> vector3 = new Vector<String>();
            int n3 = 0;
            while (n3 < vector2.size()) {
                LandCover landCover = (LandCover)vector2.elementAt(n3);
                String string2 = landCover.getValue(n, string);
                vector3.add(string2);
                ++n3;
            }
            vector.add(vector3);
            ++n2;
        }
        grid.setGrid(this.xLLCorner, this.yLLCorner, this.cellSize, vector, this.nRows, this.nColumns);
        grid.gridIsRead(true);
        return grid;
    }

    public Vector getGridVector() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.name);
        vector.add(this.fileName);
        return vector;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SurvivalModel getSurvivalModel(int n, int n2) {
        LandCover landCover = this.getLandCover(n, n2);
        SurvivalModel survivalModel = landCover.getSurvivalModel();
        return survivalModel;
    }

    public Enumeration getYears() {
        Vector vector;
        Enumeration enumeration = null;
        if (this.z.size() > 0 && (vector = (Vector)this.z.elementAt(0)).size() > 0) {
            LandCover landCover = (LandCover)vector.elementAt(0);
            enumeration = landCover.getYears();
        }
        return enumeration;
    }
}

