/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sim;

import java.util.Vector;

public class InputValidation {
    private String simName = "";
    private String timestepString = "";
    private String resultStep = "";
    private String coordsString = "";
    private String simulateUntil = "";

    public void setSimName(String string) {
        this.simName = string;
    }

    public void setTimestepString(String string) {
        this.timestepString = string;
    }

    public void setResultStep(String string) {
        this.resultStep = string;
    }

    public void setCoordsString(String string) {
        this.coordsString = string;
    }

    public void setSimulateUntil(String string) {
        this.simulateUntil = string;
    }

    public String getSimName() {
        return this.simName;
    }

    public String getTimestepString() {
        return this.timestepString;
    }

    public String getResultStep() {
        return this.resultStep;
    }

    public String getCoordsString() {
        return this.coordsString;
    }

    public String getSimulateUntil() {
        return this.simulateUntil;
    }

    public Vector validateInput() {
        int n;
        boolean bl = true;
        if (this.simName == null) {
            String string = "Missing simulation name";
            System.out.println("simName = null, " + string);
            bl = false;
            Vector vector = this.makeMessage(bl, string);
            return vector;
        }
        if (this.simName.length() < 1) {
            String string = "Missing simulation name";
            System.out.println("simName.length() < 1, " + string);
            bl = false;
            Vector vector = this.makeMessage(bl, string);
            return vector;
        }
        if (this.timestepString == null) {
            String string = "Missing time step";
            bl = false;
            return this.makeMessage(bl, string);
        }
        try {
            n = Integer.parseInt(this.timestepString);
            n *= 60;
        }
        catch (NumberFormatException numberFormatException) {
            String string = numberFormatException.toString() + ". Simulation timestep must be a positive non-zero integer";
            bl = false;
            return this.makeMessage(bl, string);
        }
        if (this.resultStep == null) {
            String string = "Missing results step";
            bl = false;
            return this.makeMessage(bl, string);
        }
        try {
            n = Integer.parseInt(this.resultStep);
        }
        catch (NumberFormatException numberFormatException) {
            String string = numberFormatException.toString() + ". Results timestep must be a positive non-zero integer";
            bl = false;
            return this.makeMessage(bl, string);
        }
        if (this.coordsString == null) {
            String string = "Missing flood start points";
            bl = false;
            return this.makeMessage(bl, string);
        }
        if (this.coordsString.length() < 3) {
            String string = "Missing flood start points";
            bl = false;
            return this.makeMessage(bl, string);
        }
        Vector vector = this.makeMessage(bl, "All inputs valid");
        return vector;
    }

    private Vector makeMessage(boolean bl, String string) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Boolean(bl));
        vector.add(string);
        System.out.println("makeMessage(), s : " + string);
        return vector;
    }
}

