/*
 * Decompiled with CFR 0.152.
 */
package iDSS.slr;

import iDSS.beans2.ScenarioListJBean;
import iDSS.disp.DisplayFrame;
import iDSS.disp.DocumentDisplay;
import iDSS.slr.ScenarioDetail;
import iDSS.tables.GeneralTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScenarioList
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private JTable aTable;
    private JScrollPane aScrollPane;
    private JButton storeyLineButton;
    private JButton scenarioButton;
    private JButton selectButton;
    private JPanel buttonPanel;
    private boolean ALLOW_ROW_SELECTION = true;
    private Vector columnNames;
    private Vector rowsOfData;
    private String scenarioName;
    private String storeyLineName;
    private String scenarioTable;
    private JTextField scenarioTextField;
    private ScenarioListJBean scenarioListJBean = new ScenarioListJBean();

    public ScenarioList(String string) {
        super("IPCC SLR Scenarios", false, false, false, true, null);
        this.scenarioListJBean.addPropertyChangeListener(this);
        this.rowsOfData = this.scenarioListJBean.getScenarios();
        this.columnNames = new Vector();
        this.columnNames.add("Scenario Name");
        this.columnNames.add("Storey Line");
        this.columnNames.add("Scenarios Table");
        GeneralTableModel generalTableModel = new GeneralTableModel(this.rowsOfData, this.columnNames);
        this.aTable = new JTable(generalTableModel);
        this.aTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.aTable.setSelectionMode(0);
        this.aScrollPane = new JScrollPane(this.aTable);
        this.storeyLineButton = new JButton("Read Storyline");
        this.scenarioButton = new JButton("GetScenario");
        this.storeyLineButton.addActionListener(this);
        this.scenarioButton.addActionListener(this);
        this.storeyLineButton.setActionCommand("readStoryline");
        this.scenarioButton.setActionCommand("getScenario");
        this.storeyLineButton.setEnabled(false);
        this.scenarioButton.setEnabled(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.storeyLineButton);
        this.buttonPanel.add(this.scenarioButton);
        this.getContentPane().add((Component)this.aScrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setVisible(true);
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.aTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        ScenarioList.this.storeyLineButton.setEnabled(false);
                        ScenarioList.this.scenarioButton.setEnabled(false);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        ScenarioList.this.storeyLineButton.setEnabled(true);
                        ScenarioList.this.scenarioButton.setEnabled(true);
                        ScenarioList.this.scenarioName = (String)ScenarioList.this.aTable.getValueAt(n, 0);
                        ScenarioList.this.storeyLineName = (String)ScenarioList.this.aTable.getValueAt(n, 1);
                        ScenarioList.this.scenarioTable = (String)ScenarioList.this.aTable.getValueAt(n, 2);
                        System.out.println("scenarioName,storeyLineName,scenarioTable : \n" + ScenarioList.this.scenarioName + ", " + ScenarioList.this.storeyLineName + ", " + ScenarioList.this.scenarioTable);
                    }
                }
            });
        } else {
            this.aTable.setRowSelectionAllowed(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("readStoryline")) {
            DocumentDisplay documentDisplay = this.scenarioListJBean.getStoreyLine("Scenario Details: " + this.scenarioName, this.storeyLineName);
            this.firePropertyChange("addToModelView", null, documentDisplay);
        } else if (actionEvent.getActionCommand().equals("getScenario")) {
            ScenarioDetail scenarioDetail = this.scenarioListJBean.getScenarioDetail(this.scenarioName);
            scenarioDetail.removePropertyChangeListener(this);
            scenarioDetail.addPropertyChangeListener(this);
            this.firePropertyChange("addToModelView", null, scenarioDetail);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("setSLRScenario")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

