/*
 * Decompiled with CFR 0.152.
 */
package iDSS.tables;

import iDSS.tables.GeneralTableModel;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScrollingTable {
    private JScrollPane scrollPane;
    private JTable table;
    private Vector columns;
    private Vector rows;
    private boolean ALLOW_ROW_SELECTION;
    private boolean ALLOW_COL_SELECTION;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ScrollingTable(Vector vector, Vector vector2, int n, int n2, boolean bl, boolean bl2) {
        this.columns = vector;
        this.rows = vector2;
        this.ALLOW_ROW_SELECTION = bl;
        this.ALLOW_COL_SELECTION = bl2;
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        this.table = new JTable(generalTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(n, n2));
        this.table.setSelectionMode(0);
        this.handleRowSelection();
        this.handleColSelection();
        this.scrollPane = new JScrollPane(this.table, 20, 30);
    }

    private void handleRowSelection() {
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("ScrollingTable.handleRowSelection(), No rows are selected.");
                        ScrollingTable.this.pcs.firePropertyChange("noRowsSelected", null, new Vector());
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("ScrollingTable.handleRowSelection(), Row " + n + " is now selected.");
                        GeneralTableModel generalTableModel = (GeneralTableModel)ScrollingTable.this.table.getModel();
                        Vector vector = generalTableModel.getRow(n);
                        ScrollingTable.this.pcs.firePropertyChange("oneRowSelected", null, vector);
                    }
                }
            });
        } else {
            this.table.setRowSelectionAllowed(false);
        }
    }

    private void handleColSelection() {
        if (this.ALLOW_COL_SELECTION) {
            if (this.ALLOW_ROW_SELECTION) {
                this.table.setCellSelectionEnabled(true);
            }
            this.table.setColumnSelectionAllowed(this.ALLOW_COL_SELECTION);
            ListSelectionModel listSelectionModel = this.table.getColumnModel().getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("ScrollingTable.handleColSelection(), No columns are selected.");
                        ScrollingTable.this.pcs.firePropertyChange("noColsSelected", null, new Integer(-1));
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("ScrollingTable.handleColSelection(), Column " + n + " is now selected.");
                        ScrollingTable.this.pcs.firePropertyChange("oneColSelected", null, new Integer(n));
                    }
                }
            });
        }
    }

    public Vector getColumns() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        this.columns = generalTableModel.getColumns();
        return this.columns;
    }

    public void setEditableColumn(int n) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.setEditableColumn(n);
    }

    public void setEditableColumn(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.setEditableColumn(vector);
    }

    public int getNumberOfRows() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        return generalTableModel.getNumberOfRows();
    }

    public void addRow(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.addRow(vector);
        this.table.setModel(generalTableModel);
    }

    public void addRows(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            this.addRow(vector2);
            ++n;
        }
    }

    public void removeRow(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.removeRow(vector);
        this.table.setModel(generalTableModel);
    }

    public Vector getRowsVector() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        Vector vector = generalTableModel.getRowsVector();
        return vector;
    }

    public Vector getRow(int n) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        Vector vector = generalTableModel.getRow(n);
        return vector;
    }

    public int getColumnCount() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        return generalTableModel.getColumnCount();
    }

    public int getRowCount() {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        return generalTableModel.getRowCount();
    }

    public String getColumnName(int n) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        return generalTableModel.getColumnName(n);
    }

    public Object getValueAt(int n, int n2) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        return generalTableModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.table.getModel();
        generalTableModel.setValueAt(object, n, n2);
        this.table.setModel(generalTableModel);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

