/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Driver;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public abstract class Connection {
    MysqlIO _IO;
    private boolean _isClosed = true;
    private String _Host;
    private int _port = 3306;
    private String _User;
    private String _Password;
    protected String _Database;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _do_unicode = false;
    private String _Encoding;
    private String _MyURL;
    private int _max_rows = -1;
    private boolean _max_rows_changed = false;
    private Driver _MyDriver;
    private Hashtable _ServerVariables;
    private int _max_allowed_packet = 65536;
    private int _net_buffer_length = 16384;
    private boolean _use_fast_ping = false;
    private boolean _high_availability = false;
    private int _max_reconnects = 3;
    private double _initial_timeout = 2.0;
    private static final String _PING_COMMAND = "SELECT 1";
    private boolean transactionsSupported = false;

    public void connectionInit(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        int n2;
        this._Host = string == null ? "localhost" : new String(string);
        this._port = n;
        if (string2 == null) {
            throw new SQLException("Malformed URL '" + string3 + "'.", "S1000");
        }
        this._Database = new String(string2);
        this._MyURL = new String(string3);
        this._MyDriver = driver;
        String string4 = properties.getProperty("user");
        String string5 = properties.getProperty("password");
        this._User = string4 == null || string4.equals("") ? "nobody" : new String(string4);
        this._Password = string5 == null ? "" : new String(string5);
        if (properties.getProperty("autoReconnect") != null) {
            this._high_availability = properties.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (this._high_availability) {
            if (properties.getProperty("maxReconnects") != null) {
                try {
                    this._max_reconnects = n2 = Integer.parseInt(properties.getProperty("maxReconnects"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (properties.getProperty("initialTimeout") != null) {
                try {
                    double d;
                    this._initial_timeout = d = (double)Integer.parseInt(properties.getProperty("intialTimeout"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + properties.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (properties.getProperty("maxRows") != null) {
            try {
                n2 = Integer.parseInt(properties.getProperty("maxRows"));
                if (n2 == 0) {
                    n2 = -1;
                }
                this._max_rows = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Illegal parameter '" + properties.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (properties.getProperty("useUnicode") != null) {
            String string6 = properties.getProperty("useUnicode").toUpperCase();
            if (string6.startsWith("TRUE")) {
                this._do_unicode = true;
            }
            if (properties.getProperty("characterEncoding") != null) {
                this._Encoding = properties.getProperty("characterEncoding");
                try {
                    "abc".getBytes(this._Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Unsupported character encoding '" + this._Encoding + "'.", "0S100");
                }
            }
        }
        try {
            block41: {
                Statement statement;
                block40: {
                    this._IO = this.createNewIO(string, n);
                    this._IO.init(this._User, this._Password);
                    if (this._Database.length() != 0) {
                        this._IO.sendCommand(2, this._Database, null);
                    }
                    this._isClosed = false;
                    this._ServerVariables = new Hashtable();
                    if (this._IO.versionMeetsMinimum(3, 22, 1)) {
                        this._use_fast_ping = true;
                    }
                    if (!this._IO.versionMeetsMinimum(3, 21, 22)) break block41;
                    statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = (Statement)((Object)this.createStatement());
                        resultSet = (ResultSet)((Object)statement.executeQuery("SHOW VARIABLES"));
                        while (resultSet.next()) {
                            this._ServerVariables.put(resultSet.getString(1), resultSet.getString(2));
                        }
                        Object var12_17 = null;
                        if (resultSet == null) break block40;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this._ServerVariables.containsKey("max_allowed_packet")) {
                    this._max_allowed_packet = Integer.parseInt((String)this._ServerVariables.get("max_allowed_packet"));
                }
                if (this._ServerVariables.containsKey("net_buffer_length")) {
                    this._net_buffer_length = Integer.parseInt((String)this._ServerVariables.get("net_buffer_length"));
                }
            }
            if (this._IO.versionMeetsMinimum(3, 23, 15)) {
                this.transactionsSupported = true;
                return;
            }
            this.transactionsSupported = false;
            return;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Cannot connect to MySQL server on " + this._Host + ":" + this._port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + exception.getClass().getName() + ")", "08S01");
        }
    }

    public abstract java.sql.Statement createStatement() throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("Callable statments not suppoted.", "S1C00");
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.transactionsSupported) {
            String string = "SET autocommit=" + (bl ? "1" : "0");
            this.execSQL(string, -1);
            this._autoCommit = bl;
            return;
        }
        if (!bl) {
            throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    public void commit() throws SQLException {
        if (this._autoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this.transactionsSupported) {
            this.execSQL("commit", -1);
        }
    }

    public void rollback() throws SQLException {
        if (this._autoCommit) {
            throw new SQLException("Can't call commit when autocommit=true", "08003");
        }
        if (this.transactionsSupported) {
            this.execSQL("rollback", -1);
        }
        if (this._isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
    }

    public void close() throws SQLException {
        if (this._IO != null) {
            try {
                this._IO.quit();
            }
            catch (Exception exception) {}
            this._IO = null;
        }
        this._isClosed = true;
    }

    public boolean isClosed() throws SQLException {
        if (!this._isClosed) {
            try {
                MysqlIO mysqlIO = this._IO;
                synchronized (mysqlIO) {
                    this.execSQL(_PING_COMMAND, -1);
                }
            }
            catch (Exception exception) {
                this._isClosed = true;
            }
        }
        return this._isClosed;
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void setReadOnly(boolean bl) throws SQLException {
        this._readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this._readOnly;
    }

    public void setCatalog(String string) throws SQLException {
        this.execSQL("USE " + string, -1);
        this._Database = string;
    }

    public String getCatalog() throws SQLException {
        return this._Database;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        throw new SQLException("Transaction Isolation Levels are not supported.", "S1C00");
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    ResultSet execSQL(String string, int n) throws SQLException {
        return this.execSQL(string, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResultSet execSQL(String string, int n, Buffer buffer) throws SQLException {
        MysqlIO mysqlIO = this._IO;
        synchronized (mysqlIO) {
            block21: {
                if (this._high_availability) {
                    int n2;
                    boolean bl;
                    double d;
                    try {
                        if (this._use_fast_ping) {
                            this._IO.sendCommand(14, null, null);
                            break block21;
                        } else {
                            this._IO.sqlQuery(_PING_COMMAND, 50000000);
                        }
                        break block21;
                    }
                    catch (Exception exception) {
                        d = this._initial_timeout;
                        bl = false;
                        n2 = 0;
                    }
                    while (n2 < this._max_reconnects) {
                        try {
                            this._IO = this.createNewIO(this._Host, this._port);
                            this._IO.init(this._User, this._Password);
                            if (this._Database.length() != 0) {
                                this._IO.sendCommand(2, this._Database, null);
                            }
                            if (this._use_fast_ping) {
                                this._IO.sendCommand(14, null, null);
                            } else {
                                this._IO.sqlQuery(_PING_COMMAND, 50000000);
                            }
                            bl = true;
                            break;
                        }
                        catch (Exception exception) {
                            try {
                                Thread.currentThread();
                                Thread.sleep((long)d * 1000L);
                                d *= d;
                            }
                            catch (InterruptedException interruptedException) {}
                            ++n2;
                        }
                    }
                    if (!bl) {
                        throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this._max_reconnects + " times. Giving up.", "08001");
                    }
                }
            }
            try {
                int n3 = n == -1 ? 50000000 : n;
                if (buffer != null) return this._IO.sqlQueryDirect(buffer, n3, this);
                String string2 = null;
                if (!this.useUnicode()) return this._IO.sqlQuery(string, n3, string2, this);
                string2 = this.getEncoding();
                return this._IO.sqlQuery(string, n3, string2, this);
            }
            catch (EOFException eOFException) {
                throw new SQLException("Lost connection to server during query", "08007");
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                String string3 = exception.getClass().getName();
                String string4 = exception.getMessage();
                throw new SQLException("Error during query: Unexpected Exception: " + string3 + " message given: " + string4, "S1000");
            }
        }
    }

    protected abstract MysqlIO createNewIO(String var1, int var2) throws Exception;

    String getURL() {
        return this._MyURL;
    }

    String getUser() {
        return this._User;
    }

    String getServerVersion() {
        return this._IO.getServerVersion();
    }

    int getServerMajorVersion() {
        return this._IO.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this._IO.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this._IO.getServerSubMinorVersion();
    }

    void maxRowsChanged() {
        this._max_rows_changed = true;
    }

    boolean useMaxRows() {
        return this._max_rows_changed;
    }

    public boolean useUnicode() {
        return this._do_unicode;
    }

    public String getEncoding() {
        return this._Encoding;
    }

    Object getMutex() {
        return this._IO;
    }

    int getMaxAllowedPacket() {
        return this._max_allowed_packet;
    }

    int getNetBufferLength() {
        return this._net_buffer_length;
    }
}

