/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.imageio.plugins.gif.GIFStreamMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.awt.image.BytePackedRaster;

public class GIFImageReader
extends ImageReader {
    ImageInputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int imageMetadataLength;
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    BufferedImage theImage = null;
    WritableRaster theTile = null;
    int width = -1;
    int height = -1;
    int x = -1;
    int y = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    private static boolean use122Workaround = false;
    Rectangle sourceRegion;
    int sourceXSubsampling;
    int sourceYSubsampling;
    int sourceMinProgressivePass;
    int sourceMaxProgressivePass;
    Point destinationOffset;
    Rectangle destinationRegion;
    int updateMinY;
    int updateHeight;
    int updateYStep;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;

    public GIFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl) {
        super.setInput(object, bl);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
    }

    public int getNumImages(boolean bl) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (bl) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    private void checkIndex(int n) {
        if (n < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = n;
        }
    }

    public int getWidth(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageWidth;
    }

    public int getHeight(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageHeight;
    }

    public Iterator getImageTypes(int n) throws IIOException {
        byte[] byArray;
        int n2;
        this.checkIndex(n);
        int n3 = this.locateImage(n);
        if (n3 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        if (this.imageMetadata.localColorTableFlag) {
            n2 = this.imageMetadata.sizeOfLocalColorTable + 1;
            byArray = this.imageMetadata.localColorTable;
        } else {
            n2 = this.streamMetadata.sizeOfGlobalColorTable + 1;
            byArray = this.streamMetadata.globalColorTable;
        }
        int n4 = 1 << n2;
        if (n2 == 3) {
            n2 = 4;
        }
        if (n2 > 4 && n2 < 8) {
            n2 = 8;
        }
        int n5 = 1 << n2;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            byArray2[n7] = byArray[n6++];
            byArray3[n7] = byArray[n6++];
            byArray4[n7] = byArray[n6++];
            ++n7;
        }
        while (n7 < n5) {
            byArray4[n7] = 0;
            byArray3[n7] = 0;
            byArray2[n7] = 0;
            ++n7;
        }
        byte[] byArray5 = null;
        if (this.imageMetadata.transparentColorFlag) {
            byArray5 = new byte[n5];
            Arrays.fill(byArray5, (byte)-1);
            int n8 = Math.min(this.imageMetadata.transparentColorIndex, n5 - 1);
            byArray5[n8] = 0;
        }
        int[] nArray = new int[]{n2};
        arrayList.add(ImageTypeSpecifier.createIndexed(byArray2, byArray3, byArray4, byArray5, n2, 0));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam(false);
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    public IIOMetadata getImageMetadata(int n) throws IIOException {
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException("Bad image index!");
        }
        this.readMetadata();
        return this.imageMetadata;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int n, int n2) throws IOException {
        if (this.bitPos + n > 32) {
            return this.eofCode;
        }
        int n3 = this.next32Bits >> this.bitPos & n2;
        this.bitPos += n;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                this.blockLength = this.stream.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return n3;
                }
                int n4 = this.blockLength;
                int n5 = 0;
                while (n4 > 0) {
                    int n6 = this.stream.read(this.block, n5, n4);
                    n5 += n6;
                    n4 -= n6;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n3;
    }

    public void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n = 1 << this.initCodeSize;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            byArray[n2] = (byte)n2;
            byArray2[n2] = (byte)n2;
            nArray2[n2] = 1;
            ++n2;
        }
        int n3 = n;
        while (n3 < 4096) {
            nArray[n3] = -1;
            nArray2[n3] = 1;
            ++n3;
        }
    }

    private void outputRow() {
        int n = Math.min(this.sourceRegion.width, this.destinationRegion.width * this.sourceXSubsampling);
        int n2 = this.destinationRegion.x;
        if (this.sourceXSubsampling == 1 && !use122Workaround) {
            this.theTile.setDataElements(n2, this.destY, n, 1, this.rowBuf);
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.theTile.setSample(n2, this.destY, 0, this.rowBuf[n3] & 0xFF);
                n3 += this.sourceXSubsampling;
                ++n2;
            }
        }
        if (this.updateListeners != null) {
            int[] nArray = new int[]{0};
            this.processImageUpdate(this.theImage, this.destinationRegion.x, this.updateMinY, n, 1, 1, this.updateYStep, nArray);
        }
    }

    private void outputPixels(byte[] byArray, int n) {
        if (this.interlacePass < this.sourceMinProgressivePass || this.interlacePass > this.sourceMaxProgressivePass) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.x >= this.sourceRegion.x) {
                this.rowBuf[this.x - this.sourceRegion.x] = byArray[n2];
            }
            ++this.x;
            if (this.x == this.width) {
                ++this.rowsDone;
                this.processImageProgress(100.0f * (float)this.rowsDone / (float)this.height);
                if (this.decodeThisRow) {
                    this.outputRow();
                }
                this.x = 0;
                if (this.imageMetadata.interlaceFlag) {
                    this.y += interlaceIncrement[this.interlacePass];
                    if (this.y >= this.height) {
                        if (this.updateListeners != null) {
                            this.processPassComplete(this.theImage);
                        }
                        ++this.interlacePass;
                        if (this.interlacePass > this.sourceMaxProgressivePass) {
                            return;
                        }
                        this.y = interlaceOffset[this.interlacePass];
                        if (this.updateListeners != null) {
                            this.startPass(this.interlacePass);
                        }
                    }
                } else {
                    ++this.y;
                }
                this.destY = this.destinationRegion.y + (this.y - this.sourceRegion.y) / this.sourceYSubsampling;
                this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.y >= this.sourceRegion.y && this.y < this.sourceRegion.y + this.sourceRegion.height && (this.y - this.sourceRegion.y) % this.sourceYSubsampling == 0;
            }
            ++n2;
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            this.stream.setByteOrder(false);
            byte[] byArray = new byte[6];
            this.stream.readFully(byArray);
            StringBuffer stringBuffer = new StringBuffer(3);
            stringBuffer.append((char)byArray[3]);
            stringBuffer.append((char)byArray[4]);
            stringBuffer.append((char)byArray[5]);
            this.streamMetadata.version = stringBuffer.toString();
            this.streamMetadata.logicalScreenWidth = this.stream.readUnsignedShort();
            this.streamMetadata.logicalScreenHeight = this.stream.readUnsignedShort();
            int n = this.stream.readUnsignedByte();
            this.streamMetadata.globalColorTableFlag = (n & 0x80) != 0;
            this.streamMetadata.colorResolution = n >> 4 & 7;
            this.streamMetadata.sortFlag = (n & 8) != 0;
            this.streamMetadata.sizeOfGlobalColorTable = n & 7;
            this.streamMetadata.backgroundColorIndex = this.stream.readUnsignedByte();
            this.streamMetadata.pixelAspectRatio = this.stream.readUnsignedByte();
            if (this.streamMetadata.globalColorTableFlag) {
                int n2 = this.streamMetadata.sizeOfGlobalColorTable + 1;
                this.streamMetadata.globalColorTable = new byte[3 * (1 << n2)];
                this.stream.readFully(this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
            this.imageStartPosition.add(new Long(this.stream.getStreamPosition()));
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading header!", iOException);
        }
        this.gotHeader = true;
    }

    private boolean skipImage() throws IIOException {
        try {
            while (true) {
                int n;
                int n2;
                int n3;
                if ((n3 = this.stream.readUnsignedByte()) == 44) {
                    this.stream.skipBytes(8);
                    n2 = this.stream.readUnsignedByte();
                    if ((n2 & 0x80) != 0) {
                        n = (n2 & 7) + 1;
                        this.stream.skipBytes(3 * (1 << n));
                    }
                    this.stream.skipBytes(1);
                    n = 0;
                    do {
                        n = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n);
                    } while (n > 0);
                    return true;
                }
                if (n3 == 59) {
                    return false;
                }
                if (n3 == 33) {
                    n2 = this.stream.readUnsignedByte();
                    n = 0;
                    do {
                        n = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n);
                    } while (n > 0);
                    continue;
                }
                n2 = 0;
                do {
                    n2 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n2);
                } while (n2 > 0);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error locating image!", iOException);
        }
    }

    private int locateImage(int n) throws IIOException {
        this.readHeader();
        try {
            int n2 = Math.min(n, this.imageStartPosition.size() - 1);
            Long l = (Long)this.imageStartPosition.get(n2);
            this.stream.seek(l);
            while (n2 < n) {
                if (!this.skipImage()) {
                    return --n2;
                }
                Long l2 = new Long(this.stream.getStreamPosition());
                this.imageStartPosition.add(l2);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Couldn't seek!", iOException);
        }
        if (this.currIndex != n) {
            this.imageMetadata = null;
        }
        this.currIndex = n;
        return n;
    }

    private byte[] concatenateBlocks() throws IOException {
        int n;
        byte[] byArray = new byte[]{};
        while ((n = this.stream.readUnsignedByte()) != 0) {
            byte[] byArray2 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.stream.readFully(byArray2, byArray.length, n);
            byArray = byArray2;
        }
        return byArray;
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            this.imageMetadata = new GIFImageMetadata();
            long l = this.stream.getStreamPosition();
            while (true) {
                int n;
                int n2;
                if ((n2 = this.stream.readUnsignedByte()) == 44) {
                    this.imageMetadata.imageLeftPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageTopPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.imageHeight = this.stream.readUnsignedShort();
                    n = this.stream.readUnsignedByte();
                    this.imageMetadata.localColorTableFlag = (n & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (n & 0x40) != 0;
                    this.imageMetadata.sortFlag = (n & 0x20) != 0;
                    this.imageMetadata.sizeOfLocalColorTable = n & 7;
                    if (this.imageMetadata.localColorTableFlag) {
                        int n3 = this.imageMetadata.sizeOfLocalColorTable + 1;
                        this.imageMetadata.localColorTable = new byte[3 * (1 << n3)];
                        this.stream.readFully(this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    this.imageMetadataLength = (int)(this.stream.getStreamPosition() - l);
                    return;
                }
                if (n2 != 33) break;
                n = this.stream.readUnsignedByte();
                if (n == 249) {
                    int n4 = this.stream.readUnsignedByte();
                    int n5 = this.stream.readUnsignedByte();
                    this.imageMetadata.disposalMethod = n5 >> 2 & 3;
                    this.imageMetadata.userInputFlag = (n5 & 2) != 0;
                    this.imageMetadata.transparentColorFlag = (n5 & 1) != 0;
                    this.imageMetadata.delayTime = this.stream.readUnsignedShort();
                    this.imageMetadata.transparentColorIndex = this.stream.readUnsignedByte();
                    int n6 = this.stream.readUnsignedByte();
                    continue;
                }
                if (n == 1) {
                    int n7 = this.stream.readUnsignedByte();
                    this.imageMetadata.hasPlainTextExtension = true;
                    this.imageMetadata.textGridLeft = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridRight = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridHeight = this.stream.readUnsignedShort();
                    this.imageMetadata.characterCellWidth = this.stream.readUnsignedByte();
                    this.imageMetadata.characterCellHeight = this.stream.readUnsignedByte();
                    this.imageMetadata.textForegroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.textBackgroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.text = this.concatenateBlocks();
                    continue;
                }
                if (n == 254) {
                    byte[] byArray = this.concatenateBlocks();
                    if (this.imageMetadata.comments == null) {
                        this.imageMetadata.comments = new ArrayList();
                    }
                    this.imageMetadata.comments.add(byArray);
                    continue;
                }
                if (n == 255) {
                    int n8 = this.stream.readUnsignedByte();
                    byte[] byArray = new byte[8];
                    this.stream.readFully(byArray);
                    byte[] byArray2 = new byte[3];
                    this.stream.readFully(byArray2);
                    byte[] byArray3 = this.concatenateBlocks();
                    if (this.imageMetadata.applicationIDs == null) {
                        this.imageMetadata.applicationIDs = new ArrayList();
                        this.imageMetadata.authenticationCodes = new ArrayList();
                        this.imageMetadata.applicationData = new ArrayList();
                    }
                    this.imageMetadata.applicationIDs.add(byArray);
                    this.imageMetadata.authenticationCodes.add(byArray2);
                    this.imageMetadata.applicationData.add(byArray3);
                    continue;
                }
                int n9 = 0;
                do {
                    n9 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n9);
                } while (n9 > 0);
            }
            throw new IndexOutOfBoundsException("blah");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("I/O error reading image metadata!", iOException);
        }
    }

    private static void computeUpdatedPixels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10) {
        boolean bl = false;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        while (n14 < n8) {
            int n15 = n7 + n14 * n9;
            if (n15 >= n && (n15 - n) % n6 == 0) {
                if (n15 >= n + n2) break;
                int n16 = n3 + (n15 - n) / n6;
                if (n16 >= n4) {
                    if (n16 > n5) break;
                    if (!bl) {
                        n11 = n16;
                        bl = true;
                    } else if (n12 == -1) {
                        n12 = n16;
                    }
                    n13 = n16;
                }
            }
            ++n14;
        }
        nArray[n10] = n11;
        nArray[n10 + 2] = !bl ? 0 : n13 - n11 + 1;
        nArray[n10 + 4] = Math.max(n12 - n11, 1);
    }

    private static int[] computeUpdatedPixels(Rectangle rectangle, Point point, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int[] nArray = new int[6];
        GIFImageReader.computeUpdatedPixels(rectangle.x, rectangle.width, point.x, n, n3, n5, n7, n9, n11, nArray, 0);
        GIFImageReader.computeUpdatedPixels(rectangle.y, rectangle.height, point.y, n2, n4, n6, n8, n10, n12, nArray, 1);
        return nArray;
    }

    private void startPass(int n) {
        int n2 = interlaceOffset[this.interlacePass];
        int n3 = interlaceIncrement[this.interlacePass];
        int[] nArray = GIFImageReader.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, this.destinationRegion.x, this.destinationRegion.y, this.destinationRegion.x + this.destinationRegion.width - 1, this.destinationRegion.y + this.destinationRegion.height - 1, this.sourceXSubsampling, this.sourceYSubsampling, 0, n2, this.destinationRegion.width, (this.destinationRegion.height + n3 - 1) / n3, 1, n3);
        this.updateMinY = nArray[1];
        this.updateHeight = nArray[3];
        this.updateYStep = nArray[5];
        int[] nArray2 = new int[]{0};
        this.processPassStarted(this.theImage, this.interlacePass, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, 0, this.updateMinY, 1, this.updateYStep, nArray2);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.checkIndex(n);
        int n2 = this.locateImage(n);
        if (n2 != n) {
            throw new IndexOutOfBoundsException();
        }
        this.abortFlag = false;
        this.readMetadata();
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        Iterator iterator = this.getImageTypes(n);
        this.theImage = ImageReader.getDestination(imageReadParam, iterator, this.imageMetadata.imageWidth, this.imageMetadata.imageHeight);
        this.theTile = this.theImage.getWritableTile(0, 0);
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        this.x = 0;
        this.y = 0;
        this.rowsDone = 0;
        this.destY = 0;
        this.decodeThisRow = true;
        this.interlacePass = 0;
        this.sourceRegion = this.getSourceRegion(imageReadParam, this.width, this.height);
        this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
        this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
        this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
        this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 3);
        this.destinationOffset = imageReadParam.getDestinationOffset();
        this.destinationRegion = new Rectangle(this.destinationOffset.x, this.destinationOffset.y, this.theTile.getWidth() - this.destinationOffset.x, this.theTile.getHeight() - this.destinationOffset.y);
        this.processImageStarted(n);
        if (this.updateListeners != null) {
            this.startPass(0);
        }
        this.rowBuf = new byte[this.width];
        try {
            int n3;
            this.initCodeSize = this.stream.readUnsignedByte();
            int n4 = this.blockLength = this.stream.readUnsignedByte();
            int n5 = 0;
            while (n4 > 0) {
                n3 = this.stream.read(this.block, n5, n4);
                n4 -= n3;
                n5 += n3;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n6 = 0;
            int[] nArray = new int[4096];
            byte[] byArray = new byte[4096];
            byte[] byArray2 = new byte[4096];
            int[] nArray2 = new int[4096];
            byte[] byArray3 = new byte[4096];
            this.initializeStringTable(nArray, byArray, byArray2, nArray2);
            int n7 = (1 << this.initCodeSize) + 2;
            int n8 = this.initCodeSize + 1;
            int n9 = (1 << n8) - 1;
            while (!this.abortFlag) {
                int n10;
                int n11;
                int n12;
                n3 = this.getCode(n8, n9);
                if (n3 == this.clearCode) {
                    this.initializeStringTable(nArray, byArray, byArray2, nArray2);
                    n7 = (1 << this.initCodeSize) + 2;
                    n8 = this.initCodeSize + 1;
                    n9 = (1 << n8) - 1;
                    n3 = this.getCode(n8, n9);
                    if (n3 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                } else {
                    if (n3 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                    if (n3 < n7) {
                        n12 = n3;
                    } else {
                        n12 = n6;
                        if (n3 != n7) {
                            System.err.println("Out-of-sequence code!");
                        }
                    }
                    n11 = n7++;
                    nArray[n11] = n10 = n6;
                    byArray[n11] = byArray2[n12];
                    byArray2[n11] = byArray2[n10];
                    nArray2[n11] = nArray2[n10] + 1;
                    if (n7 == 1 << n8 && n7 < 4096) {
                        n9 = (1 << ++n8) - 1;
                    }
                }
                n12 = n3;
                n11 = nArray2[n12];
                n10 = n11 - 1;
                while (n10 >= 0) {
                    byArray3[n10] = byArray[n12];
                    n12 = nArray[n12];
                    --n10;
                }
                this.outputPixels(byArray3, n11);
                n6 = n3;
            }
            this.processReadAborted();
            return this.theImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("I/O error reading image!", iOException);
        }
    }

    public void reset() {
        super.reset();
        this.gotHeader = false;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.currIndex = -1;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.block = new byte[255];
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.lastBlockFound = false;
        this.next32Bits = 0;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.x = -1;
        this.y = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
    }

    static {
        try {
            int n = 0;
            while (n <= 3) {
                int n2 = 1 << n;
                int n3 = 0;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(n3, 1, 1, n2);
                BytePackedRaster bytePackedRaster = new BytePackedRaster(multiPixelPackedSampleModel, new Point(0, 0));
                byte[] byArray = new byte[]{-1};
                ((WritableRaster)bytePackedRaster).setDataElements(0, 0, byArray);
                int n4 = bytePackedRaster.getSample(0, 0, 0);
                if (n4 != (1 << n2) - 1) {
                    use122Workaround = true;
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

