/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private static final int BUFFER_LENGTH = 1024;
    private byte[] buf = new byte[1024];
    private long length = 0L;
    private boolean foundEOF = false;

    public FileCacheImageInputStream(InputStream inputStream, File file) throws IOException {
        this.stream = inputStream;
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        this.cacheFile = File.createTempFile("imageio", ".tmp", file);
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private long readUntil(long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l2 = l - this.length;
        this.cache.seek(this.length);
        while (l2 > 0L) {
            int n = this.stream.read(this.buf, 0, (int)Math.min(l2, 1024L));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n);
            this.cache.write(this.buf, 0, n);
            l2 -= (long)n;
            this.length += (long)n;
        }
        return l;
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        long l = this.streamPos + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            this.cache.seek(this.streamPos++);
            return this.cache.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.checkClosed();
        this.bitOffset = 0;
        long l = this.readUntil(this.streamPos + (long)n2);
        n2 = (int)Math.min((long)n2, l - this.streamPos);
        if (n2 > 0) {
            this.cache.seek(this.streamPos);
            this.cache.readFully(byArray, n, n2);
            this.streamPos += (long)n2;
            return n2;
        }
        return -1;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public void close() throws IOException {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.stream = null;
    }
}

