/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.MysqlDefs;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;

public abstract class DatabaseMetaData {
    protected Connection _Conn;
    protected String _Database;
    private static byte[] _Table_As_Bytes = "TABLE".getBytes();

    public DatabaseMetaData(Connection connection, String string) {
        this._Conn = connection;
        this._Database = string;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return new String(this._Conn.getURL());
    }

    public String getUserName() throws SQLException {
        return new String(this._Conn.getUser());
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return new String(this._Conn.getServerVersion());
    }

    public String getDriverName() throws SQLException {
        return "Mark Matthews' MySQL Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "2.0a";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        return "ACII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,ELT,FIELD,FIND_IN_SET,INSERT,INSTR,INTERVAL,LCASE,LEFT,LENGTH,LOCATE,LOWER,LTRIM,MID,POSITION,OCTET_LENGTH,REPEAT,REPLACE,REVERSE,RIGHT,RTRIM,SPACE,SOUNDEX,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this._Conn.getServerMajorVersion() >= 3) {
            if (this._Conn.getServerMajorVersion() == 3) {
                return this._Conn.getServerMinorVersion() >= 22;
            }
            return true;
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 128;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.MAXBUF - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 0), new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + string;
            }
        } else {
            string4 = " FROM " + this._Database;
        }
        if (string3 == null) {
            string3 = "%";
        }
        java.sql.ResultSet resultSet = this._Conn.createStatement().executeQuery("show tables " + string4 + " like '" + string3 + "'");
        resultSet.getMetaData();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 12, string == null ? 0 : string.length()), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArray = null;
        while (resultSet.next()) {
            object = resultSet.getString(1);
            byArray = new byte[][]{string == null ? new byte[]{} : string.getBytes(), new byte[0], ((String)object).getBytes(), _Table_As_Bytes, new byte[0]};
            vector.addElement(byArray);
        }
        object = this.buildResultSet(fieldArray, vector, this._Conn);
        return object;
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        Vector vector = new Vector();
        java.sql.ResultSet resultSet = this.buildResultSet(fieldArray, vector, this._Conn);
        return resultSet;
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        java.sql.ResultSet resultSet = this._Conn.createStatement().executeQuery("SHOW DATABASES");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 12, resultSetMetaData.getColumnDisplaySize(1))};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            byte[][] byArray = new byte[][]{resultSet.getBytes(1)};
            vector.addElement(byArray);
        }
        return this.buildResultSet(fieldArray, vector, this._Conn);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] byArray = new byte[][]{_Table_As_Bytes};
        vector.addElement(byArray);
        return this.buildResultSet(fieldArray, vector, this._Conn);
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        Object object2;
        java.sql.ResultSet resultSet;
        String string5 = "";
        if (string4 == null) {
            string4 = "%";
        }
        if (string != null) {
            if (!string.equals("")) {
                string5 = " FROM " + string;
            }
        } else {
            string5 = " FROM " + this._Database;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (string3 == null) {
            resultSet = this.getTables(string, string2, "%", new String[0]);
            while (resultSet.next()) {
                object2 = resultSet.getString("TABLE_NAME");
                vector.addElement((String)object2);
                if (((String)object2).length() <= n) continue;
                n = ((String)object2).length();
            }
            resultSet.close();
        } else {
            resultSet = this.getTables(string, string2, string3, new String[0]);
            while (resultSet.next()) {
                object2 = resultSet.getString("TABLE_NAME");
                vector.addElement((String)object2);
                if (((String)object2).length() <= n) continue;
                n = ((String)object2).length();
            }
            resultSet.close();
        }
        int n2 = 0;
        if (string != null) {
            n2 = string.length();
        } else {
            string = "";
            n2 = 0;
        }
        object2 = vector.elements();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, n2), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, n), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        Vector<byte[][]> vector2 = new Vector<byte[][]>();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            ResultSet resultSet2 = this._Conn.execSQL("show columns from " + (String)object + string5 + " like '" + string4 + "'", -1);
            resultSet2.setConnection(this._Conn);
            resultSet2.getMetaData();
            int n3 = 1;
            while (resultSet2.next()) {
                Object object3;
                String string6;
                byte[][] byArray = new byte[18][];
                byArray[0] = string.getBytes();
                byArray[1] = new byte[0];
                byArray[2] = ((String)object).getBytes();
                byArray[3] = resultSet2.getBytes("Field");
                String string7 = resultSet2.getString("Type");
                String string8 = "";
                string8 = string7.indexOf("(") != -1 ? string7.substring(0, string7.indexOf("(")) : string7;
                byArray[4] = Integer.toString(MysqlDefs.mysqlToJavaType(string8)).getBytes();
                byArray[5] = string8.getBytes();
                if (string7 != null) {
                    if (string7.indexOf("enum") != -1 || string7.indexOf("set") != -1) {
                        string6 = string7.substring(string7.indexOf("("), string7.lastIndexOf(")"));
                        object3 = new StringTokenizer(string6, ",");
                        int n4 = 0;
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            n4 = Math.max(n4, ((StringTokenizer)object3).nextToken().length() - 2);
                        }
                        byArray[6] = Integer.toString(n4).getBytes();
                        byArray[8] = new byte[]{48};
                    } else if (string7.indexOf(",") != -1) {
                        string6 = string7.substring(string7.indexOf("(") + 1, string7.indexOf(","));
                        object3 = string7.substring(string7.indexOf(",") + 1, string7.indexOf(")"));
                        byArray[6] = string6.getBytes();
                        byArray[8] = ((String)object3).getBytes();
                    } else {
                        string6 = "0";
                        if (string7.indexOf("(") != -1) {
                            string6 = string7.substring(string7.indexOf("(") + 1, string7.indexOf(")"));
                        } else if (string7.toLowerCase().equals("tinyint")) {
                            string6 = "1";
                        } else if (string7.toLowerCase().equals("smallint")) {
                            string6 = "6";
                        } else if (string7.toLowerCase().equals("mediumint")) {
                            string6 = "6";
                        } else if (string7.toLowerCase().equals("int")) {
                            string6 = "11";
                        } else if (string7.toLowerCase().equals("integer")) {
                            string6 = "11";
                        } else if (string7.toLowerCase().equals("bigint")) {
                            string6 = "25";
                        } else if (string7.toLowerCase().equals("int24")) {
                            string6 = "25";
                        } else if (string7.toLowerCase().equals("real")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("float")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("decimal")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("numeric")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("double")) {
                            string6 = "22";
                        } else if (string7.toLowerCase().equals("char")) {
                            string6 = "1";
                        } else if (string7.toLowerCase().equals("varchar")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("date")) {
                            string6 = "10";
                        } else if (string7.toLowerCase().equals("time")) {
                            string6 = "8";
                        } else if (string7.toLowerCase().equals("timestamp")) {
                            string6 = "19";
                        } else if (string7.toLowerCase().equals("datetime")) {
                            string6 = "19";
                        } else if (string7.toLowerCase().equals("tinyblob")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("blob")) {
                            string6 = Integer.toString(Math.min(65535, MysqlIO.MAXBUF));
                        } else if (string7.toLowerCase().equals("mediumblob")) {
                            string6 = Integer.toString(Math.min(16277215, MysqlIO.MAXBUF));
                        } else if (string7.toLowerCase().equals("longblob")) {
                            string6 = Integer.toString(MysqlIO.MAXBUF).compareTo("2147483657") < 0 ? Integer.toString(MysqlIO.MAXBUF) : "2147483657";
                        } else if (string7.toLowerCase().equals("tinytext")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("text")) {
                            string6 = "65535";
                        } else if (string7.toLowerCase().equals("mediumtext")) {
                            string6 = Integer.toString(Math.min(16277215, MysqlIO.MAXBUF));
                        } else if (string7.toLowerCase().equals("enum")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("set")) {
                            string6 = "255";
                        }
                        byArray[6] = string6.getBytes();
                        byArray[8] = new byte[]{48};
                    }
                } else {
                    byArray[8] = new byte[]{48};
                    byArray[6] = new byte[]{48};
                }
                byArray[7] = Integer.toString(MysqlIO.MAXBUF).getBytes();
                byArray[9] = new byte[]{49, 48};
                string6 = resultSet2.getString("Null");
                if (string6 != null) {
                    if (string6.equals("YES")) {
                        byArray[10] = Integer.toString(1).getBytes();
                        byArray[17] = new String("YES").getBytes();
                    } else {
                        byArray[10] = Integer.toString(0).getBytes();
                        byArray[17] = new String("NO").getBytes();
                    }
                } else {
                    byArray[10] = Integer.toString(0).getBytes();
                    byArray[17] = new String("NO").getBytes();
                }
                try {
                    byArray[11] = resultSet2.getString("Extra").getBytes();
                }
                catch (Exception exception) {
                    byArray[11] = new byte[0];
                }
                object3 = resultSet2.getBytes("Default");
                byArray[12] = object3 != null ? (Object)object3 : new byte[0];
                byArray[13] = new byte[]{48};
                byArray[14] = new byte[]{48};
                byArray[15] = byArray[6];
                byArray[16] = Integer.toString(n3++).getBytes();
                vector2.addElement(byArray);
            }
            resultSet2.close();
        }
        object = this.buildResultSet(fieldArray, vector2, this._Conn);
        return object;
    }

    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 1), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 1), new Field("", "COLUMN_NAME", 1, 1), new Field("", "GRANTOR", 1, 1), new Field("", "GRANTEE", 1, 1), new Field("", "PRIVILEGE", 1, 1), new Field("", "IS_GRANTABLE", 1, 1)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 1), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 1), new Field("", "COLUMN_NAME", 1, 1), new Field("", "GRANTOR", 1, 1), new Field("", "GRANTEE", 1, 1), new Field("", "PRIVILEGE", 1, 1), new Field("", "IS_GRANTABLE", 1, 1)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + string;
            }
        } else {
            string4 = " FROM " + this._Database;
        }
        if (string3 == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet resultSet = this._Conn.execSQL("show columns from " + string3 + string4, -1);
        resultSet.setConnection(this._Conn);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            String string5 = resultSet.getString("Key");
            if (string5 == null || !string5.equals("PRI")) continue;
            byte[][] byArray = new byte[8][];
            byArray[0] = Integer.toString(2).getBytes();
            byArray[1] = resultSet.getBytes("Field");
            String string6 = resultSet.getString("Type");
            int n2 = MysqlIO.MAXBUF;
            int n3 = 0;
            if (string6.indexOf("enum") != -1) {
                String string7 = string6.substring(string6.indexOf("("), string6.indexOf(")"));
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    n4 = Math.max(n4, stringTokenizer.nextToken().length() - 2);
                }
                n2 = n4;
                n3 = 0;
                string6 = "enum";
            } else if (string6.indexOf("(") != -1) {
                if (string6.indexOf(",") != -1) {
                    n2 = Integer.parseInt(string6.substring(string6.indexOf("(") + 1, string6.indexOf(",")));
                    n3 = Integer.parseInt(string6.substring(string6.indexOf(",") + 1, string6.indexOf(")")));
                } else {
                    n2 = Integer.parseInt(string6.substring(string6.indexOf("(") + 1, string6.indexOf(")")));
                }
                string6 = string6.substring(string6.indexOf("("));
            }
            byArray[2] = new byte[0];
            byArray[3] = string6.getBytes();
            byArray[4] = Integer.toString(n2 + n3).getBytes();
            byArray[5] = Integer.toString(n2 + n3).getBytes();
            byArray[6] = Integer.toString(n3).getBytes();
            byArray[7] = Integer.toString(1).getBytes();
            vector.addElement(byArray);
        }
        return this.buildResultSet(fieldArray, vector, this._Conn);
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + string;
            }
        } else {
            string4 = " FROM " + this._Database;
        }
        if (string3 == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet resultSet = this._Conn.execSQL("show keys from " + string3 + string4, -1);
        resultSet.setConnection(this._Conn);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            String string5 = resultSet.getString("Key_name");
            if (string5 == null || !string5.equals("PRIMARY")) continue;
            byte[][] byArray = new byte[6][];
            byArray[0] = string == null ? new byte[]{} : string.getBytes();
            byArray[1] = new byte[0];
            byArray[2] = string3.getBytes();
            byArray[3] = resultSet.getBytes("Column_name");
            String string6 = resultSet.getString("Seq_in_index");
            byArray[4] = string6.getBytes();
            byArray[5] = byArray[3];
            vector.addElement(byArray);
        }
        return this.buildResultSet(fieldArray, vector, this._Conn);
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 1), new Field("", "PKTABLE_SCHEM", 1, 1), new Field("", "PKTABLE_NAME", 1, 1), new Field("", "PKCOLUMN_NAME", 1, 1), new Field("", "FKTABLE_CAT", 1, 1), new Field("", "FKTABLE_SCHEM", 1, 1), new Field("", "FKTABLE_NAME", 1, 1), new Field("", "FKCOLUMN_NAME", 1, 1), new Field("", "KEY_SEQ", 5, 1), new Field("", "UPDATE_RULE", 5, 1), new Field("", "DELETE_RULE", 5, 1), new Field("", "FK_NAME", 1, 1), new Field("", "PK_NAME", 1, 1)};
        return this.buildResultSet(fieldArray, new Vector(), this._Conn);
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        byte[][] byArray = null;
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byArray = new byte[][]{"TINYINT".getBytes(), Integer.toString(-6).getBytes(), "3".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "TINYINT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"BIGINT".getBytes(), Integer.toString(-5).getBytes(), "19".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "BIGINT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"MEDIUMBLOB".getBytes(), Integer.toString(-4).getBytes(), "16777215".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "true".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "MEDIUMBLOB".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"LONGBLOB".getBytes(), Integer.toString(-4).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "true".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "LONGBLOB".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"BLOB".getBytes(), Integer.toString(-4).getBytes(), "65535".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "true".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "BLOB".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"TINYBLOB".getBytes(), Integer.toString(-3).getBytes(), "255".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "true".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "TINYBLOB".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"CHAR".getBytes(), Integer.toString(1).getBytes(), "255".getBytes(), "'".getBytes(), "'".getBytes(), "(M) [BINARY]".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "CHAR".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"NUMERIC".getBytes(), Integer.toString(2).getBytes(), "17".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "NUMERIC".getBytes(), "308".getBytes(), "308".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"DECIMAL".getBytes(), Integer.toString(3).getBytes(), "17".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "DECIMAL".getBytes(), "-308".getBytes(), "308".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"INT".getBytes(), Integer.toString(4).getBytes(), "10".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "INT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"MEDIUMINT".getBytes(), Integer.toString(4).getBytes(), "7".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "MEDIUMINT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"SMALLINT".getBytes(), Integer.toString(5).getBytes(), "5".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "SMALLINT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"SHORT".getBytes(), Integer.toString(5).getBytes(), "5".getBytes(), "".getBytes(), "".getBytes(), "(M) UNSIGNED ZEROFILL".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "true".getBytes(), "false".getBytes(), "true".getBytes(), "SMALLINT".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        byArray = new byte[][]{"FLOAT".getBytes(), Integer.toString(6).getBytes(), "10".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "FLOAT".getBytes(), "-38".getBytes(), "38".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"DOUBLE".getBytes(), Integer.toString(8).getBytes(), "17".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "DOUBLE".getBytes(), "-308".getBytes(), "308".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"DOUBLE PRECISION".getBytes(), Integer.toString(8).getBytes(), "17".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "DOUBLE PRECISION".getBytes(), "-308".getBytes(), "308".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"REAL".getBytes(), Integer.toString(8).getBytes(), "17".getBytes(), "".getBytes(), "".getBytes(), "(M,D)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "true".getBytes(), "REAL".getBytes(), "-308".getBytes(), "308".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"VARCHAR".getBytes(), Integer.toString(12).getBytes(), "255".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "VARCHAR".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"DATE".getBytes(), Integer.toString(91).getBytes(), "0".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "DATE".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"TIME".getBytes(), Integer.toString(92).getBytes(), "0".getBytes(), "'".getBytes(), "'".getBytes(), "".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "TIME".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"DATETIME".getBytes(), Integer.toString(93).getBytes(), "0".getBytes(), "'".getBytes(), "'".getBytes(), "(M)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "DATETIME".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        byArray = new byte[][]{"TIMESTAMP".getBytes(), Integer.toString(93).getBytes(), "0".getBytes(), "'".getBytes(), "'".getBytes(), "(M)".getBytes(), Integer.toString(1).getBytes(), "false".getBytes(), Integer.toString(3).getBytes(), "false".getBytes(), "false".getBytes(), "false".getBytes(), "TIMESTAMP".getBytes(), "0".getBytes(), "0".getBytes(), "".getBytes(), "".getBytes(), "10".getBytes()};
        vector.addElement(byArray);
        return this.buildResultSet(fieldArray, vector, this._Conn);
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Object object;
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + string;
            }
        } else {
            string4 = " FROM " + this._Database;
        }
        ResultSet resultSet = this._Conn.execSQL("SHOW INDEX FROM " + string3 + string4, -1);
        resultSet.setConnection(this._Conn);
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 3), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 1, 32), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            object = new byte[14][];
            object[0] = string == null ? new byte[]{} : string.getBytes();
            object[1] = new byte[0];
            object[2] = resultSet.getBytes("Table");
            object[3] = resultSet.getInt("Non_unique") != 0 ? "true".getBytes() : "false".getBytes();
            object[4] = new byte[0];
            object[5] = resultSet.getBytes("Key_name");
            object[6] = Integer.toString(3).getBytes();
            object[7] = resultSet.getBytes("Seq_in_index");
            object[8] = resultSet.getBytes("Column_name");
            object[9] = resultSet.getBytes("Collation");
            object[10] = resultSet.getBytes("Cardinality");
            object[11] = new byte[0];
            object[12] = new byte[0];
            vector.addElement((byte[][])object);
        }
        object = this.buildResultSet(fieldArray, vector, this._Conn);
        return object;
    }

    private byte[] s2b(String string) {
        return string.getBytes();
    }

    protected abstract java.sql.ResultSet buildResultSet(Field[] var1, Vector var2, Connection var3);
}

