/*
 * Decompiled with CFR 0.152.
 */
package applets;

import iDSS.disp.DisplayFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnimationFrameApplet
extends DisplayFrame
implements ActionListener,
ChangeListener,
Runnable {
    private Vector imagesVector;
    private Timer fpsTimer;
    private JLabel fpsLabel;
    private JSlider fpsSlider;
    private JButton startButton;
    private JButton pauseButton;
    private JButton stopButton;
    private JButton rewindButton;
    private JButton nextButton;
    private JButton prevButton;
    private int fps_init = 1;
    private BufferedImage currentImage;
    private JLabel titleLabel;
    private JLabel imagePanel;
    private String currentTitle;
    private int currentFrame = 0;
    private final int MINIMUM_IMAGE_SIZE = 200;
    private Thread animThread;
    private boolean started;
    private boolean stopped;
    private boolean paused;
    private boolean rewound;

    public AnimationFrameApplet(String string, Vector vector) {
        super(string, true, true, true, true, null);
        this.rescaleImage(vector);
        if (this.imagesVector.size() > 0) {
            Vector vector2 = (Vector)this.imagesVector.elementAt(0);
            String string2 = (String)vector2.elementAt(0);
            this.currentImage = (BufferedImage)vector2.elementAt(1);
            this.titleLabel = new JLabel("Frame#" + this.currentFrame + ": " + string2);
        }
        this.animThread = new Thread(this);
        this.animThread.start();
    }

    private void rescaleImage(Vector vector) {
        this.currentFrame = 0;
        if (vector.size() > 0) {
            Vector vector2 = (Vector)vector.elementAt(this.currentFrame);
            String string = (String)vector2.elementAt(0);
            this.currentImage = (BufferedImage)vector2.elementAt(1);
            this.titleLabel = new JLabel("Frame#" + this.currentFrame + ": " + string);
        } else {
            this.currentImage = new BufferedImage(200, 200, 1);
            this.titleLabel = new JLabel("Empty image vector");
        }
        if (this.currentImage.getWidth() < 200 && this.currentImage.getHeight() < 200) {
            int n = Math.max(this.currentImage.getWidth(), this.currentImage.getHeight());
            int n2 = 200 / n;
            this.imagesVector = new Vector();
            int n3 = 0;
            while (n3 < vector.size()) {
                Vector vector3 = (Vector)vector.elementAt(n3);
                String string = (String)vector3.elementAt(0);
                BufferedImage bufferedImage = (BufferedImage)vector3.elementAt(1);
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() * n2, bufferedImage.getHeight() * n2, 1);
                Graphics graphics = bufferedImage2.getGraphics();
                graphics.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (ImageObserver)((Object)this));
                Vector<Object> vector4 = new Vector<Object>();
                vector4.add(string);
                vector4.add(bufferedImage2);
                this.imagesVector.add(vector4);
                ++n3;
            }
        } else {
            this.imagesVector = vector;
        }
        Vector vector5 = (Vector)this.imagesVector.elementAt(0);
        this.currentImage = (BufferedImage)vector5.elementAt(1);
    }

    public void nextImage() {
        if (this.currentFrame >= this.imagesVector.size() - 1) {
            this.nextButton.setEnabled(false);
            this.stopAnimation();
        } else {
            Vector vector = (Vector)this.imagesVector.elementAt(++this.currentFrame);
            this.currentTitle = (String)vector.elementAt(0);
            this.currentImage = (BufferedImage)vector.elementAt(1);
            this.titleLabel.setText("Frame#" + this.currentFrame + ": " + this.currentTitle);
            this.imagePanel.setIcon(new ImageIcon(this.currentImage));
            if (!this.started && this.currentFrame > 0) {
                this.prevButton.setEnabled(true);
            }
            if (!this.started) {
                if (this.currentFrame >= this.imagesVector.size() - 1) {
                    this.nextButton.setEnabled(false);
                }
                if (this.currentFrame >= this.imagesVector.size() - 1) {
                    this.nextButton.setEnabled(false);
                }
            }
        }
    }

    public void prevImage() {
        if (this.currentFrame > 0) {
            Vector vector = (Vector)this.imagesVector.elementAt(--this.currentFrame);
            this.currentTitle = (String)vector.elementAt(0);
            this.currentImage = (BufferedImage)vector.elementAt(1);
            this.titleLabel.setText("Frame#" + this.currentFrame + ": " + this.currentTitle);
            this.imagePanel.setIcon(new ImageIcon(this.currentImage));
            this.nextButton.setEnabled(true);
            if (this.currentFrame == 0) {
                this.prevButton.setEnabled(false);
                this.rewindButton.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fpsTimer) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException : " + interruptedException);
            }
            this.nextImage();
        } else if (actionEvent.getSource() == this.startButton) {
            this.startAnimation();
        } else if (actionEvent.getSource() == this.pauseButton) {
            this.pauseAnimation();
        } else if (actionEvent.getSource() == this.stopButton) {
            this.stopAnimation();
        } else if (actionEvent.getSource() == this.rewindButton) {
            this.rewindAnimation();
        } else if (actionEvent.getSource() == this.prevButton) {
            this.prevImage();
        } else if (actionEvent.getSource() == this.nextButton) {
            this.nextImage();
        }
    }

    private void rewindAnimation() {
        this.currentFrame = 1;
        this.prevImage();
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.rewindButton.setEnabled(false);
        this.started = false;
        this.stopped = false;
        this.rewound = true;
    }

    private void startAnimation() {
        if (this.stopped) {
            this.rewindAnimation();
        }
        this.fpsTimer.start();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
        this.rewindButton.setEnabled(false);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.started = true;
        this.stopped = false;
        this.paused = false;
        this.rewound = false;
    }

    private void pauseAnimation() {
        this.fpsTimer.stop();
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.rewindButton.setEnabled(true);
        this.prevButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.started = false;
        this.stopped = false;
        this.paused = true;
        this.rewound = false;
    }

    private void stopAnimation() {
        this.currentFrame = 0;
        this.fpsTimer.stop();
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.rewindButton.setEnabled(false);
        this.rewindAnimation();
        this.started = false;
        this.stopped = true;
        this.paused = false;
        this.rewound = true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            if (n == 0) {
                if (this.started) {
                    this.stopAnimation();
                }
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(false);
                this.pauseButton.setEnabled(false);
                this.rewindButton.setEnabled(false);
                this.currentFrame = 0;
            } else {
                int n2 = 1000 / n;
                this.fpsTimer.setDelay(n2);
                if (this.paused) {
                    this.startAnimation();
                    this.startButton.setEnabled(false);
                    this.stopButton.setEnabled(true);
                    this.pauseButton.setEnabled(true);
                    this.rewindButton.setEnabled(true);
                } else if (this.stopped) {
                    this.startButton.setEnabled(true);
                    this.stopButton.setEnabled(false);
                    this.pauseButton.setEnabled(false);
                    this.rewindButton.setEnabled(false);
                }
            }
        }
    }

    public void run() {
        this.started = false;
        this.stopped = true;
        this.paused = false;
        this.rewound = true;
        float f = new Double(0.5).floatValue();
        this.fpsTimer = new Timer(1000 / this.fps_init, this);
        this.fpsTimer.setCoalesce(true);
        this.fpsLabel = new JLabel("Frame per second");
        this.fpsLabel.setAlignmentX(f);
        this.fpsSlider = new JSlider(0, 0, 24, this.fps_init);
        this.fpsSlider.setMajorTickSpacing(6);
        this.fpsSlider.setMinorTickSpacing(1);
        this.fpsSlider.setPaintTicks(true);
        this.fpsSlider.setPaintLabels(true);
        this.fpsSlider.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.fpsSlider.setAlignmentX(f);
        this.fpsSlider.addChangeListener(this);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(this);
        this.startButton.setActionCommand("start");
        this.startButton.setEnabled(true);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(this);
        this.pauseButton.setActionCommand("pause");
        this.pauseButton.setEnabled(false);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setActionCommand("stop");
        this.stopButton.setEnabled(false);
        this.rewindButton = new JButton("Rewind");
        this.rewindButton.addActionListener(this);
        this.rewindButton.setActionCommand("rewind");
        this.rewindButton.setEnabled(false);
        this.nextButton = new JButton("Next>");
        this.nextButton.addActionListener(this);
        this.nextButton.setActionCommand("next");
        this.nextButton.setEnabled(true);
        this.prevButton = new JButton("<Prev");
        this.prevButton.addActionListener(this);
        this.prevButton.setActionCommand("prev");
        this.prevButton.setEnabled(false);
        this.titleLabel.setAlignmentX(f);
        this.imagePanel = new JLabel(new ImageIcon(this.currentImage));
        this.imagePanel.setAlignmentX(f);
        this.imagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel.setAlignmentX(f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.startButton);
        jPanel.add(this.prevButton);
        jPanel.add(this.pauseButton);
        jPanel.add(this.nextButton);
        jPanel.add(this.stopButton);
        jPanel.add(this.rewindButton);
        ((JComponent)((Object)this)).setBackground(Color.lightGray);
        ((JInternalFrame)((Object)this)).getContentPane().setLayout(new BoxLayout(((JInternalFrame)((Object)this)).getContentPane(), 1));
        ((JInternalFrame)((Object)this)).getContentPane().add(this.titleLabel);
        ((JInternalFrame)((Object)this)).getContentPane().add(this.imagePanel);
        ((JInternalFrame)((Object)this)).getContentPane().add(this.fpsSlider);
        ((JInternalFrame)((Object)this)).getContentPane().add(this.fpsLabel);
        ((JInternalFrame)((Object)this)).getContentPane().add(jPanel);
        ((JInternalFrame)((Object)this)).pack();
        ((JComponent)((Object)this)).setVisible(true);
    }
}

