/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class BaseRowSet
implements Serializable,
Cloneable {
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rowSetType;
    private boolean showDeleted;
    private int queryTimeout;
    private int maxRows;
    private int maxFieldSize;
    private int concurrency;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir;
    private int fetchSize;
    private Map map;
    private Vector listeners = new Vector();
    private Vector params;

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    private void checkParamIndex(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter Index");
        }
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public Map getTypeMap() {
        return this.map;
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public String getUsername() {
        return this.username;
    }

    protected void initParams() {
        this.params = new Vector();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }

    protected void notifyRowChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = ((AbstractList)this.listeners).iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
            }
        }
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(2)};
        this.params.add(n - 1, objectArray);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(1)};
        this.params.add(n - 1, objectArray);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Byte(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, clob);
    }

    public void setCommand(String string) throws SQLException {
        this.command = new String(string);
        this.params.clear();
    }

    public void setConcurrency(int n) {
        this.concurrency = n;
    }

    public void setDataSourceName(String string) {
        this.dataSource = string == null ? null : new String(string);
        this.URL = null;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Double(d));
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.getType() == 1003 && n != 1000) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.fetchDir = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Float(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Long(l));
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, new Integer(n2), new String(string)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.params.add(n - 1, objectArray);
    }

    public void setPassword(String string) {
        this.password = new String(string);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, new Short(s));
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n);
        this.params.add(n - 1, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTransactionIsolation(int n) {
        this.isolation = n;
    }

    public void setType(int n) {
        this.rowSetType = n;
    }

    public void setTypeMap(Map map) {
        this.map = map;
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(0)};
        this.params.add(n - 1, objectArray);
    }

    public void setUrl(String string) throws SQLException {
        this.URL = string == null ? null : new String(string);
        this.dataSource = null;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }
}

