/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import sun.jdbc.rowset.SQLOutputImpl;
import sun.jdbc.rowset.SerialArray;
import sun.jdbc.rowset.SerialBlob;
import sun.jdbc.rowset.SerialClob;
import sun.jdbc.rowset.SerialRef;

class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private String SQLTypeName;
    private Object[] attribs;

    SerialStruct(SQLData sQLData, Map map) throws SQLException {
        this.SQLTypeName = new String(sQLData.getSQLTypeName());
        Vector vector = new Vector();
        sQLData.writeSQL(new SQLOutputImpl(vector, map));
        this.attribs = vector.toArray();
        System.out.println("Dump: " + this.attribs[0] + "," + this.attribs[1]);
    }

    SerialStruct(Struct struct, Map map) throws SQLException {
        this.SQLTypeName = new String(struct.getSQLTypeName());
        System.out.println("SQLTypeName: " + this.SQLTypeName);
        this.attribs = struct.getAttributes(map);
        this.mapToSerial(map);
    }

    public Object[] getAttributes() throws SQLException {
        return this.attribs;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        return this.attribs;
    }

    public String getSQLTypeName() throws SQLException {
        return this.SQLTypeName;
    }

    private void mapToSerial(Map map) throws SQLException {
        int n = 0;
        while (n < this.attribs.length) {
            if (this.attribs[n] instanceof Struct) {
                this.attribs[n] = new SerialStruct((Struct)this.attribs[n], map);
            } else if (this.attribs[n] instanceof SQLData) {
                this.attribs[n] = new SerialStruct((SQLData)this.attribs[n], map);
            } else if (this.attribs[n] instanceof Blob) {
                this.attribs[n] = new SerialBlob((Blob)this.attribs[n]);
            } else if (this.attribs[n] instanceof Clob) {
                this.attribs[n] = new SerialClob((Clob)this.attribs[n]);
            } else if (this.attribs[n] instanceof Ref) {
                this.attribs[n] = new SerialRef((Ref)this.attribs[n]);
            } else if (this.attribs[n] instanceof Array) {
                this.attribs[n] = new SerialArray((Array)this.attribs[n], map);
            }
            ++n;
        }
    }
}

