/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;
import sun.jdbc.rowset.BaseRow;

class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;

    InsertRow(int n) {
        this.origVals = new Object[n];
        this.colsInserted = new BitSet(n);
        this.cols = n;
    }

    protected Object getColumnObject(int n) throws SQLException {
        if (!this.colsInserted.get(n - 1)) {
            throw new SQLException("No value has been inserted");
        }
        return this.origVals[n - 1];
    }

    protected void initInsertRow() {
        int n = 0;
        while (n < this.cols) {
            this.colsInserted.clear(n);
            ++n;
        }
    }

    protected boolean isCompleteRow(RowSetMetaData rowSetMetaData) throws SQLException {
        int n = 0;
        while (n < this.cols) {
            if (!this.colsInserted.get(n) && rowSetMetaData.isNullable(n + 1) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void markColInserted(int n) {
        this.colsInserted.set(n);
    }

    protected void setColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
        this.markColInserted(n - 1);
    }
}

