/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import sun.jdbc.rowset.BaseRow;

class Row
extends BaseRow
implements Serializable,
Cloneable {
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    Row(int n) {
        this.origVals = new Object[n];
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    Row(int n, Object[] objectArray) {
        this.origVals = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            this.origVals[n2] = objectArray[n2];
            ++n2;
        }
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    protected void clearDeleted() {
        this.deleted = false;
    }

    protected void clearInserted() {
        this.inserted = false;
    }

    protected void clearUpdated() {
        this.updated = false;
        int n = 0;
        while (n < this.numCols) {
            this.currentVals[n] = null;
            this.colsChanged.clear(n);
            ++n;
        }
    }

    protected boolean getColUpdated(int n) {
        return this.colsChanged.get(n);
    }

    protected Object getColumnObject(int n) throws SQLException {
        if (this.getColUpdated(n - 1)) {
            return this.currentVals[n - 1];
        }
        return this.origVals[n - 1];
    }

    protected boolean getDeleted() {
        return this.deleted;
    }

    protected boolean getInserted() {
        return this.inserted;
    }

    protected boolean getUpdated() {
        return this.updated;
    }

    protected void initColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
    }

    protected void moveCurrentToOrig() {
        int n = 0;
        while (n < this.numCols) {
            if (this.getColUpdated(n)) {
                this.origVals[n] = this.currentVals[n];
                this.currentVals[n] = null;
                this.colsChanged.clear(n);
            }
            ++n;
        }
        this.updated = false;
    }

    private void setColUpdated(int n) {
        this.colsChanged.set(n);
    }

    protected void setColumnObject(int n, Object object) {
        this.currentVals[n - 1] = object;
        this.setColUpdated(n - 1);
    }

    protected void setDeleted() {
        this.deleted = true;
    }

    protected void setInserted() {
        this.inserted = true;
    }

    protected void setUpdated() {
        int n = 0;
        while (n < this.numCols) {
            if (this.getColUpdated(n)) {
                this.updated = true;
                return;
            }
            ++n;
        }
    }
}

