/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.POA;

import com.sun.corba.ee.ActivationIDL.POAIdMap;
import com.sun.corba.ee.ActivationIDL.POAIdMapHelper;
import com.sun.corba.ee.ActivationIDL.POAIdMapPackage.BadPOAId;
import com.sun.corba.ee.internal.POA.POAImpl;
import com.sun.corba.ee.internal.POA.POAORB;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.PortableServer.POA;

public class POATable {
    private Vector transientPoaVector = new Vector();
    private Vector transientPoaNamesVector = new Vector();
    private Hashtable persistentPOAs = new Hashtable();
    private Hashtable persistentPOANames = new Hashtable();
    private int temporaryCount = 1;
    private POAIdMap poaIdMap = null;
    private POAORB orb;

    POATable(POAORB pOAORB) {
        this.transientPoaVector.addElement(null);
        this.transientPoaNamesVector.addElement(null);
        this.orb = pOAORB;
    }

    int addPOA(POAImpl pOAImpl) {
        if (pOAImpl.getPolicies().isTransient()) {
            return this.addTransientPOA(pOAImpl);
        }
        return this.addPersistentPOA(pOAImpl);
    }

    private final int addPersistentPOA(POA pOA) {
        String[] stringArray = this.getPOANames(pOA.the_parent(), pOA.the_name());
        int n2 = this.getPOAIdMap().getId(stringArray);
        n2 = -n2;
        Integer n3 = new Integer(n2);
        this.persistentPOAs.put(n3, pOA);
        this.persistentPOANames.put(n3, stringArray);
        return n2;
    }

    private final synchronized int addTransientPOA(POA pOA) {
        int n2 = this.transientPoaVector.size();
        this.transientPoaVector.addElement(pOA);
        String[] stringArray = this.getPOANames(pOA.the_parent(), pOA.the_name());
        this.transientPoaNamesVector.addElement(stringArray);
        return n2;
    }

    private POAIdMap getPOAIdMap() {
        if (this.poaIdMap == null) {
            try {
                this.poaIdMap = POAIdMapHelper.narrow(this.orb.resolve_initial_references("POAIdMapper"));
            }
            catch (Exception exception) {
                throw new INITIALIZE("Could not find the POA-to-id mapper. Please ensure orbd has been started.");
            }
        }
        return this.poaIdMap;
    }

    private String[] getPOANames(POA pOA, String string) {
        int n2 = 1;
        POA pOA2 = pOA;
        while (pOA2 != null) {
            pOA2 = pOA2.the_parent();
            ++n2;
        }
        String[] stringArray = new String[n2];
        stringArray[n2 - 1] = string;
        pOA2 = pOA;
        int n3 = n2 - 2;
        while (n3 >= 0) {
            stringArray[n3] = pOA2.the_name();
            pOA2 = pOA2.the_parent();
            --n3;
        }
        return stringArray;
    }

    POA lookupPOA(int n2) {
        if (n2 > 0) {
            return (POA)this.transientPoaVector.elementAt(n2);
        }
        return (POA)this.persistentPOAs.get(new Integer(n2));
    }

    String[] lookupPOANames(int n2) {
        if (n2 > 0) {
            return (String[])this.transientPoaNamesVector.elementAt(n2);
        }
        Integer n3 = new Integer(n2);
        String[] stringArray = (String[])this.persistentPOANames.get(n3);
        if (stringArray == null) {
            try {
                stringArray = this.getPOAIdMap().getName(-n2);
            }
            catch (BadPOAId badPOAId) {
                return null;
            }
            this.persistentPOANames.put(n3, stringArray);
        }
        return stringArray;
    }

    void removePOA(POAImpl pOAImpl, int n2) {
        if (pOAImpl.getPolicies().isTransient()) {
            this.removeTransientPOA(pOAImpl, n2);
        } else {
            this.removePersistentPOA(pOAImpl, n2);
        }
    }

    private final void removePersistentPOA(POA pOA, int n2) {
        Integer n3 = new Integer(n2);
        this.persistentPOAs.remove(n3);
        this.persistentPOANames.remove(n3);
    }

    private final void removeTransientPOA(POA pOA, int n2) {
        this.transientPoaVector.setElementAt(null, n2);
        this.transientPoaNamesVector.setElementAt(null, n2);
    }
}

