/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.Message;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.util.Utility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected Connection conn;
    protected Message msg;

    public IIOPInputStream() {
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        this(connection.getORB(), connection);
        ORB oRB = connection.getORB();
        if (oRB.transportDebugFlag) {
            this.dprint("Constructing IIOPInputStream object");
        }
        this.buf = byArray;
        this.msg = message;
        this.index = 12;
        this.littleEndian = this.msg.isLittleEndian();
        this.size = this.msg.getSize();
        if (this.size > this.buf.length) {
            byte[] byArray2 = this.buf;
            this.buf = new byte[this.size];
            System.arraycopy(byArray2, 0, this.buf, 0, byArray2.length);
        }
        if (oRB.transportDebugFlag) {
            this.dprint("Reading the fully message");
        }
        Message.readFully(connection.getInputStream(), this.buf, this.index, this.size - this.index);
        if (oRB.transportDebugFlag) {
            this.dprint("Unmarshalling the GIOP message");
        }
        this.msg.read(this);
        if (oRB.transportDebugFlag) {
            this.dprint("Setting the time stamp");
        }
        connection.stampTime();
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super(oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n2, boolean bl2, Message message) {
        super(oRB, byArray, n2, bl2);
        this.msg = message;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final Message getMessage() {
        return this.msg;
    }

    protected void grow(int n2, int n3) {
        throw new MARSHAL(1398079496, CompletionStatus.COMPLETED_MAYBE);
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.orb = connection.getORB();
    }
}

