/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.io;

import com.sun.corba.ee.internal.io.ObjectStreamField;
import com.sun.corba.ee.internal.io.ValueUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private boolean isAbstractInterface = true;
    private boolean isAbstractComputed = false;
    private boolean hasSerialVersionUIDField = false;
    private static Class kObjectStreamFieldClazz = null;
    private static Hashtable translatedFields;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    private long suid = -1L;
    private long computedSuid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    Method writeReplaceObjectMethod;
    Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        try {
            Class.forName("com.sun.corba.ee.internal.io.LibraryManager").getDeclaredMethod("load", null).invoke(null, null);
            kObjectStreamFieldClazz = Class.forName("java.io.ObjectStreamField");
        }
        catch (Throwable throwable) {}
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl2, boolean bl3) {
        int n2;
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl2;
        this.externalizable = bl3;
        ObjectStreamClass.insertDescriptorFor(this);
        if (!this.serializable || this.externalizable || this.name.equals("java.lang.String")) {
            this.fields = new ObjectStreamField[0];
        } else if (this.serializable) {
            Field[] fieldArray;
            try {
                fieldArray = ObjectStreamClass.getDeclaredField(clazz, "serialPersistentFields");
                n2 = fieldArray.getModifiers();
                if (Modifier.isPrivate(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2) && fieldArray.getDeclaringClass().equals(kObjectStreamFieldClazz)) {
                    this.fields = (ObjectStreamField[])ObjectStreamClass.translateFields((Object[])fieldArray.get(clazz));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.fields = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.fields = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fields = null;
            }
            if (this.fields == null) {
                fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
                n2 = 0;
                ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                int n3 = 0;
                while (n3 < fieldArray.length) {
                    int n4 = fieldArray[n3].getModifiers();
                    if (!Modifier.isStatic(n4) && !Modifier.isTransient(n4)) {
                        objectStreamFieldArray[n2++] = new ObjectStreamField(fieldArray[n3]);
                    }
                    ++n3;
                }
                this.fields = new ObjectStreamField[n2];
                System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n2);
            } else {
                int n5 = this.fields.length - 1;
                while (n5 >= 0) {
                    try {
                        Field field = ObjectStreamClass.getDeclaredField(clazz, this.fields[n5].getName());
                        if (this.fields[n5].getType() == field.getType()) {
                            this.fields[n5].setField(field);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    --n5;
                }
            }
            if (this.fields.length > 1) {
                Arrays.sort(this.fields);
            }
            this.computeFieldInfo();
        }
        try {
            Field field = ObjectStreamClass.getDeclaredField(clazz, "serialVersionUID");
            n2 = field.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2)) {
                this.hasSerialVersionUIDField = true;
                this.suid = ObjectStreamClass.getSerialVersionUIDField(clazz);
                this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            } else {
                this.hasSerialVersionUIDField = false;
                this.suid = 0L;
                this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.hasSerialVersionUIDField = false;
            this.suid = 0L;
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
        }
        this.computedSuid = ObjectStreamClass._computeSerialVersionUID(this, clazz);
        try {
            Class[] classArray = new Class[]{class$java$io$ObjectOutputStream != null ? class$java$io$ObjectOutputStream : (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream"))};
            this.writeObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "writeObject", classArray);
            this.hasWriteObjectMethod = true;
            n2 = this.writeObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                this.writeObjectMethod = null;
                this.hasWriteObjectMethod = false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            this.writeReplaceObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "writeReplace", noTypesList);
            if (Modifier.isStatic(this.writeReplaceObjectMethod.getModifiers())) {
                this.writeReplaceObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            this.readResolveObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readResolve", noTypesList);
            if (Modifier.isStatic(this.readResolveObjectMethod.getModifiers())) {
                this.readResolveObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            Class[] classArray = new Class[]{class$java$io$ObjectInputStream != null ? class$java$io$ObjectInputStream : (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream"))};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readObject", classArray);
            n2 = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                this.readObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    ObjectStreamClass(String string, long l2) {
        this.name = string;
        this.suid = l2;
        this.superclass = null;
    }

    private static long _computeSerialVersionUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            Object object;
            Object object2;
            int n2;
            MethodSignature[] methodSignatureArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = ObjectStreamClass.getDeclaredMethods(clazz);
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            Class<?>[] classArray = clazz.getInterfaces();
            Arrays.sort(classArray, compareClassByName);
            int n4 = 0;
            while (n4 < classArray.length) {
                dataOutputStream.writeUTF(classArray[n4].getName());
                ++n4;
            }
            Field[] fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            int n5 = 0;
            while (n5 < fieldArray.length) {
                methodSignatureArray = fieldArray[n5];
                n2 = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n2) || !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n5;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(ObjectStreamClass.getDeclaredConstructors(clazz));
            n2 = 0;
            while (n2 < methodSignatureArray.length) {
                object2 = methodSignatureArray[n2];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n2;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n6 = 0;
            while (n6 < ((MethodSignature[])object2).length) {
                object = object2[n6];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n6;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n7 = 0;
            while (n7 < Math.min(8, ((Object)object).length)) {
                l2 += (long)(object[n7] & 0xFF) << n7 * 8;
                ++n7;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static boolean compareClassNames(String string, String string2, char c10) {
        int n2;
        int n3 = string.lastIndexOf(c10);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = string2.lastIndexOf(c10)) < 0) {
            n2 = 0;
        }
        return string.regionMatches(false, n3, string2, n2, string.length() - n3);
    }

    private final synchronized void computeAbstract(Class clazz) {
        this.isAbstractComputed = true;
        Method[] methodArray = ObjectStreamClass.getDeclaredMethods(clazz);
        if (!clazz.isInterface()) {
            this.isAbstractInterface = false;
            return;
        }
        if (methodArray.length == 0) {
            this.isAbstractInterface = false;
            return;
        }
        int n2 = methodArray.length - 1;
        while (n2 > -1) {
            Class<?>[] classArray = methodArray[n2].getExceptionTypes();
            if (classArray.length == 0) {
                this.isAbstractInterface = false;
                return;
            }
            this.isAbstractInterface = false;
            int n3 = classArray.length - 1;
            while (n3 > -1 && !this.isAbstractInterface) {
                if ((class$java$rmi$RemoteException != null ? class$java$rmi$RemoteException : ObjectStreamClass.class$("java.rmi.RemoteException")) == classArray[n3] || (class$java$lang$Throwable != null ? class$java$lang$Throwable : ObjectStreamClass.class$("java.lang.Throwable")) == classArray[n3] || (class$java$lang$Exception != null ? class$java$lang$Exception : ObjectStreamClass.class$("java.lang.Exception")) == classArray[n3] || (class$java$io$IOException != null ? class$java$io$IOException : ObjectStreamClass.class$("java.io.IOException")) == classArray[n3]) {
                    this.isAbstractInterface = true;
                }
                --n3;
            }
            --n2;
        }
        this.isAbstractInterface = this.isAbstractInterface && (this.superclass == null || this.superclass.isAbstractInterface());
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            switch (this.fields[n2].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                    break;
                }
            }
            ++n2;
        }
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            int n2;
            Object object;
            if (!(class$java$io$Serializable != null ? class$java$io$Serializable : (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable"))).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable != null ? class$java$io$Externalizable : (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable"))).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")))) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Field[] fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            int n3 = 0;
            while (n3 < fieldArray.length) {
                object = fieldArray[n3];
                n2 = ((Field)object).getModifiers();
                if (!Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    dataOutputStream.writeUTF(((Field)object).getName());
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object).getType()));
                }
                ++n3;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n4 = n2 = Math.min(8, ((Object)object).length);
            while (n4 > 0) {
                l2 += (long)(object[n4] & 0xFF) << n4 * 8;
                --n4;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n2 = clazz.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n3]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    private static Constructor[] getDeclaredConstructors(final Class clazz) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    private static Field getDeclaredField(final Class clazz, final String string) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchFieldException {
                    return clazz.getDeclaredField(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchFieldException)privilegedActionException.getException();
        }
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return clazz.getDeclaredMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchMethodException)privilegedActionException.getException();
        }
    }

    private static Method[] getDeclaredMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    public final ObjectStreamField getField(String string) {
        int n2 = this.fields.length - 1;
        while (n2 >= 0) {
            if (string.equals(this.fields[n2].getName())) {
                return this.fields[n2];
            }
            --n2;
        }
        return null;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final String getName() {
        return this.name;
    }

    public final long getSerialVersionUID() {
        if (this.hasSerialVersionUIDField) {
            return this.suid;
        }
        return this.computedSuid;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    private static native long getSerialVersionUIDField(Class var0);

    public final String getSerialVersionUIDStr() {
        if (this.hasSerialVersionUIDField) {
            if (this.suidStr == null) {
                this.suidStr = Long.toHexString(this.suid).toUpperCase();
            }
            return this.suidStr;
        }
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.computedSuid).toUpperCase();
        }
        return this.suidStr;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("[");
                ++n3;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    public boolean hasField(ValueMember valueMember) {
        int n2 = 0;
        while (n2 < this.fields.length) {
            try {
                if (this.fields[n2].getName().equals(valueMember.name) && this.fields[n2].getSignature().equals(ValueUtility.getSignature(valueMember))) {
                    return true;
                }
            }
            catch (Throwable throwable) {}
            ++n2;
        }
        return false;
    }

    public boolean hasSerialVersionUIDField() {
        return this.hasSerialVersionUIDField;
    }

    private static native boolean hasStaticInitializer(Class var0);

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n2 = objectStreamClass.ofClass.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n3];
        ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry;
    }

    public final boolean isAbstractInterface() {
        if (!this.isAbstractComputed) {
            this.computeAbstract(this.ofClass);
        }
        return this.isAbstractInterface;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        return objectStreamClass;
    }

    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (objectStreamClassEntryArray) {
            Class clazz2;
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass != null) {
                ObjectStreamClass objectStreamClass2 = objectStreamClass;
                Object var4_4 = null;
                return objectStreamClass2;
            }
            boolean bl2 = classSerializable.isAssignableFrom(clazz);
            boolean bl3 = classExternalizable.isAssignableFrom(clazz);
            if (bl3) {
                bl2 = false;
            }
            ObjectStreamClass objectStreamClass3 = null;
            if (clazz.getSuperclass() != (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class"))) && (clazz2 = clazz.getSuperclass()) != null) {
                objectStreamClass3 = ObjectStreamClass.lookup(clazz2);
            }
            objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass3, bl2, bl3);
        }
        return objectStreamClass;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid && (!clazz.isArray() || clazz.getName().equals(this.name))) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(this.name, "Incompatible local class name: " + clazz.getName());
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectStreamFieldArray2.length) {
            int n4 = n2;
            while (n4 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n3].getName().equals(objectStreamFieldArray[n4].getName())) {
                    if (objectStreamFieldArray2[n3].isPrimitive() && !objectStreamFieldArray2[n3].typeEquals(objectStreamFieldArray[n4])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n3].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n2 = n4;
                    objectStreamFieldArray2[n3].setField(objectStreamFieldArray[n2].getField());
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        try {
            Class[] classArray = new Class[]{class$java$io$ObjectInputStream != null ? class$java$io$ObjectInputStream : (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream"))};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readObject", classArray);
            int n5 = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n5) || Modifier.isStatic(n5)) {
                this.readObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private static Object[] translateFields(Object[] objectArray) throws NoSuchFieldException {
        try {
            java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])objectArray;
            Object[] objectArray2 = null;
            if (translatedFields == null) {
                translatedFields = new Hashtable();
            }
            if ((objectArray2 = (Object[])translatedFields.get(objectStreamFieldArray)) != null) {
                return objectArray2;
            }
            Class<?> clazz = Class.forName("com.sun.corba.ee.internal.io.ObjectStreamField");
            objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            Object[] objectArray3 = new Object[2];
            Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ObjectStreamClass.class$("java.lang.String")), class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class"))};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            int n2 = objectStreamFieldArray.length - 1;
            while (n2 >= 0) {
                objectArray3[0] = objectStreamFieldArray[n2].getName();
                objectArray3[1] = objectStreamFieldArray[n2].getType();
                objectArray2[n2] = constructor.newInstance(objectArray3);
                --n2;
            }
            translatedFields.put(objectStreamFieldArray, objectArray2);
            return objectArray2;
        }
        catch (Throwable throwable) {
            throw new NoSuchFieldException();
        }
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke((Object)serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }

    private static class CompareClassByName
    implements Comparator {
        CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = String.valueOf(string) + ObjectStreamClass.getSignature((Method)object);
                string2 = String.valueOf(string2) + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = String.valueOf(string) + ObjectStreamClass.getSignature((Constructor)object);
                string2 = String.valueOf(string2) + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n3].getModifiers())) {
                    ++n2;
                }
                ++n3;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n5].getModifiers())) {
                    methodSignatureArray[n4] = new MethodSignature(memberArray[n5]);
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }
    }
}

