/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;

public final class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private EJBHome ejbHomeStub;
    private Class keyClass;
    private Class homeClass;
    private Class remoteClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;

    public EJBMetaDataImpl(EJBHome ejbHomeStub, Class homeClass, Class remoteClass, Class keyClass, boolean isSessionBean, boolean isStatelessSessionBean) {
        this.ejbHomeStub = ejbHomeStub;
        this.keyClass = keyClass;
        this.homeClass = homeClass;
        this.remoteClass = remoteClass;
        this.isSessionBean = isSessionBean;
        this.isStatelessSessionBean = isStatelessSessionBean;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeStub;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getPrimaryKeyClass() {
        if (this.keyClass == null) {
            throw new RuntimeException("SessionBeans do not have a primary key");
        }
        return this.keyClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.ejbHomeStub = (EJBHome)in.readObject();
        this.isSessionBean = in.readBoolean();
        ClassLoader loader = this.ejbHomeStub.getClass().getClassLoader();
        String name = in.readUTF();
        this.remoteClass = loader.loadClass(name);
        name = in.readUTF();
        this.homeClass = loader.loadClass(name);
        name = in.readUTF();
        this.keyClass = name.equals("null") ? null : loader.loadClass(name);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.ejbHomeStub);
        out.writeBoolean(this.isSessionBean);
        out.writeUTF(this.remoteClass.getName());
        out.writeUTF(this.homeClass.getName());
        if (this.keyClass != null) {
            out.writeUTF(this.keyClass.getName());
        } else {
            out.writeUTF("null");
        }
    }
}

