/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.activation.Activator;
import com.sun.enterprise.activation.BadServerDefinition;
import com.sun.enterprise.activation.Repository;
import com.sun.enterprise.activation.ServerAlreadyRegisteredException;
import com.sun.enterprise.activation.ServerDef;
import com.sun.enterprise.activation.ServerNotRegisteredException;
import com.sun.enterprise.activation.ServerTableEntry;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class RepositoryImpl
implements Repository,
Serializable {
    static final boolean debug = false;
    static final int illegalServerId = -1;
    private transient RepositoryDB db = null;
    transient J2EEServer j2eeServer;
    transient File dbDir;
    transient Activator activator;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$activation$RepositoryImpl != null ? class$com$sun$enterprise$activation$RepositoryImpl : (class$com$sun$enterprise$activation$RepositoryImpl = RepositoryImpl.class$("com.sun.enterprise.activation.RepositoryImpl")));
    static /* synthetic */ Class class$com$sun$enterprise$activation$RepositoryImpl;

    public RepositoryImpl(File dbDir, J2EEServer j2eeServer) {
        this.j2eeServer = j2eeServer;
        this.dbDir = dbDir;
        File dbFile = new File(dbDir, "servers.db");
        if (!dbFile.exists()) {
            this.db = new RepositoryDB(dbFile);
            this.db.flush();
        } else {
            try {
                FileInputStream fis = new FileInputStream(dbFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.db = (RepositoryDB)ois.readObject();
                ois.close();
            }
            catch (Exception e10) {
                System.err.println(e10.toString());
                System.err.println(localStrings.getLocalString("repository.imr_read", "Unable to read server repository!"));
                throw new INITIALIZE(3001, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Vector getApplicationNames() throws RemoteException {
        Vector<String> v2 = new Vector<String>();
        Enumeration serverIds = this.db.serverTable.keys();
        while (serverIds.hasMoreElements()) {
            Integer nextServerId = (Integer)serverIds.nextElement();
            DBServerDef dbServerDef = (DBServerDef)this.db.serverTable.get(nextServerId);
            if (dbServerDef.alias.equals("NameServer") || dbServerDef.alias.equals("AuthenticationServer")) continue;
            v2.addElement(dbServerDef.alias);
        }
        return v2;
    }

    public ServerDef getServer(int serverId) throws RemoteException, ServerNotRegisteredException {
        Integer id = new Integer(serverId);
        DBServerDef server = (DBServerDef)this.db.serverTable.get(id);
        if (server == null) {
            throw new ServerNotRegisteredException();
        }
        ServerDef serverDef = new ServerDef(server.alias, server.name, server.classPath, server.args, server.vmArgs);
        return serverDef;
    }

    public int getServerID(String applicationName) throws RemoteException {
        Enumeration serverIds = this.db.serverTable.keys();
        while (serverIds.hasMoreElements()) {
            Integer nextServerId = (Integer)serverIds.nextElement();
            DBServerDef dbServerDef = (DBServerDef)this.db.serverTable.get(nextServerId);
            if (!dbServerDef.alias.equals(applicationName)) continue;
            System.out.println("Server id for " + applicationName + " is " + nextServerId);
            return nextServerId;
        }
        return -1;
    }

    public int[] listRegisteredServers() throws RemoteException {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            int i2 = 0;
            int[] servers = new int[this.db.serverTable.size()];
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                DBServerDef server = (DBServerDef)enumeration.nextElement();
                servers[i2++] = server.id;
            }
            int[] nArray = servers;
            Object var3_7 = null;
            return nArray;
        }
    }

    public int registerServer(ServerDef serverDef) throws RemoteException, BadServerDefinition {
        int serverId = -1;
        try {
            serverId = this.registerServerDef(serverDef, -1);
        }
        catch (ServerAlreadyRegisteredException serverAlreadyRegisteredException) {
            throw new BadServerDefinition("server already registered.");
        }
        catch (Exception c10) {
            c10.printStackTrace();
            return -1;
        }
        int initSvcPort = this.j2eeServer.getORBInitialPort();
        ServerTableEntry entry = new ServerTableEntry(serverId, serverDef, initSvcPort, this.dbDir.getAbsolutePath(), true, this.j2eeServer.getEjbdPort(), true);
        return serverId;
    }

    public int registerServerDef(ServerDef serverDef, int theServerId) throws ServerAlreadyRegisteredException {
        DBServerDef server = null;
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            Enumeration enumeration = this.db.serverTable.elements();
            while (enumeration.hasMoreElements()) {
                server = (DBServerDef)enumeration.nextElement();
                if (!serverDef.alias.equals(server.alias) || !serverDef.serverName.equals(server.name) || !serverDef.serverClassPath.equals(server.classPath) || !serverDef.serverArgs.equals(server.args)) continue;
                throw new ServerAlreadyRegisteredException(server.id);
            }
            int serverID = theServerId == -1 ? this.db.incrementServerIdCounter() : theServerId;
            server = new DBServerDef(serverDef, serverID);
            this.db.serverTable.put(new Integer(serverID), server);
            this.db.flush();
            int n2 = serverID;
            Object var7_8 = null;
            return n2;
        }
    }

    public void setActivator(Activator activator) {
        this.activator = activator;
    }

    public void unregisterServer(int serverId) throws RemoteException, ServerNotRegisteredException {
        DBServerDef server = null;
        Integer id = new Integer(serverId);
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            server = (DBServerDef)this.db.serverTable.get(id);
            if (server == null) {
                throw new ServerNotRegisteredException();
            }
            this.db.serverTable.remove(id);
            this.db.flush();
        }
    }

    class RepositoryDB
    implements Serializable {
        File db;
        Hashtable serverTable;
        Integer serverIdCounter;

        RepositoryDB(File dbFile) {
            this.db = dbFile;
            this.serverTable = new Hashtable(255);
            this.serverIdCounter = new Integer(256);
        }

        void flush() {
            try {
                this.db.delete();
                FileOutputStream fos = new FileOutputStream(this.db);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this);
                oos.flush();
                oos.close();
            }
            catch (Exception ex2) {
                System.err.println(ex2.toString());
                System.err.println(localStrings.getLocalString("repository.imr_write", "Unable to write server repository!"));
                throw new INTERNAL(3001, CompletionStatus.COMPLETED_NO);
            }
        }

        int incrementServerIdCounter() {
            int value = this.serverIdCounter;
            this.serverIdCounter = new Integer(++value);
            return value;
        }
    }

    class DBServerDef
    implements Serializable {
        String alias;
        String name;
        String classPath;
        String args;
        String vmArgs;
        int id;

        DBServerDef(ServerDef server, int server_id) {
            this.alias = server.alias;
            this.name = server.serverName;
            this.classPath = server.serverClassPath;
            this.args = server.serverArgs;
            this.vmArgs = server.serverVmArgs;
            this.id = server_id;
        }
    }
}

