/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EjbBundleArchivist
extends Archivist {
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/ejb-jar.xml";
    private EjbBundleDescriptor ejbBundleDescriptor;
    private ClassLoader classLoader = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbBundleArchivist != null ? class$com$sun$enterprise$deployment$EjbBundleArchivist : (class$com$sun$enterprise$deployment$EjbBundleArchivist = EjbBundleArchivist.class$("com.sun.enterprise.deployment.EjbBundleArchivist")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleArchivist;

    public EjbBundleArchivist(String archiveUri, EjbBundleDescriptor ejbBundleDescriptor) {
        this(true, archiveUri, ejbBundleDescriptor, new HashSet());
    }

    public EjbBundleArchivist(String archiveUri, EjbBundleDescriptor ejbBundleDescriptor, Set manifestClasspath) {
        this(true, archiveUri, ejbBundleDescriptor, manifestClasspath);
    }

    public EjbBundleArchivist(boolean hasArchiveFile, String archiveUri, EjbBundleDescriptor ejbBundleDescriptor, Set manifestClasspath) {
        super(archiveUri, hasArchiveFile);
        this.manifestClasspath = manifestClasspath;
        this.ejbBundleDescriptor = ejbBundleDescriptor;
        this.ejbBundleDescriptor.setArchivist(this);
    }

    public void addEjbJar(File ejbJar) throws IOException, ArchiveException {
        EjbBundleDescriptor ejbBundleDescriptorToAdd = EjbBundleArchivist.open(ejbJar);
        this.ejbBundleDescriptor.addEjbBundleDescriptor(ejbBundleDescriptorToAdd);
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(this.getEjbJarFile()));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        JarFile thisJar = new JarFile(this.getEjbJarFile());
        JarFile jarToAdd = new JarFile(ejbJar);
        Archivist.addJarToOutput(outZipStream, thisJar, entriesNotToAdd);
        Archivist.addJarToOutput(outZipStream, jarToAdd, entriesNotToAdd);
        this.writeDeploymentInfo(outZipStream);
        Manifest ejbJarManifest = super.createManifest();
        Archivist.writeManifest(ejbJarManifest, outZipStream);
        outZipStream.close();
        fos.close();
        this.setClassLoader(null);
        if (!scratchFile.renameTo(this.getEjbJarFile())) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fcd) throws IOException {
        Hashtable entryNameMap = super.createEntryNameMap(fcd);
        entryNameMap.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        return entryNameMap;
    }

    public static void createPackage(FileContentsDescriptor fcd, File descriptorFile, File destinationFile) throws IOException, ArchiveException {
        if (!descriptorFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackageejbs", "Cannot package Ejbs: {0} does not exist.", new Object[]{descriptorFile}));
        }
        FileInputStream fis = new FileInputStream(descriptorFile);
        EjbBundleDescriptor ejbBundleDescriptor = null;
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(fis);
        fis.close();
        if (ejbBundleNodes.size() > 0) {
            EjbBundleNode ejbBundleNode = (EjbBundleNode)ejbBundleNodes.elementAt(0);
            ejbBundleDescriptor = ejbBundleNode.getDescriptor();
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destinationFile));
            EjbBundleArchivist archivist = new EjbBundleArchivist(destinationFile.toString(), ejbBundleDescriptor);
            archivist.setClassLoader(fcd.getClassLoader());
            Enumeration e10 = fcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextFile = (File)e10.nextElement();
                File actualFile = fcd.getFullFileFor(nextFile);
                String archiveName = nextFile.toString();
                archiveName = archiveName.replace(File.separatorChar, '/');
                ZipEntry entry = new ZipEntry(archiveName);
                entry.setTime(System.currentTimeMillis());
                fis = new FileInputStream(actualFile);
                zipOut.putNextEntry(entry);
                Archivist.copy(fis, zipOut);
                fis.close();
                zipOut.closeEntry();
            }
            archivist.writeDeploymentInfo(zipOut);
            Manifest manifest = archivist.createManifest();
            Archivist.writeManifest(manifest, zipOut);
            zipOut.close();
            System.out.println(localStrings.getLocalString("enterprise.deployment.createdejbjar", "Created EJB JAR {0}", new Object[]{destinationFile}));
        } else {
            System.out.println(localStrings.getLocalString("enterprise.deployment.nodeployinfoindescriptorfile", "There was no deployment information in {0}", new Object[]{descriptorFile}));
        }
    }

    protected File getArchiveFile() throws IOException {
        if (!this.hasArchive()) {
            throw new IOException("No archive file for " + this);
        }
        File archiveFile = null;
        Application application = this.ejbBundleDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist appArchivist = application.getApplicationArchivist();
            File applicationFile = appArchivist.getApplicationFile();
            archiveFile = Archivist.getEjbTemp(Archivist.getDirectory(applicationFile));
            appArchivist.extractBundleToFile(this.ejbBundleDescriptor, archiveFile);
            archiveFile.deleteOnExit();
        } else {
            archiveFile = this.getEjbJarFile();
        }
        return archiveFile;
    }

    public ClassLoader getClassLoader() {
        block3: {
            if (this.classLoader != null) break block3;
            if (this.ejbBundleDescriptor.getApplication() != null) {
                return this.ejbBundleDescriptor.getApplication().getApplicationArchivist().getClassLoader();
            }
            try {
                JarClassLoader jcl = new JarClassLoader();
                jcl.addJar(new File(this.getArchiveUri()).getAbsolutePath());
                this.classLoader = jcl;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return this.classLoader;
    }

    public Descriptor getDescriptor() {
        return this.ejbBundleDescriptor;
    }

    public File getEjbJarFile() {
        return new File(this.getArchiveUri());
    }

    private boolean hasClassFiles(Hashtable entryNameMap) {
        boolean hasClassFiles = false;
        Enumeration e10 = entryNameMap.keys();
        while (e10.hasMoreElements()) {
            String nextEntry = (String)e10.nextElement();
            if (!nextEntry.endsWith(".class")) continue;
            hasClassFiles = true;
            break;
        }
        return hasClassFiles;
    }

    public boolean isDeletable(String entryName) {
        boolean entryIsDeletable = true;
        if (entryName.equals("META-INF/MANIFEST.MF") || entryName.equals(DEPLOYMENT_DESCRIPTOR_ENTRY)) {
            entryIsDeletable = false;
        }
        return entryIsDeletable;
    }

    public static boolean isEjbBundle(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isEjbBundle = ze != null;
        jar.close();
        return isEjbBundle;
    }

    private boolean isStructuralEjbBundleClass(EjbBundleDescriptor bundle, String className) {
        boolean structuralEjbBundleClass = false;
        Set ejbs = bundle.getEjbs();
        Iterator iter = ejbs.iterator();
        while (iter.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iter.next();
            if (!this.isStructuralEjbClass(ejbDescriptor, className)) continue;
            structuralEjbBundleClass = true;
            break;
        }
        return structuralEjbBundleClass;
    }

    private boolean isStructuralEjbClass(EjbDescriptor desc, String className) {
        return desc.getHomeClassName().equals(className) || desc.getRemoteClassName().equals(className) || desc.getEjbClassName().equals(className);
    }

    public static EjbBundleDescriptor open(File ejbJarFile) throws IOException, ArchiveException {
        if (!ejbJarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionejabjardoesnotexist", "{0} does not exist", new Object[]{ejbJarFile}));
        }
        JarFile jar = new JarFile(ejbJarFile);
        EjbBundleDescriptor descriptor = EjbBundleArchivist.open(ejbJarFile, DEPLOYMENT_DESCRIPTOR_ENTRY, jar);
        jar.close();
        try {
            Descriptor.isBoundsChecking();
        }
        catch (Exception exception) {}
        ((EjbBundleArchivist)descriptor.getArchivist()).setClassLoader(null);
        return descriptor;
    }

    static EjbBundleDescriptor open(File ejbJarFile, String descriptorEntryName, JarFile jarContainingDescriptor) throws IOException, ArchiveException {
        if (!ejbJarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionejbjarafiledoesnotexist", "{0} does not exist", new Object[]{ejbJarFile}));
        }
        ZipEntry deploymentEntry = jarContainingDescriptor.getEntry(descriptorEntryName);
        if (deploymentEntry != null) {
            InputStream is = jarContainingDescriptor.getInputStream(deploymentEntry);
            EjbBundleNode node = EjbBundleNode.read(is);
            is.close();
            EjbBundleDescriptor ejbBundleDescriptor = node.getDescriptor();
            EjbBundleArchivist archivist = new EjbBundleArchivist(ejbJarFile.toString(), ejbBundleDescriptor);
            archivist.setManifestClasspaths(jarContainingDescriptor.getManifest());
            ejbBundleDescriptor.setArchivist(archivist);
            return ejbBundleDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeoployinfofoundatinjarcontainerdescriptor", "No deployment info found at: {0} in {1}", new Object[]{descriptorEntryName, jarContainingDescriptor.getName()}));
    }

    public void removeEntries(Vector entriesToRemove) throws IOException {
        super.removeEntries(entriesToRemove);
        this.ejbBundleDescriptor.changed();
    }

    public void save(File destinationFile) throws IOException {
        this.save(destinationFile, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File destinationFile, String descriptorEntryName, ZipOutputStream descriptorOut) throws IOException {
        File tmpFile = Archivist.getEjbTemp(Archivist.getDirectory(destinationFile));
        ZipOutputStream fileOut = new ZipOutputStream(new FileOutputStream(tmpFile));
        if (descriptorOut == null) {
            this.writeDeploymentInfo(fileOut, descriptorEntryName);
        } else {
            this.writeDeploymentInfo(descriptorOut, descriptorEntryName);
        }
        Manifest ejbJarManifest = super.createManifest();
        Archivist.writeManifest(ejbJarManifest, fileOut);
        Vector<String> entryNamesToSkip = new Vector<String>();
        if (descriptorOut == null) {
            entryNamesToSkip.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        }
        entryNamesToSkip.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(fileOut, entryNamesToSkip);
        fileOut.close();
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, destinationFile.toString());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        return "EjbBundleArchivist " + this.getArchiveUri();
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        super.updateFiles(newFiles);
        if (this.hasClassFiles(newFiles)) {
            this.setClassLoader(null);
            Application application = this.ejbBundleDescriptor.getApplication();
            if (application == null) {
                throw new IOException("Couldn't get application archivist");
            }
            ApplicationArchivist appArchivist = application.getApplicationArchivist();
            appArchivist.setClassLoader(null);
            this.ejbBundleDescriptor.classesChanged();
        }
        this.ejbBundleDescriptor.changed();
    }

    public void writeDeploymentInfo(ZipOutputStream zos) throws IOException {
        this.writeDeploymentInfo(zos, DEPLOYMENT_DESCRIPTOR_ENTRY);
    }

    private void writeDeploymentInfo(ZipOutputStream zos, String entryName) throws IOException {
        Archivist.writeDocumentToJar(EjbBundleNode.getDocument(this.ejbBundleDescriptor), entryName, zos);
    }
}

