/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Hashtable;

public class EjbSessionDescriptor
extends EjbDescriptor {
    private boolean isStateless = false;
    private int timeout = 0;
    public static String TYPE = "Session";
    public static String STATELESS = "Stateless";
    public static String STATEFUL = "Stateful";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbSessionDescriptor != null ? class$com$sun$enterprise$deployment$EjbSessionDescriptor : (class$com$sun$enterprise$deployment$EjbSessionDescriptor = EjbSessionDescriptor.class$("com.sun.enterprise.deployment.EjbSessionDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbSessionDescriptor;

    public EjbSessionDescriptor() {
    }

    public EjbSessionDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor session = (EjbSessionDescriptor)other;
            this.isStateless = session.isStateless;
            this.timeout = session.timeout;
        }
    }

    public EjbSessionDescriptor(String name, String homeClassName, String remoteClassName, String ejbClassName) {
        super(name, homeClassName, remoteClassName, ejbClassName);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getSessionTypeString() {
        if (this.isStateless()) {
            return STATELESS;
        }
        return STATEFUL;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public void setSessionTypeString(String sessionType) {
        if (STATELESS.equals(sessionType)) {
            this.setStateless(true);
            return;
        }
        if (STATEFUL.equals(sessionType)) {
            this.setStateless(false);
            return;
        }
        if (Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", new Object[]{sessionType, STATEFUL, STATELESS}));
        }
    }

    public void setStateless(boolean isStateless) {
        this.isStateless = isStateless;
        super.changed();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl2 = isValidType = EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType) || EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType);
        if (!isValidType && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", new Object[]{transactionType}));
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    public String toString() {
        String s2 = super.toString();
        s2 = String.valueOf(s2) + "Session descriptor";
        s2 = String.valueOf(s2) + "\n isStateless " + this.isStateless;
        return s2;
    }
}

