/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebDescriptorFactoryImpl;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tomcat.deployment.WebApplicationReader;

public class WebBundleArchivist
extends Archivist {
    public static final String DESTINATION_CLASSES = "WEB-INF" + File.separator + "classes";
    private static String WEB_INF = "WEB-INF/";
    public static String SERVLET_ENTRY_ROOT = String.valueOf(WEB_INF) + "classes";
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = String.valueOf(WEB_INF) + "web.xml";
    public static String LIBRARY_ENTRY_ROOT = String.valueOf(WEB_INF) + "lib";
    private WebBundleDescriptor webBundleDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$WebBundleArchivist != null ? class$com$sun$enterprise$deployment$WebBundleArchivist : (class$com$sun$enterprise$deployment$WebBundleArchivist = WebBundleArchivist.class$("com.sun.enterprise.deployment.WebBundleArchivist")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleArchivist;

    public WebBundleArchivist(String archiveUri, WebBundleDescriptor webBundleDescriptor) {
        this(true, archiveUri, webBundleDescriptor);
    }

    public WebBundleArchivist(boolean hasArchiveFile, String archiveUri, WebBundleDescriptor webBundleDescriptor) {
        super(archiveUri, hasArchiveFile);
        this.webBundleDescriptor = webBundleDescriptor;
        this.webBundleDescriptor.setArchivist(this);
    }

    public void addWebJar(File webJar) throws IOException, ArchiveException {
        WebBundleDescriptor webBundleDescriptorToAdd = WebBundleArchivist.open(webJar);
        this.webBundleDescriptor.addWebBundleDescriptor(webBundleDescriptorToAdd);
        File scratchFile = Archivist.createTempFile(Archivist.getDirectory(this.getWebJarFile()));
        FileOutputStream fos = new FileOutputStream(scratchFile);
        ZipOutputStream outZipStream = new ZipOutputStream(fos);
        Vector<String> entriesNotToAdd = new Vector<String>();
        entriesNotToAdd.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        entriesNotToAdd.addElement("META-INF/MANIFEST.MF");
        JarFile thisJar = new JarFile(this.getWebJarFile());
        JarFile jarToAdd = new JarFile(webJar);
        Archivist.addJarToOutput(outZipStream, thisJar, entriesNotToAdd);
        Archivist.addJarToOutput(outZipStream, jarToAdd, entriesNotToAdd);
        this.writeDeploymentInfo(outZipStream);
        Manifest webarManifest = super.createManifest();
        Archivist.writeManifest(webarManifest, outZipStream);
        outZipStream.close();
        fos.close();
        if (!scratchFile.renameTo(this.getWebJarFile())) {
            System.out.println("Error renaming JAR");
        }
    }

    private static void checkJspFileIncluded(WebBundleDescriptor descriptor, FileContentsDescriptor staticContent) throws IOException {
        Iterator itr = descriptor.getJspDescriptors().iterator();
        while (itr.hasNext()) {
            JspDescriptorImpl jspDescriptor = (JspDescriptorImpl)itr.next();
            String declaredFilename = jspDescriptor.getJspFileName();
            if (staticContent.getFilesSet().contains(new File(declaredFilename))) continue;
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptiondeploymentdescriptor", "The deployment descriptor declares the jsp with filename attribute: {0} but it is not present in: {1}", new Object[]{jspDescriptor.getJspFileName(), staticContent}));
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private Hashtable createClassEntryNameMap(FileContentsDescriptor classes) throws IOException {
        Hashtable<String, File> entryNameMap = new Hashtable<String, File>();
        Enumeration e10 = classes.getFiles();
        while (e10.hasMoreElements()) {
            File nextRelativeFile = (File)e10.nextElement();
            File actualFile = classes.getFullFileFor(nextRelativeFile);
            String entryName = "";
            entryName = nextRelativeFile.toString().endsWith(".class") ? String.valueOf(SERVLET_ENTRY_ROOT) + "/" + nextRelativeFile.toString().replace(File.separatorChar, '/') : (nextRelativeFile.toString().endsWith(".jar") ? String.valueOf(LIBRARY_ENTRY_ROOT) + "/" + nextRelativeFile.toString().replace(File.separatorChar, '/') : String.valueOf(SERVLET_ENTRY_ROOT) + "/" + nextRelativeFile.getName());
            entryNameMap.put(entryName, actualFile);
        }
        return entryNameMap;
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor classes, FileContentsDescriptor staticContent) throws IOException {
        Hashtable entryNameMap = super.createEntryNameMap(staticContent);
        Hashtable classEntryNameMap = this.createClassEntryNameMap(classes);
        entryNameMap.putAll(classEntryNameMap);
        entryNameMap.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        return entryNameMap;
    }

    public static void createPackage(FileContentsDescriptor classFcd, FileContentsDescriptor staticContentsFcd, File descriptorFile, File destinationFile) throws IOException, ArchiveException {
        System.out.println(staticContentsFcd);
        if (!descriptorFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackagewebapp", "Cannot package web application: {0} does not exist.", new Object[]{descriptorFile}));
        }
        FileInputStream fis = new FileInputStream(descriptorFile);
        WebDescriptorFactoryImpl factory = new WebDescriptorFactoryImpl();
        WebApplicationReader reader = new WebApplicationReader();
        WebBundleDescriptor descriptor = null;
        try {
            descriptor = (WebBundleDescriptor)reader.getDescriptor(fis, factory, false);
        }
        catch (Throwable t2) {
            fis.close();
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptoinreadingwebxml", "Error reading web xml: {0}", new Object[]{t2.getMessage()}));
        }
        if (descriptor != null) {
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destinationFile));
            WebBundleArchivist archivist = new WebBundleArchivist(destinationFile.toString(), descriptor);
            Enumeration e10 = staticContentsFcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextRelativeFile = (File)e10.nextElement();
                File actualFile = staticContentsFcd.getFullFileFor(nextRelativeFile);
                String entryName = nextRelativeFile.toString().replace(File.separatorChar, '/');
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(entryName)) continue;
                WebBundleArchivist.writeEntry(entryName, fis, zipOut, actualFile);
            }
            fis.close();
            WebBundleArchivist.checkJspFileIncluded(descriptor, staticContentsFcd);
            Enumeration e11 = classFcd.getFiles();
            while (e11.hasMoreElements()) {
                File nextRelativeFile = (File)e11.nextElement();
                File actualFile = classFcd.getFullFileFor(nextRelativeFile);
                String entryName = "";
                entryName = nextRelativeFile.toString().endsWith(".class") ? String.valueOf(SERVLET_ENTRY_ROOT) + "/" + nextRelativeFile.toString().replace(File.separatorChar, '/') : (nextRelativeFile.toString().endsWith(".jar") ? String.valueOf(LIBRARY_ENTRY_ROOT) + "/" + nextRelativeFile.toString().replace(File.separatorChar, '/') : String.valueOf(SERVLET_ENTRY_ROOT) + "/" + nextRelativeFile.getName());
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(entryName)) continue;
                WebBundleArchivist.writeEntry(entryName, fis, zipOut, actualFile);
            }
            archivist.writeDeploymentInfo(zipOut);
            zipOut.close();
            System.out.println(localStrings.getLocalString("enterprise.deployment.createdwebapp", "Created WebApplication {0}", new Object[]{destinationFile}));
        }
    }

    public static void createPackage(String servletClasspath, Vector classFiles, Vector libraryFiles, String contentRoot, Vector contentFiles, String descriptorFilename, String destinationFile) throws IOException, ArchiveException {
        contentFiles = new Vector(WebBundleArchivist.getContentFilesToAdd(contentFiles, contentRoot));
        if (classFiles == null) {
            classFiles = new Vector(WebBundleArchivist.getClassFilesToAdd(servletClasspath));
        }
        FileContentsDescriptor classFilesFcd = null;
        classFilesFcd = servletClasspath == null ? new FileContentsDescriptor() : new FileContentsDescriptor(servletClasspath, classFiles);
        FileContentsDescriptor staticFilesFcd = new FileContentsDescriptor(contentRoot, contentFiles);
        WebBundleArchivist.createPackage(classFilesFcd, staticFilesFcd, new File(descriptorFilename), new File(destinationFile));
    }

    protected File getArchiveFile() throws IOException {
        File archiveFile = this.getWebJarFile();
        Application application = this.webBundleDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist appArchivist = application.getApplicationArchivist();
            File applicationFile = appArchivist.getApplicationFile();
            archiveFile = Archivist.getWebTemp(Archivist.getDirectory(applicationFile));
            appArchivist.extractBundleToFile(this.webBundleDescriptor, archiveFile);
            archiveFile.deleteOnExit();
        }
        return archiveFile;
    }

    private static Set getClassFilesToAdd(String root) throws IOException {
        Set classFiles = new HashSet();
        if (root != null) {
            classFiles = FileUtil.getAllFilesUnder(new File(root), null);
        }
        return classFiles;
    }

    public Vector getClassNames() throws IOException {
        Vector classEntryNames = super.getClassEntryNames();
        Vector<String> allClassNames = new Vector<String>();
        int entryIndex = 0;
        while (entryIndex < classEntryNames.size()) {
            String nextEntryName = (String)classEntryNames.elementAt(entryIndex);
            if (nextEntryName.startsWith(SERVLET_ENTRY_ROOT)) {
                int classStartIndex = SERVLET_ENTRY_ROOT.length() + 1;
                String realClassEntryName = nextEntryName.substring(classStartIndex);
                String className = FileUtil.classNameFromEntryName(realClassEntryName);
                allClassNames.add(className);
            }
            ++entryIndex;
        }
        return allClassNames;
    }

    private static Set getContentFilesToAdd(Vector suppliedList, String documentRoot) throws IOException {
        Set allFiles = new HashSet();
        if (suppliedList != null) {
            allFiles.addAll(suppliedList);
        } else {
            File rootFile = new File(documentRoot);
            if (rootFile.exists()) {
                allFiles = FileUtil.getAllFilesUnder(new File(documentRoot), null);
            } else {
                System.out.println("Warning: " + documentRoot + " does not exist. No static content files will be packaged.");
            }
        }
        return allFiles;
    }

    public Descriptor getDescriptor() {
        return this.webBundleDescriptor;
    }

    public Vector getJspFileNames() throws IOException {
        Vector allEntryNames = super.getEntryNames();
        Vector<String> allJspFileNames = new Vector<String>();
        int entryIndex = 0;
        while (entryIndex < allEntryNames.size()) {
            String nextEntryName = (String)allEntryNames.elementAt(entryIndex);
            if (nextEntryName.endsWith(".jsp")) {
                allJspFileNames.add(nextEntryName);
            }
            ++entryIndex;
        }
        return allJspFileNames;
    }

    public File getWebJarFile() {
        return new File(this.getArchiveUri());
    }

    public boolean isDeletable(String entryName) {
        boolean entryIsDeletable = true;
        if (entryName.equals("META-INF/MANIFEST.MF") || entryName.equals(DEPLOYMENT_DESCRIPTOR_ENTRY)) {
            entryIsDeletable = false;
        }
        return entryIsDeletable;
    }

    public static boolean isWebBundle(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isWebBundle = ze != null;
        jar.close();
        return isWebBundle;
    }

    public static WebBundleDescriptor open(File webFile) throws IOException, ArchiveException {
        if (!webFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionwebfiledoesnotexist", "{0} does not exist", new Object[]{webFile}));
        }
        ZipFile zip = new ZipFile(webFile);
        WebBundleDescriptor descriptor = WebBundleArchivist.open(webFile, DEPLOYMENT_DESCRIPTOR_ENTRY, zip);
        zip.close();
        return descriptor;
    }

    static WebBundleDescriptor open(File webFile, String descriptorEntryName, ZipFile zipContainingDescriptor) throws IOException, ArchiveException {
        if (!webFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionwebfiledoesnotexist", "{0} does not exist", new Object[]{webFile}));
        }
        ZipEntry deploymentEntry = zipContainingDescriptor.getEntry(descriptorEntryName);
        if (deploymentEntry != null) {
            InputStream is = zipContainingDescriptor.getInputStream(deploymentEntry);
            WebApplicationReader reader = new WebApplicationReader();
            WebBundleDescriptor webBundleDescriptor = null;
            try {
                webBundleDescriptor = (WebBundleDescriptor)reader.getDescriptor(is, new WebDescriptorFactoryImpl(), false);
                is.close();
            }
            catch (Throwable t2) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionparsingdescriptor", "Error parsing descriptor: {0}", new Object[]{t2.getMessage()}));
            }
            WebBundleArchivist archivist = new WebBundleArchivist(webFile.toString(), webBundleDescriptor);
            webBundleDescriptor.setArchivist(archivist);
            return webBundleDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeploymentinfo", "No deployment info found at: {0} in {1}", new Object[]{descriptorEntryName, zipContainingDescriptor.getName()}));
    }

    public void removeEntries(Vector entriesToRemove) throws IOException {
        super.removeEntries(entriesToRemove);
        this.webBundleDescriptor.changed();
    }

    public void save(File destinationFile) throws IOException {
        this.save(destinationFile, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File destinationFile, String descriptorEntryName, ZipOutputStream descriptorOut) throws IOException {
        File tmpFile = Archivist.getWebTemp(Archivist.getDirectory(destinationFile));
        ZipOutputStream fileOut = new ZipOutputStream(new FileOutputStream(tmpFile));
        if (descriptorOut == null) {
            this.writeDeploymentInfo(fileOut, descriptorEntryName);
        } else {
            this.writeDeploymentInfo(descriptorOut, descriptorEntryName);
        }
        Manifest manifest = new Manifest();
        Archivist.writeManifest(manifest, fileOut);
        Vector<String> entryNamesToSkip = new Vector<String>();
        if (descriptorOut == null) {
            entryNamesToSkip.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        }
        entryNamesToSkip.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(fileOut, entryNamesToSkip);
        fileOut.close();
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment..exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, destinationFile.toString());
    }

    public String toString() {
        return "WebBundleArchivist " + this.getArchiveUri();
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        super.updateFiles(newFiles);
        this.webBundleDescriptor.changed();
    }

    public void writeDeploymentInfo(ZipOutputStream zos) throws IOException {
        this.writeDeploymentInfo(zos, DEPLOYMENT_DESCRIPTOR_ENTRY);
    }

    public void writeDeploymentInfo(ZipOutputStream zos, String entryName) throws IOException {
        Archivist.writeDocumentToJar(WebBundleNode.getDocument(this.webBundleDescriptor), entryName, zos);
    }

    private static void writeEntry(String entryName, FileInputStream fis, ZipOutputStream zipOut, File actualFile) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(System.currentTimeMillis());
        fis = new FileInputStream(actualFile);
        zipOut.putNextEntry(entry);
        Archivist.copy(fis, zipOut);
        fis.close();
        zipOut.closeEntry();
    }
}

