/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.util.DescriptorGenerator;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Node;

public class EjbNode
extends ElementNode {
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$EjbNode;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public EjbDescriptor getDescriptor() throws ContentTransformationException {
        try {
            EjbDescriptor ejbDescriptor = null;
            if (this.getTagName().equals("entity")) {
                ejbDescriptor = new EjbEntityDescriptor();
            } else {
                ejbDescriptor = new EjbSessionDescriptor();
                String sessionTypeString = XMLUtils.getTextFor(this, "session-type");
                ((EjbSessionDescriptor)ejbDescriptor).setSessionTypeString(sessionTypeString);
            }
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbDescriptor, DescriptorNodeUtils.EJB_STYLE);
            ejbDescriptor.setName(XMLUtils.getTextFor(this, "ejb-name"));
            if (XMLUtils.hasImmediateElementChildFor(this, "description")) {
                ejbDescriptor.setDescription(XMLUtils.getTextFor(this, "description"));
            }
            ejbDescriptor.setHomeClassName(XMLUtils.getTextFor(this, "home"));
            ejbDescriptor.setRemoteClassName(XMLUtils.getTextFor(this, "remote"));
            ejbDescriptor.setEjbClassName(XMLUtils.getTextFor(this, "ejb-class"));
            DescriptorNodeUtils.setEnvironmentProperties(this, ejbDescriptor);
            if (ejbDescriptor instanceof EjbEntityDescriptor) {
                EjbEntityDescriptor entity = (EjbEntityDescriptor)ejbDescriptor;
                entity.setPersistenceType(XMLUtils.getTextFor(this, "persistence-type"));
                if (XMLUtils.hasNodesUnder(this, "prim-key-class")) {
                    entity.setPrimaryKeyClassName(XMLUtils.getTextFor(this, "prim-key-class"));
                }
                entity.setReentrant(XMLUtils.getTextFor(this, "reentrant"));
                HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
                Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "cmp-field");
                while (e10.hasMoreElements()) {
                    ElementNode nextFieldNode = (ElementNode)e10.nextElement();
                    String optionalDescription = "";
                    if (XMLUtils.hasNodesUnder(nextFieldNode, "description")) {
                        optionalDescription = XMLUtils.getTextFor(nextFieldNode, "description");
                    }
                    FieldDescriptor field = new FieldDescriptor(XMLUtils.getTextFor(nextFieldNode, "field-name"), optionalDescription);
                    persistentFields.add(field);
                }
                entity.setPersistentFields(persistentFields);
                if (XMLUtils.hasNodesUnder(this, "primkey-field")) {
                    entity.setPrimaryKeyField(new FieldDescriptor(XMLUtils.getTextFor(this, "primkey-field"), ""));
                }
            } else {
                EjbSessionDescriptor session = (EjbSessionDescriptor)ejbDescriptor;
                session.setTransactionType(XMLUtils.getTextFor(this, "transaction-type"));
            }
            Enumeration e11 = XMLUtils.getNodesUnder((Node)this, "security-role-ref");
            while (e11.hasMoreElements()) {
                ElementNode roleReferenceNode = (ElementNode)e11.nextElement();
                String roleReferenceName = XMLUtils.getTextFor(roleReferenceNode, "role-name");
                String description = "";
                if (XMLUtils.hasNodesUnder(roleReferenceNode, "description")) {
                    description = XMLUtils.getTextFor(roleReferenceNode, "description");
                }
                RoleReference rr = new RoleReference(roleReferenceName, description);
                if (XMLUtils.hasNodesUnder(roleReferenceNode, "role-link")) {
                    rr.setValue(XMLUtils.getTextFor(roleReferenceNode, "role-link"));
                }
                ejbDescriptor.addRoleReference(rr);
            }
            DescriptorNodeUtils.setResourceReferences(this, ejbDescriptor);
            return ejbDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    public static String[] getTags() {
        String[] tags = new String[]{"session", "entity"};
        return tags;
    }

    public static void main(String[] args) {
        try {
            EjbNode.write();
            EjbNode.read();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private static void read() throws Throwable {
        Vector ejbNodes = EjbNode.readEjbNodes(new FileInputStream(new File("ejb.xml")));
        EjbNode n2 = (EjbNode)ejbNodes.elementAt(0);
        System.out.println(n2.getDescriptor());
    }

    public static Vector readEjbNodes(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$EjbNode != null ? class$com$sun$enterprise$deployment$xml$EjbNode : (class$com$sun$enterprise$deployment$xml$EjbNode = EjbNode.class$("com.sun.enterprise.deployment.xml.EjbNode")), nodeToClass, is);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return new Vector();
        }
    }

    public void setDescriptor(EjbDescriptor ejbDescriptor) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(super.getOwnerDocument());
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            this.setTag("entity");
        } else {
            this.setTag("session");
        }
        DescriptorNodeUtils.appendDescriptorAttributes(factory, ejbDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        this.appendChild(factory.getTextNode("ejb-name", ejbDescriptor.getName()));
        this.appendChild(factory.getTextNode("home", ejbDescriptor.getHomeClassName()));
        this.appendChild(factory.getTextNode("remote", ejbDescriptor.getRemoteClassName()));
        this.appendChild(factory.getTextNode("ejb-class", ejbDescriptor.getEjbClassName()));
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            ElementNode sessionTypeNode = factory.getTextNode("session-type", ((EjbSessionDescriptor)ejbDescriptor).getSessionTypeString());
            this.appendChild(sessionTypeNode);
        }
        if (ejbDescriptor instanceof EjbEntityDescriptor) {
            EjbEntityDescriptor entity = (EjbEntityDescriptor)ejbDescriptor;
            this.appendChild(factory.getTextNode("persistence-type", entity.getPersistenceType()));
            if (!entity.getPrimaryKeyClassName().equals("")) {
                this.appendChild(factory.getTextNode("prim-key-class", entity.getPrimaryKeyClassName()));
            }
            this.appendChild(factory.getTextNode("reentrant", entity.isReentrantAsString()));
            Iterator itr = entity.getPersistentFields().iterator();
            while (itr.hasNext()) {
                FieldDescriptor nextField = (FieldDescriptor)itr.next();
                ElementNode fieldNode = factory.getNode("cmp-field");
                this.appendChild(fieldNode);
                if (!nextField.getDescription().equals("")) {
                    fieldNode.appendChild(factory.getTextNode("description", nextField.getDescription()));
                }
                fieldNode.appendChild(factory.getTextNode("field-name", nextField.getName()));
            }
            if (entity.getPrimaryKeyField() != null) {
                this.appendChild(factory.getTextNode("primkey-field", entity.getPrimaryKeyField().getName()));
            }
        } else {
            EjbSessionDescriptor session = (EjbSessionDescriptor)ejbDescriptor;
            this.appendChild(factory.getTextNode("transaction-type", session.getTransactionType()));
        }
        DescriptorNodeUtils.appendEnvironmentProperties(factory, ejbDescriptor, this);
        DescriptorNodeUtils.appendEjbReferences(factory, ejbDescriptor, this);
        Iterator itr = ejbDescriptor.getRoleReferences().iterator();
        while (itr.hasNext()) {
            RoleReference nextRoleReference = (RoleReference)itr.next();
            ElementNode roleReferenceNode = factory.getNode("security-role-ref");
            this.appendChild(roleReferenceNode);
            if (!"".equals(nextRoleReference.getDescription())) {
                roleReferenceNode.appendChild(factory.getTextNode("description", nextRoleReference.getDescription()));
            }
            roleReferenceNode.appendChild(factory.getTextNode("role-name", nextRoleReference.getName()));
            if ("".equals(nextRoleReference.getValue())) continue;
            roleReferenceNode.appendChild(factory.getTextNode("role-link", nextRoleReference.getValue()));
        }
        DescriptorNodeUtils.appendResourceReferences(factory, ejbDescriptor, this);
    }

    private static void write() throws Throwable {
        FileWriter fw = new FileWriter("ejb.xml");
        StringWriter sw = new StringWriter();
        XmlDocument document = new XmlDocument();
        EjbSessionDescriptor descriptor = DescriptorGenerator.getDefaultEjbSessionDescriptor();
        EjbNode n2 = new EjbNode();
        document.appendChild(n2);
        n2.setDescriptor(descriptor);
        XMLUtils.writeDocument(document, fw);
        XMLUtils.writeDocument(document, sw);
        System.out.println("*******************************");
        System.out.println(sw.toString());
        System.out.println("*******************************");
        fw.close();
    }
}

