/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.SimpleElementFactory;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtils {
    private Document document;
    private static String EJB_DTD = "ejb-jar_1_1.dtd";
    private static String WEB_DTD = "web-app_2_2.dtd";
    private static String APP_DTD = "application_1_2.dtd";
    private static String APP_CLIENT_DTD = "application-client_1_2.dtd";
    public static boolean validatingParse = false;
    private static File tempDtd = null;

    private XMLUtils() {
    }

    public XMLUtils(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document was null");
        }
        this.document = document;
    }

    public static String getAbsoluteFilenameURLForDTD(String dtdFilename) throws Exception {
        if (tempDtd == null) {
            tempDtd = File.createTempFile("j2ee.dtd", "j2ee.dtd");
        }
        tempDtd.deleteOnExit();
        return tempDtd.toURL().toString();
    }

    public static String[] getArray(ElementNode root, String tag, String arrayElementTag) {
        Vector<String> v2 = new Vector<String>();
        Properties p2 = new Properties();
        TreeWalker tw = new TreeWalker(root);
        Element startPropertiesNode = tw.getNextElement(tag);
        tw = new TreeWalker(startPropertiesNode);
        ElementNode nextNode = null;
        while ((nextNode = (ElementNode)tw.getNextElement(arrayElementTag)) != null) {
            String nextElement = nextNode.getAttribute("value");
            v2.addElement(nextElement);
        }
        String[] array = new String[v2.size()];
        int i2 = 0;
        while (i2 < v2.size()) {
            array[i2] = (String)v2.elementAt(i2);
            ++i2;
        }
        return array;
    }

    public ElementNode getArrayNode(String tag, String arrayMemberTag, Object[] o2) {
        ElementNode root = this.getNode(tag);
        int i2 = 0;
        while (i2 < o2.length) {
            ElementNode elementInArray = this.getNode(arrayMemberTag, "value", o2[i2].toString());
            root.appendChild(elementInArray);
            ++i2;
        }
        return root;
    }

    public static ElementNode getFirstNodeUnder(Node root, String tag) {
        TreeWalker tw = new TreeWalker(root);
        Element node = tw.getNextElement(tag);
        if (node != null) {
            return (ElementNode)node;
        }
        return null;
    }

    public ElementNode getNode(String tag) {
        ElementNode n2 = (ElementNode)this.document.createElement(tag);
        return n2;
    }

    public ElementNode getNode(String tag, String valueName, String value) {
        ElementNode n2 = this.getNode(tag);
        if (value != null) {
            n2.setAttribute(valueName, value);
        }
        return n2;
    }

    public ElementNode getNode(String tag, String valueName1, String value1, String valueName2, String value2) {
        ElementNode n2 = this.getNode(tag);
        n2.setAttribute(valueName1, value1);
        n2.setAttribute(valueName2, value2);
        return n2;
    }

    public static Vector getNodesByType(Class type, Dictionary nodeToClassMap, InputStream is) throws Throwable {
        Vector<XmlDocument> nodes = new Vector<XmlDocument>();
        SimpleElementFactory elementFactory = new SimpleElementFactory();
        elementFactory.addMapping(nodeToClassMap, null);
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        builder.setElementFactory(elementFactory);
        Parser parser = null;
        parser = validatingParse ? new ValidatingParser() : new Parser();
        Resolver resolver = new Resolver();
        resolver.registerCatalogEntry(EjbBundleNode.PUBLIC_DTD_ID, XMLUtils.getAbsoluteFilenameURLForDTD(EJB_DTD));
        resolver.registerCatalogEntry(ApplicationNode.PUBLIC_DTD_ID, XMLUtils.getAbsoluteFilenameURLForDTD(APP_DTD));
        resolver.registerCatalogEntry(ApplicationClientNode.PUBLIC_DTD_ID, XMLUtils.getAbsoluteFilenameURLForDTD(APP_CLIENT_DTD));
        parser.setEntityResolver(resolver);
        parser.setDocumentHandler(builder);
        builder.setParser(parser);
        try {
            parser.parse(new InputSource(is));
        }
        catch (UnknownHostException uhe) {
            throw new ParseException("Neither this XML document's public nor system id's could be resolved: " + uhe + " " + uhe.getMessage() + "\n on parsing the doucment corresponding to " + type);
        }
        XmlDocument document = builder.getDocument();
        TreeWalker tw = new TreeWalker(document);
        Node next = document;
        while (next != null) {
            if (type.isInstance(next)) {
                nodes.addElement((XmlDocument)next);
            }
            next = tw.getNext();
        }
        return nodes;
    }

    public static Enumeration getNodesUnder(Node root, String tag) {
        return XMLUtils.getVectorOfNodesUnder(root, tag).elements();
    }

    public static Enumeration getNodesUnder(Node root, String[] tags) {
        Vector nodes = new Vector();
        int i2 = 0;
        while (i2 < tags.length) {
            nodes.addAll(XMLUtils.getVectorOfNodesUnder(root, tags[i2]));
            ++i2;
        }
        return nodes.elements();
    }

    public static Properties getProperties(ElementNode root, String tag, String propertyNameTag) {
        Properties p2 = new Properties();
        TreeWalker tw = new TreeWalker(root);
        Element startPropertiesNode = tw.getNextElement(tag);
        tw = new TreeWalker(startPropertiesNode);
        Element nextNode = null;
        while ((nextNode = tw.getNextElement(propertyNameTag)) != null) {
            ElementNode propertyNode = (ElementNode)nextNode;
            String nextKey = propertyNode.getAttribute("name");
            String nextValue = propertyNode.getAttribute("value");
            ((Hashtable)p2).put(nextKey, nextValue);
        }
        return p2;
    }

    public ElementNode getPropertiesNode(String tag, String propertyTagName, Properties p2) {
        ElementNode root = this.getNode(tag);
        Enumeration<?> e10 = p2.propertyNames();
        while (e10.hasMoreElements()) {
            String nextKey = (String)e10.nextElement();
            String nextValue = (String)((Hashtable)p2).get(nextKey);
            ElementNode nextPropertyNode = this.getNode(propertyTagName);
            nextPropertyNode.setAttribute("name", nextKey);
            nextPropertyNode.setAttribute("value", nextValue);
            root.appendChild(nextPropertyNode);
        }
        return root;
    }

    public static String getTextFor(ElementNode root, String tag) {
        return XMLUtils.getTextFor_Lib(root, tag);
    }

    private static String getTextFor_Lib(ElementNode root, String tag) {
        if (root.getTagName().equals(tag) && root.getFirstChild() instanceof Text) {
            return ((Text)root.getFirstChild()).getNodeValue();
        }
        TreeWalker tw = new TreeWalker(root);
        ElementNode n2 = (ElementNode)tw.getNextElement(tag);
        if (n2 == null) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(root)) + " has no sub nodes with tag " + tag);
        }
        Text tn = (Text)n2.getFirstChild();
        if (tn == null) {
            return "";
        }
        return tn.getNodeValue();
    }

    public ElementNode getTextNode(String tag, String text) {
        ElementNode en2 = this.getNode(tag);
        en2.appendChild(this.document.createTextNode(text));
        return en2;
    }

    public static String getValueOf(Node root, String tag, String key) {
        Node theNode = null;
        if (root instanceof Element && ((Element)root).getTagName().equals(tag)) {
            theNode = root;
        } else {
            TreeWalker tw = new TreeWalker(root);
            theNode = tw.getNextElement(tag);
        }
        if (theNode == null) {
            throw new RuntimeException("can't find a node under " + root + " with tag " + tag);
        }
        Attr n2 = (Attr)theNode.getAttributes().getNamedItem(key);
        return n2.getNodeValue();
    }

    public static Vector getVectorOfNodesUnder(Node root, String tag) {
        Vector<Element> nodes = new Vector<Element>();
        Element next = null;
        TreeWalker tw = new TreeWalker(root);
        while ((next = tw.getNextElement(tag)) != null) {
            nodes.addElement(next);
        }
        return nodes;
    }

    public static boolean hasImmediateElementChildFor(ElementNode node, String tag) {
        NodeList nl = node.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            ElementNode nextElementNode;
            Node next = nl.item(i2);
            if (next instanceof ElementNode && (nextElementNode = (ElementNode)next).getTagName().equals(tag)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static boolean hasNodesUnder(Node root, String tag) {
        return XMLUtils.getFirstNodeUnder(root, tag) != null;
    }

    public static void writeDocument(XmlDocument documentToWrite, Writer out) throws IOException {
        OutputStreamWriter out1 = new OutputStreamWriter(System.out);
        String encoding = out1.getEncoding();
        documentToWrite.write(out, encoding);
    }

    public static void writeDocumentToFile(XmlDocument document, File file) throws IOException {
        if (file.getParent() != null) {
            boolean bl2 = new File(file.getParent()).mkdirs();
        }
        FileWriter out = new FileWriter(file);
        XMLUtils.writeDocument(document, out);
        out.close();
    }
}

