/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.log;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.log.LogNotFoundException;
import com.sun.enterprise.log.LogReader;
import com.sun.enterprise.log.RemoteFileReader;
import com.sun.enterprise.log.RemoteFileReaderImpl;
import com.sun.enterprise.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Vector;

public class LogReaderImpl
implements LogReader {
    public static final String REMOTE_LOG_READER = "RemoteLogReader";
    private static final String LOG_DIRECTORY = "log.directory";
    private static final String INSTALL_DIRECTORY = "com.sun.enterprise.home";
    private static final String ERROR_MSG = "Log file not found";
    private String pathNameToStartFrom;
    private boolean listRead = false;
    private Vector logFile;
    private String[] logFileList;
    private RemoteFileReader[] rafs;
    static /* synthetic */ Class class$com$sun$enterprise$log$LogReader;

    LogReaderImpl() {
        this.getProperties();
        this.logFile = new Vector();
        this.logFileList = null;
        this.rafs = null;
    }

    private void addToLogList(String name) {
        this.logFile.add(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String clearLog(String name) throws RemoteException, LogNotFoundException {
        return name;
    }

    private void createAndFillBuffer() {
        this.logFileList = null;
        this.logFileList = new String[this.logFile.size()];
        int i2 = 0;
        while (i2 < this.logFile.size()) {
            this.logFileList[i2] = new String((String)this.logFile.elementAt(i2));
            ++i2;
        }
        this.logFile.clear();
    }

    private void createRemotableObjects() throws RemoteException {
        this.rafs = new RemoteFileReader[this.logFileList.length];
        int i2 = 0;
        while (i2 < this.logFileList.length) {
            this.rafs[i2] = new RemoteFileReaderImpl(this.logFileList[i2]);
            ++i2;
        }
    }

    public static void exportRemoteInterface() {
        try {
            LogReaderImpl logreader = new LogReaderImpl();
            Utility.bindObject(REMOTE_LOG_READER, logreader);
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
    }

    public String getLog(String name) throws RemoteException, LogNotFoundException {
        try {
            int ch2;
            File log = new File(name);
            StringWriter sWriter = new StringWriter();
            if (!log.isFile()) {
                throw new LogNotFoundException(ERROR_MSG);
            }
            BufferedReader in = new BufferedReader(new FileReader(log));
            while ((ch2 = in.read()) != -1) {
                sWriter.write(ch2);
            }
            String retStr = sWriter.toString();
            in.close();
            sWriter.close();
            return retStr;
        }
        catch (NullPointerException ex2) {
            ex2.printStackTrace(System.out);
            throw new LogNotFoundException(((Throwable)ex2).getMessage());
        }
        catch (IOException ex3) {
            ex3.printStackTrace(System.out);
            throw new RemoteException(ex3.getMessage());
        }
    }

    public RemoteFileReader[] getLogFiles() throws RemoteException {
        if (!this.listRead) {
            this.getLogList();
        }
        this.createRemotableObjects();
        return this.rafs;
    }

    public String[] getLogList() throws RemoteException {
        try {
            File top = new File(this.pathNameToStartFrom);
            this.scanDirectory(top);
            this.createAndFillBuffer();
            this.listRead = true;
            return this.logFileList;
        }
        catch (NullPointerException ex2) {
            ex2.printStackTrace(System.out);
            throw new RemoteException(((Throwable)ex2).getMessage());
        }
    }

    private void getProperties() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String logDirectory = config.getProperty(LOG_DIRECTORY);
        String installDirectory = System.getProperty(INSTALL_DIRECTORY);
        this.pathNameToStartFrom = String.valueOf(installDirectory) + File.separator + logDirectory + File.separator;
    }

    public static void main(String[] args) {
        LogReader logReader = null;
        try {
            logReader = (LogReader)Utility.lookupObject(REMOTE_LOG_READER, class$com$sun$enterprise$log$LogReader != null ? class$com$sun$enterprise$log$LogReader : (class$com$sun$enterprise$log$LogReader = LogReaderImpl.class$("com.sun.enterprise.log.LogReader")));
        }
        catch (Exception e10) {
            e10.printStackTrace();
            System.exit(1);
        }
    }

    private void scanDirectory(File currentDir) {
        File[] list = currentDir.listFiles();
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2].isDirectory()) {
                this.scanDirectory(list[i2]);
            } else {
                this.addToLogList(list[i2].toString());
            }
            ++i2;
        }
    }
}

