/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourceSpec;
import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.Transaction;

public class NonSharedResourcePool
implements ResourcePool {
    private static final boolean debug = false;
    private Hashtable resourceStates = new Hashtable();
    private Set free = new HashSet();
    private long idletime;
    private String name;
    private Hashtable transTable = new Hashtable();

    public NonSharedResourcePool(long idletimeInSeconds, String poolName) {
        this.idletime = idletimeInSeconds * 1000L;
        this.name = poolName;
    }

    public synchronized void addResource(ResourceSpec spec, Principal user, ResourceHandle h2) {
        ResourceState state = new ResourceState();
        this.resourceStates.put(h2, state);
        state.setEnlisted(false);
        state.setBusy(true);
    }

    public synchronized ResourceHandle getResource(ResourceSpec spec, Principal user, Transaction tran) {
        Set set;
        ResourceHandle result = null;
        if (tran != null && (set = (Set)this.transTable.get(tran)) != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ResourceHandle h2 = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(h2);
                if (!h2.getUser().equals(user) || !state.isFree()) continue;
                result = h2;
                break;
            }
        }
        if (result == null) {
            Iterator iter = this.free.iterator();
            while (iter.hasNext()) {
                ResourceHandle h3 = (ResourceHandle)iter.next();
                ResourceState state = this.getResourceState(h3);
                if (!h3.getUser().equals(user)) continue;
                if (!state.isEnlisted()) {
                    result = h3;
                    break;
                }
                if (result != null) continue;
                result = h3;
            }
        }
        if (result != null) {
            ResourceState state = this.getResourceState(result);
            state.setBusy(true);
            this.free.remove(result);
        }
        return result;
    }

    private ResourceState getResourceState(ResourceHandle h2) {
        return (ResourceState)this.resourceStates.get(h2);
    }

    public synchronized void resizePool() {
        int count = 0;
        Iterator iter = this.free.iterator();
        while (iter.hasNext()) {
            ResourceHandle h2 = (ResourceHandle)iter.next();
            ResourceState state = this.getResourceState(h2);
            if (System.currentTimeMillis() - state.getTimestamp() <= this.idletime || !state.isUnenlisted()) continue;
            try {
                h2.getResourceAllocator().destroyResource(h2);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
            }
            this.resourceStates.remove(h2);
            iter.remove();
            ++count;
        }
    }

    public synchronized void resourceClosed(ResourceHandle h2) throws IllegalStateException {
        ResourceState state = this.getResourceState(h2);
        if (state == null || !state.isBusy()) {
            throw new IllegalStateException();
        }
        state.setBusy(false);
        state.touchTimestamp();
        this.free.add(h2);
    }

    public synchronized void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        HashSet<ResourceHandle> set = (HashSet<ResourceHandle>)this.transTable.get(tran);
        if (set == null) {
            set = new HashSet<ResourceHandle>();
            this.transTable.put(tran, set);
        }
        set.add(resource);
        ResourceState state = this.getResourceState(resource);
        state.setEnlisted(true);
    }

    public synchronized void resourceErrorOccurred(ResourceHandle h2) throws IllegalStateException {
        ResourceState state = this.getResourceState(h2);
        if (state == null || !state.isBusy()) {
            throw new IllegalStateException();
        }
        try {
            h2.getResourceAllocator().destroyResource(h2);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
        this.resourceStates.remove(h2);
    }

    public synchronized void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        HashSet set = (HashSet)this.transTable.get(tran);
        if (set == null) {
            return;
        }
        this.transTable.remove(tran);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceHandle resource = (ResourceHandle)iter.next();
            ResourceState state = this.getResourceState(resource);
            state.setEnlisted(false);
        }
    }

    public static class ResourceState {
        private boolean enlisted;
        private boolean busy;
        private long timestamp;

        public ResourceState() {
            this.touchTimestamp();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isBusy() {
            return this.busy;
        }

        public boolean isEnlisted() {
            return this.enlisted;
        }

        public boolean isFree() {
            return this.busy ^ true;
        }

        public boolean isUnenlisted() {
            return this.enlisted ^ true;
        }

        public void setBusy(boolean busy) {
            this.busy = busy;
        }

        public void setEnlisted(boolean enlisted) {
            this.enlisted = enlisted;
        }

        public void touchTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }
    }
}

