/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.DataSourceParser;
import com.sun.enterprise.resource.JdbcDataSource;
import com.sun.enterprise.resource.NonSharedResourcePool;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolManagerImpl
implements PoolManager {
    private static final boolean debug = false;
    private static final long DEFAULT_SLEEPTIME = 10L;
    private static final String JDBC10_PROP = "jdbc.datasources";
    private static final String JDBC20_PROP = "jdbc20.datasources";
    private static Hashtable jdbc1DSTable = new Hashtable();
    private static Hashtable jdbc2DSTable = new Hashtable();
    private long nextID;
    private Hashtable poolTable = new Hashtable();
    private HashSet pendingTxns = new HashSet();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$PoolManagerImpl != null ? class$com$sun$enterprise$resource$PoolManagerImpl : (class$com$sun$enterprise$resource$PoolManagerImpl = PoolManagerImpl.class$("com.sun.enterprise.resource.PoolManagerImpl")));
    private long sleeptime = 0L;
    static /* synthetic */ Class class$com$sun$enterprise$resource$PoolManagerImpl;

    public PoolManagerImpl() {
        ServerConfiguration sconfig = ServerConfiguration.getConfiguration();
        String val = sconfig.getProperty("idle.resource.threshold", String.valueOf(10L));
        String ex2 = localStrings.getLocalString("idle_resource_threshold_error", "The value of idle.resource.threshold in default.properties file should be a positive integer:");
        try {
            this.sleeptime = Long.parseLong(val);
            if (this.sleeptime < 0L) {
                throw new RuntimeException(ex2);
            }
        }
        catch (NumberFormatException nfe) {
            Log.err.println(ex2);
            Log.err.flush();
            throw new RuntimeException(ex2);
        }
        ResizeThread thread = new ResizeThread(this.sleeptime);
        thread.start();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PoolManagerImpl.registerJDBCDrivers();
                return null;
            }
        });
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    private static void bindDatasources() throws Exception {
        Object ds2;
        String jndiname;
        NamingManager nm = Switch.getSwitch().getNamingManager();
        InitialContext ctx = new InitialContext();
        Enumeration names = jdbc1DSTable.keys();
        while (names.hasMoreElements()) {
            jndiname = (String)names.nextElement();
            ds2 = jdbc1DSTable.get(jndiname);
            nm.publishObject(jndiname, ds2, true);
        }
        names = jdbc2DSTable.keys();
        while (names.hasMoreElements()) {
            jndiname = (String)names.nextElement();
            ds2 = jdbc2DSTable.get(jndiname);
            nm.publishObject(jndiname, ds2, true);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized ResourceHandle createResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, Principal prin) {
        ++this.nextID;
        return new ResourceHandle(this.nextID, resource, spec, alloc, prin);
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, String user, String password) throws ResourceException {
        ResourceHandle handle = this.getResourceFromPool(spec, alloc, user, password);
        this.registerResource(handle);
        return handle.getUserConnection();
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, String user, String password) throws ResourceException {
        ResourcePool pool = null;
        Hashtable hashtable = this.poolTable;
        synchronized (hashtable) {
            pool = (ResourcePool)this.poolTable.get(spec);
            if (pool == null) {
                pool = new NonSharedResourcePool(this.sleeptime, spec.toString());
                this.poolTable.put(spec, pool);
            }
        }
        ResourcePrincipal prin = new ResourcePrincipal(user, password);
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        ComponentInvocation inv = invmgr.getCurrentInvocation();
        Transaction tran = inv.getTransaction();
        ResourceHandle resource = pool.getResource(spec, prin, tran);
        if (resource == null) {
            resource = alloc.createResource(spec, prin);
            pool.addResource(spec, prin, resource);
        }
        alloc.fillInResourceObjects(resource);
        return resource;
    }

    public static String getURLForDSName(String name) {
        JdbcDataSource ds2 = (JdbcDataSource)jdbc1DSTable.get(name);
        if (ds2 == null) {
            return null;
        }
        return ds2.getDataSourceName();
    }

    public static void installJdbcDataSources() {
        PoolManagerImpl.parseJdbcDataSources(1);
        PoolManagerImpl.parseJdbcDataSources(2);
        try {
            PoolManagerImpl.bindDatasources();
            PoolManagerImpl.installJdbcXADataSources();
        }
        catch (Exception ne) {
            Log.err.println(localStrings.getLocalString("poolmgr.nameerror", "Naming error"));
        }
    }

    private static void installJdbcXADataSources() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        Properties props = config.getProperties("xadatasource");
        try {
            NamingManager nm = Switch.getSwitch().getNamingManager();
            DataSourceParser dsp = new DataSourceParser();
            Vector list = dsp.parseProperties(props);
            Enumeration e10 = list.elements();
            while (e10.hasMoreElements()) {
                DataSourceParser.DataSourceInfo dsi = (DataSourceParser.DataSourceInfo)e10.nextElement();
                String jndiName = dsi.jndiName;
                Object ds2 = dsi.dataSource;
                System.err.println(localStrings.getLocalString("binding.datasource2", "", new Object[]{jndiName, ds2}));
                nm.publishObject(jndiName, ds2, true);
            }
        }
        catch (NamingException ne) {
            Log.err.println(localStrings.getLocalString("poolmgr.nameerror", "Naming error"));
        }
        catch (Exception ex2) {
            Log.err.println(localStrings.getLocalString("poolmgr.datasourceerror", "Error in creating data source object"));
        }
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    private static void parseJdbcDataSources(int jdbcVersion) {
        Hashtable dsTable;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String datasources = null;
        if (jdbcVersion == 1) {
            datasources = config.getProperty(JDBC10_PROP);
            dsTable = jdbc1DSTable;
        } else {
            datasources = config.getProperty(JDBC20_PROP);
            dsTable = jdbc2DSTable;
        }
        if (datasources == null) {
            datasources = "";
        }
        try {
            while (!datasources.equals("")) {
                String jndiname = null;
                String url = null;
                int index = datasources.indexOf(124);
                if (index == -1) {
                    jndiname = datasources;
                    datasources = "";
                } else {
                    jndiname = datasources.substring(0, index);
                    datasources = datasources.substring(index + 1, datasources.length());
                }
                index = datasources.indexOf(124);
                if (index == -1) {
                    url = datasources;
                    datasources = "";
                } else {
                    url = datasources.substring(0, index);
                    datasources = datasources.substring(index + 1, datasources.length());
                }
                JdbcDataSource ds2 = new JdbcDataSource();
                ds2.setDataSourceName(url);
                ds2.setJndiName(jndiname);
                ds2.setJdbcMajorVersion(jdbcVersion);
                dsTable.put(jndiname, ds2);
                System.err.println(localStrings.getLocalString("binding.datasource", "", new Object[]{jndiname, url}));
            }
        }
        catch (Exception ne) {
            Log.err.println(localStrings.getLocalString("poolmgr.nameerror", "Naming error"));
            ne.printStackTrace(Log.err);
        }
    }

    public void putbackResourceToPool(ResourceHandle h2, boolean errorOccurred) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(h2.getResourceSpec());
        if (pool != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h2);
            } else {
                pool.resourceClosed(h2);
            }
        }
    }

    public void recoverJdbcXAResources() throws ResourceException {
        XAConnection con;
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        Properties props = config.getProperties("xadatasource");
        Vector<XAConnection> result = new Vector<XAConnection>();
        boolean error = false;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        DataSourceParser dsp = new DataSourceParser();
        Vector list = dsp.parseProperties(props);
        Enumeration e10 = list.elements();
        String jndiName = null;
        while (e10.hasMoreElements()) {
            try {
                DataSourceParser.DataSourceInfo dsi = (DataSourceParser.DataSourceInfo)e10.nextElement();
                jndiName = dsi.jndiName;
                String dbUser = dsi.dbUser;
                String dbPassword = dsi.dbPassword;
                Object obj = ctx.lookup(jndiName);
                if (!(obj instanceof XADataSource)) continue;
                XADataSource ds2 = (XADataSource)obj;
                con = null;
                con = dbUser == null ? ds2.getXAConnection() : ds2.getXAConnection(dbUser, dbPassword);
                result.addElement(con);
            }
            catch (Exception ex2) {
                String errString = localStrings.getLocalString("datasource.xadatasource.err", "", new Object[]{jndiName, ex2.toString()});
                System.err.println(errString);
                Log.err.println(errString);
                throw new ResourceException(ex2);
            }
        }
        try {
            int size = result.size();
            XAResource[] xaresList = new XAResource[size];
            int i2 = 0;
            while (i2 < size) {
                XAConnection con2 = (XAConnection)result.elementAt(i2);
                xaresList[i2] = con2.getXAResource();
                ++i2;
            }
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            tm.recover(xaresList);
            int i3 = 0;
            while (i3 < size) {
                System.err.println(localStrings.getLocalString("xaresource.recovered", "", new Object[]{xaresList[i3]}));
                con = (XAConnection)result.elementAt(i3);
                con.close();
                ++i3;
            }
        }
        catch (Exception ex3) {
            String msg = localStrings.getLocalString("xaresource.recover.error", "");
            throw new ResourceException(ex3);
        }
    }

    public static void registerJDBCDrivers() {
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String prop = config.getProperty("jdbc.drivers");
        if (prop == null) {
            prop = "";
        }
        while (!prop.equals("")) {
            String classname = null;
            int index = prop.indexOf(58);
            if (index == -1) {
                classname = prop;
                prop = "";
            } else {
                classname = prop.substring(0, index);
                prop = prop.substring(index + 1, prop.length());
            }
            try {
                Class.forName(classname).newInstance();
            }
            catch (Exception exception) {
                try {
                    Class<?> c10 = ClassLoader.getSystemClassLoader().loadClass(classname);
                    try {
                        Object d10 = c10.newInstance();
                    }
                    catch (Exception exception2) {}
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.err.println(localStrings.getLocalString("poolmgr.loaderror", "Cannot load class " + classname, new Object[]{classname}));
                }
            }
        }
    }

    private void registerResource(ResourceHandle handle) throws ResourceException {
        try {
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invmgr.getCurrentInvocation();
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                tm.enlistResource(tran, handle);
            }
            tm.registerComponentResource(handle);
        }
        catch (Exception ex2) {
            throw new ResourceException(ex2);
        }
    }

    public void resourceClosed(ResourceHandle resource) {
        this.unregisterResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle res) throws IllegalStateException {
        HashSet hashSet = this.pendingTxns;
        synchronized (hashSet) {
            if (!this.pendingTxns.contains(tran)) {
                this.pendingTxns.add(tran);
                SynchronizationListener sync = new SynchronizationListener(tran);
                try {
                    tran.registerSynchronization(sync);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        ResourceSpec spec = res.getResourceSpec();
        ResourcePool pool = (ResourcePool)this.poolTable.get(spec);
        if (pool != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        try {
            ComponentInvocation inv = invmgr.getCurrentInvocation();
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                tran.setRollbackOnly();
            }
        }
        catch (SystemException ex2) {
        }
        catch (IllegalStateException illegalStateException) {}
        this.unregisterResource(resource, 0x20000000);
        this.putbackResourceToPool(resource, true);
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        HashSet hashSet = this.pendingTxns;
        synchronized (hashSet) {
            this.pendingTxns.remove(tran);
        }
        Hashtable cloneTable = (Hashtable)this.poolTable.clone();
        Enumeration e10 = cloneTable.elements();
        while (e10.hasMoreElements()) {
            ResourcePool pool = (ResourcePool)e10.nextElement();
            pool.transactionCompleted(tran, status);
        }
    }

    private void unregisterResource(ResourceHandle resource, int xaresFlag) {
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        InvocationManager invmgr = Switch.getSwitch().getInvocationManager();
        try {
            ComponentInvocation inv = invmgr.getCurrentInvocation();
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                tm.delistResource(tran, resource, xaresFlag);
            }
        }
        catch (SystemException ex2) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvocationException invocationException) {}
        tm.unregisterComponentResource(resource);
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void beforeCompletion() {
        }
    }

    class ResizeThread
    extends Thread {
        private long threadSleeptime;

        ResizeThread(long sleeptimeInSeconds) {
            this.threadSleeptime = sleeptimeInSeconds;
        }

        public void run() {
            block4: while (true) {
                try {
                    Thread.sleep(this.threadSleeptime * 1000L);
                }
                catch (InterruptedException interruptedException) {}
                Hashtable cloneTable = (Hashtable)PoolManagerImpl.this.poolTable.clone();
                Enumeration e10 = cloneTable.elements();
                while (true) {
                    if (!e10.hasMoreElements()) continue block4;
                    try {
                        ((ResourcePool)e10.nextElement()).resizePool();
                    }
                    catch (Exception ex2) {
                        Log.err.println(ex2);
                    }
                }
                break;
            }
        }
    }
}

