/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.AuthenticationServer;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.application.EJBSecurityContext;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.Authenticator;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class LoginContext {
    private static final int MAX_COUNT = 5;
    private Authenticator authenticator = null;
    private Credentials credentials = null;
    private String realmName = "default";
    private String authMethod = "password";
    private String userName = null;
    private SecurityContext securityContext = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$LoginContext != null ? class$com$sun$enterprise$security$LoginContext : (class$com$sun$enterprise$security$LoginContext = LoginContext.class$("com.sun.enterprise.security.LoginContext")));
    static /* synthetic */ Class class$com$sun$enterprise$security$LoginContext;
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$Authenticator;

    public LoginContext() throws LoginException {
        try {
            if (ORBManager.getORB() == null) {
                new InitialContext();
            }
            this.init();
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void continueLogin(String moreInfo) throws LoginException {
        this.continueLogin(moreInfo.getBytes());
    }

    public void continueLogin(byte[] authData) throws LoginException {
        AuthenticationStatus astatus = null;
        try {
            astatus = this.authenticator.continueAuthentication(authData, this.credentials);
            if (astatus == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            throw new LoginException(e10.getMessage());
        }
        this.setSecurityContext();
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    private void init() throws RemoteException, NamingException {
        int cnt = 0;
        System.out.println(localStrings.getLocalString("enterprise.security.looking_up_authenticator", "Looking up authenticator..."));
        while (cnt < 5) {
            try {
                this.authenticator = this.lookupAuthenticator();
                break;
            }
            catch (NameNotFoundException nameNotFoundException) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                ++cnt;
            }
        }
        if (cnt == 5) {
            throw new NamingException("Cannot look up authenticator");
        }
        this.credentials = this.authenticator.initAuthentication();
    }

    public void login(String username, String password) throws LoginException {
        this.login(username, password.getBytes());
    }

    public void login(String username, byte[] authData) throws LoginException {
        AuthenticationStatus astatus = null;
        this.userName = username;
        try {
            if (this.authenticator == null && this.credentials == null) {
                this.init();
            }
            if ((astatus = this.authenticator.authenticate(this.userName, this.realmName, this.authMethod, authData, this.credentials)) == null || astatus.getStatus() != 0) {
                throw new LoginException(astatus);
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e10) {
            e10.printStackTrace();
            throw new LoginException(e10.getMessage());
        }
        this.setSecurityContext();
    }

    public void logout() throws LoginException {
        try {
            try {
                if (this.authenticator != null && this.credentials != null) {
                    this.authenticator.destroyCredentials(this.credentials);
                }
            }
            catch (RemoteException re) {
                throw new LoginException(re.getMessage());
            }
            Object var2_2 = null;
            this.authenticator = null;
            this.credentials = null;
            this.unsetSecurityContext();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.authenticator = null;
            this.credentials = null;
            this.unsetSecurityContext();
            throw throwable;
        }
    }

    private Authenticator lookupAuthenticator() throws NamingException {
        return (Authenticator)Utility.lookupObject(AuthenticationServer.AUTH_SERVICE_NAME, class$com$sun$enterprise$security$auth$Authenticator != null ? class$com$sun$enterprise$security$auth$Authenticator : (class$com$sun$enterprise$security$auth$Authenticator = LoginContext.class$("com.sun.enterprise.security.auth.Authenticator")));
    }

    public void setAuthenticationMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private void setSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new EJBSecurityContext(this.userName, this.credentials);
            SecurityContext.setCurrent(this.securityContext);
        }
    }

    private void unsetSecurityContext() {
        this.securityContext = null;
        SecurityContext.setCurrent(null);
    }
}

