/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ExecutionContext;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.auth.Credentials;
import java.io.Serializable;
import java.security.Principal;
import java.util.Hashtable;

public abstract class SecurityContext
implements Serializable {
    private static final String SECURITY_CONTEXT_ID = "SecurityContext";
    private static SecurityContext defaultSecurityContext = null;
    static /* synthetic */ Class class$com$sun$enterprise$security$SecurityContext;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static void generateDefaultSecurityContext() {
        String PRINCIPAL_NAME = "auth.default.principal.name";
        String PRINCIPAL_PASS = "auth.default.principal.password";
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String username = config.getProperty("auth.default.principal.name", "guest");
        String password = config.getProperty("auth.default.principal.password", "guest123");
        Class clazz = class$com$sun$enterprise$security$SecurityContext != null ? class$com$sun$enterprise$security$SecurityContext : (class$com$sun$enterprise$security$SecurityContext = SecurityContext.class$("com.sun.enterprise.security.SecurityContext"));
        synchronized (clazz) {
            try {
                LoginContext lc = new LoginContext();
                lc.login(username, password);
                defaultSecurityContext = SecurityContext.getCurrent();
                SecurityContext.setCurrent(null);
            }
            catch (Exception exception) {}
        }
    }

    public abstract Principal getCallerPrincipal();

    public abstract Credentials getCredentials();

    public static SecurityContext getCurrent() {
        Hashtable current = ExecutionContext.getContext();
        SecurityContext sc = (SecurityContext)current.get(SECURITY_CONTEXT_ID);
        return sc;
    }

    public static SecurityContext init() {
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc == null) {
            if (defaultSecurityContext == null) {
                SecurityContext.generateDefaultSecurityContext();
            }
            SecurityContext.setCurrent(defaultSecurityContext);
        }
        return sc;
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static void setCurrent(SecurityContext sc) {
        Hashtable current = ExecutionContext.getContext();
        if (sc != null) {
            current.put(SECURITY_CONTEXT_ID, sc);
        } else {
            current.remove(SECURITY_CONTEXT_ID);
        }
    }
}

