/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.GuardedResource;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.ResourceGuard;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResourceAccessManager {
    private static ResourceAccessManager ram = null;
    private static boolean debug = false;
    private Hashtable resTable = new Hashtable();
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$ResourceAccessManager;

    private ResourceAccessManager() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static ResourceAccessManager getDefault() {
        if (ram == null) {
            Class clazz = class$com$sun$enterprise$security$acl$ResourceAccessManager != null ? class$com$sun$enterprise$security$acl$ResourceAccessManager : (class$com$sun$enterprise$security$acl$ResourceAccessManager = ResourceAccessManager.class$("com.sun.enterprise.security.acl.ResourceAccessManager"));
            synchronized (clazz) {
                ram = new ResourceAccessManager();
            }
        }
        return ram;
    }

    public GuardedResource getGuardedResource(Resource res) {
        ResourceGuard g2 = this.getResourceGuard(res);
        if (g2 != null) {
            return new GuardedResource(res, g2);
        }
        return null;
    }

    private ResourceGuard getResourceGuard(Resource res) {
        ResourceGuard g2 = (ResourceGuard)this.resTable.get(res);
        if (g2 == null) {
            Enumeration e10 = this.resTable.keys();
            while (e10.hasMoreElements()) {
                Resource item = (Resource)e10.nextElement();
                if (!item.implies(res)) continue;
                g2 = (ResourceGuard)this.resTable.get(item);
                break;
            }
        }
        return g2;
    }

    public boolean isProtected(Resource res) {
        boolean ret = this.resTable.containsKey(res);
        if (!ret) {
            ResourceGuard g2 = this.getResourceGuard(res);
            return g2 != null;
        }
        return true;
    }

    public void protect(Resource res, ResourceGuard guard) {
        if (!this.isProtected(res)) {
            this.resTable.put(res, guard);
            if (debug) {
                System.out.println("ResourceAccessManage: Resource: " + res + " is protected by " + guard);
            }
        }
    }

    public void unprotect(Resource res) {
        if (this.isProtected(res)) {
            this.resTable.remove(res);
        }
    }
}

