/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.util.TypeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

final class FilePrivileges {
    private File file;
    private Hashtable attribTable = null;

    FilePrivileges(String fileName) throws BadRealmException {
        try {
            this.file = new File(fileName);
            this.read();
        }
        catch (Exception e10) {
            throw new BadRealmException(e10.getMessage());
        }
    }

    String[] get(String attribName) {
        String val = (String)this.attribTable.get(attribName);
        if (val != null) {
            return TypeUtil.stringToArray(val, ",");
        }
        return new String[0];
    }

    void read() throws IOException {
        Properties props = new Properties();
        FileInputStream fin = new FileInputStream(this.file);
        props.load(fin);
        this.attribTable = props;
        fin.close();
    }

    void remove(String attribName, String attribValue) {
        String[] values = this.get(attribName);
        if (values.length == 0) {
            return;
        }
        String val = null;
        int i2 = 0;
        while (i2 < values.length) {
            if (val == null) {
                if (!values[i2].equals(attribValue)) {
                    val = values[i2];
                }
            } else if (!values[i2].equals(attribValue)) {
                val = String.valueOf(values[i2]) + "," + val;
            }
            ++i2;
        }
        if (val == null) {
            val = "";
        }
        this.attribTable.put(attribName, val);
        try {
            this.write();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void set(String attribName, String attribValue) {
        String curr = (String)this.attribTable.get(attribName);
        if (curr == null) {
            this.attribTable.put(attribName, attribValue);
        } else {
            this.attribTable.put(attribName, String.valueOf(curr) + "," + attribValue);
        }
        try {
            this.write();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void write() throws IOException {
        Properties props = (Properties)this.attribTable;
        FileOutputStream fout = new FileOutputStream(this.file);
        props.store(fout, "");
        fout.close();
    }
}

