/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.PrivilegeImpl;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePassword;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePrivileges;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class SharedPasswordUser
extends PrincipalImpl
implements User {
    private static final String GROUP_KEY = "Groups";
    private FilePassword file;
    private FilePrivileges privileges;
    private SharedPasswordRealm realm;
    private Hashtable attributes;

    SharedPasswordUser(SharedPasswordRealm r2, String username) throws NoSuchUserException {
        super(username);
        this.init(r2);
        this.file.getPasswd(username);
        this.attributes.put(GROUP_KEY, this.file.getGroups(this.getName()));
    }

    SharedPasswordUser(SharedPasswordRealm r2, String username, String password, String[] groups) throws BadRealmException {
        super(username);
        this.init(r2);
        this.file.addUser(username, password, groups);
        this.attributes.put(GROUP_KEY, groups);
    }

    public boolean authenticate(String passphrase) throws NoSuchUserException {
        return passphrase.equals(this.file.getPasswd(this.getName()));
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Privilege[] getGroups() {
        Vector<PrivilegeImpl> v2 = new Vector<PrivilegeImpl>();
        String[] usrGroups = (String[])this.getAttribute(GROUP_KEY);
        String[] allGroups = this.privileges.get(GROUP_KEY);
        int i2 = 0;
        while (i2 < usrGroups.length) {
            int j2 = 0;
            while (j2 < allGroups.length) {
                if (usrGroups[i2].equals(allGroups[j2])) {
                    v2.add(new PrivilegeImpl(usrGroups[i2]));
                }
                ++j2;
            }
            ++i2;
        }
        Object[] retArray = new Privilege[v2.size()];
        v2.copyInto(retArray);
        return retArray;
    }

    public Realm getRealm() {
        return this.realm;
    }

    private void init(SharedPasswordRealm r2) {
        this.realm = r2;
        this.file = r2.getPasswords();
        this.privileges = r2.getPrivileges();
        this.attributes = new Hashtable();
    }
}

