/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.tools.deployment.backend.BufferedRemoteByteArray;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.Log;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindowController;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;

public class DeployTool {
    private ApplicationManager applicationManager;
    private ServerManager serverManager;
    private ComponentPackager componentPackager;
    private File workingDirectory;
    private File toolHomeDirectory;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$main$DeployTool != null ? class$com$sun$enterprise$tools$deployment$main$DeployTool : (class$com$sun$enterprise$tools$deployment$main$DeployTool = DeployTool.class$("com.sun.enterprise.tools.deployment.main.DeployTool")));
    public static final String HOME_DIR = ".j2eedeploymenttool";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$main$DeployTool;

    public DeployTool(boolean hasUI) {
        File toolHomeDir = this.getToolHomeDirectory();
        if (hasUI) {
            UIUtils.showSplashPanel();
            if (!toolHomeDir.exists()) {
                toolHomeDir.mkdirs();
            }
        }
        this.applicationManager = new ApplicationManager(toolHomeDir, this.getWorkingDirectory());
        this.serverManager = new ServerManager(toolHomeDir);
        if (hasUI) {
            DeployToolWindowController controller = new DeployToolWindowController(this);
            DeployToolWindow deployToolWindow = new DeployToolWindow(controller);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deploy(Application application, String serverName, DeploymentSession deploymentSession, File clientCodeFile) throws Exception {
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.deployapplicationfileonserversaveasclientjar", "Deploy the application in {0} on the server {1} saving the client jar as {2}", new Object[]{application.getApplicationArchivist().getApplicationFile(), serverName, clientCodeFile}));
        Object[] msg = new Object[]{application.getName(), serverName};
        String clientCode = null;
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.deploytool.deploy_command", "Deploy {0} on {1}", msg));
        JarInstaller backend = this.getServerManager().getServerForName(serverName);
        DeploymentSession deploymentSessionToUse = null;
        deploymentSessionToUse = deploymentSession == null ? this.getServerManager().createDeploymentSession(serverName) : deploymentSession;
        File file = application.getApplicationArchivist().getApplicationFile();
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(fis);
        byte[] jarData = new byte[(int)file.length()];
        dis.readFully(jarData);
        dis.close();
        fis.close();
        BufferedRemoteByteArray bufferedJarData = this.getServerManager().createBufferedByteArray(serverName, jarData);
        clientCode = backend.deployApplication(bufferedJarData, application.getName(), deploymentSessionToUse);
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.clientcodeat", "client code at {0}", new Object[]{clientCode}));
        if (clientCode != null && clientCodeFile != null) {
            this.writeClientJarToFile(clientCode, clientCodeFile);
            deploymentSessionToUse.notification(new NotificationEvent(this, "Client Code Saved", this));
            deploymentSessionToUse.setStatusMessage(localStrings.getLocalString("enterprise.tools.deployment.main.clientcodefordeployedapplicationsavedtofile", "Client code for the deployed application {0} saved to {1}", new Object[]{application.getName(), clientCodeFile}));
        }
    }

    public void doGenerateSQL(String applicationFilename, String serverName, boolean overWrite) throws Exception {
        DBInfo dbInfo = this.getServerManager().getDBInfo(serverName);
        Application application = ApplicationArchivist.open(new File(applicationFilename));
        Enumeration e10 = application.getEjbDescriptors().elements();
        while (e10.hasMoreElements()) {
            Object next = e10.nextElement();
            if (!(next instanceof EjbEntityDescriptor) || !((EjbEntityDescriptor)next).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) continue;
            EjbEntityDescriptor entity = (EjbEntityDescriptor)next;
            String msg = SQLGenerator.generateSQL(entity, entity.getResourceReference(), overWrite, dbInfo);
            System.out.println(msg);
            System.out.println(next);
        }
        application.getApplicationArchivist().save(application.getApplicationArchivist().getApplicationFile(), true);
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.donegeneratingSQL", "Done generating SQL"));
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public ComponentPackager getComponentPackager() {
        if (this.componentPackager == null) {
            this.componentPackager = new ComponentPackager();
        }
        return this.componentPackager;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    private File getToolHomeDirectory() {
        String home = System.getProperty("user.home");
        if (home == null) {
            home = "";
        }
        return new File(home, HOME_DIR);
    }

    public File getWorkingDirectory() {
        String home;
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null) {
            temp = "/tmp";
        }
        if ((home = System.getProperty("user.home")) == null) {
            home = "";
        }
        File tmp = new File(home, "tmp");
        tmp.mkdirs();
        return tmp;
    }

    private void saveAsBytes(byte[] data, File file) throws IOException {
        if (data == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.main.nulldataforclientcodefile", "null data for client code file"));
        }
        FileOutputStream fileStream = new FileOutputStream(file);
        fileStream.write(data, 0, data.length);
        fileStream.close();
    }

    public void setRuntimeDeploymentInfo(Application application, File runtimeDeploymentInfo) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        RuntimeDescriptorNode node = (RuntimeDescriptorNode)RuntimeDescriptorNode.readRuntimeDescriptorNodes(fis).elementAt(0);
        node.updateRuntimeInformation(application);
        this.getApplicationManager().saveApplication(application);
        Object[] msg = new Object[]{application.getName()};
        Log.print(this, localStrings.getLocalString("enterprise.tools.deployment.main.deploytool.setruntime_command", "Done setting runtime deployment information on {0} to: {1}", msg));
    }

    public String toString() {
        return "Deploy Tool";
    }

    private void writeClientJarToFile(String clientCode, File clientCodeFile) throws IOException {
        URL u2 = new URL(clientCode);
        HttpURLConnection http = (HttpURLConnection)u2.openConnection();
        int code = http.getResponseCode();
        if (code != 200) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.cannotdownloadURL", "Cannot download URL {0}", new Object[]{clientCode}));
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.main.status", "Status: {0}", new Object[]{new Integer(code)}));
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.main.cannotdownloadURL", "Cannot download URL {0}", new Object[]{clientCode}));
        }
        BufferedInputStream is = new BufferedInputStream(http.getInputStream());
        FileOutputStream fos = new FileOutputStream(clientCodeFile);
        int len = 0;
        int contentLength = http.getContentLength();
        byte[] buf = new byte[contentLength + 1];
        while ((len = is.read(buf)) != -1) {
            fos.write(buf, 0, len);
        }
    }
}

