/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.FileTreeNodeRenderer;
import com.sun.enterprise.tools.deployment.ui.OKCancelDialog;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ContentChooser
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ContentChooser != null ? class$com$sun$enterprise$tools$deployment$ui$ContentChooser : (class$com$sun$enterprise$tools$deployment$ui$ContentChooser = ContentChooser.class$("com.sun.enterprise.tools.deployment.ui.ContentChooser")));
    private JTextField directoryTextField;
    private JTree directoryContentsTree;
    private JList contentsList;
    private JFileChooser fileChooser;
    private FilenameFilter filenameFilter;
    private FileContentsDescriptor fileDirectoryMap = new FileContentsDescriptor();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ContentChooser;

    public ContentChooser(String topText, String listLabel, String directoryLabel, File defaultDirectory, FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
        this.initializeLayout(topText, listLabel, directoryLabel, defaultDirectory);
        this.refreshTree();
    }

    public void addAction() {
        File directory = new File(this.directoryTextField.getText());
        TreePath[] tp = this.directoryContentsTree.getSelectionPaths();
        if (tp != null) {
            Vector files = new Vector();
            int i2 = 0;
            while (i2 < tp.length) {
                files.addAll(this.getSelectedFilesFrom(tp[i2], directory));
                ++i2;
            }
            Enumeration e10 = files.elements();
            while (e10.hasMoreElements()) {
                File f2 = (File)e10.nextElement();
                this.fileDirectoryMap.add(f2, directory);
            }
            this.refreshList();
        }
    }

    public void browseAction() {
        if (this.fileChooser == null) {
            this.fileChooser = UIUtils.getDirectoryChooser(this.directoryTextField.getText());
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setFileSelectionMode(1);
        int returnValue = this.fileChooser.showDialog(this, localStrings.getLocalString("contentchooser.choose_directory", "Choose Directory"));
        if (returnValue == 0) {
            File newFile = this.fileChooser.getSelectedFile();
            this.directoryTextField.setText(newFile.getAbsolutePath());
            this.changeDirectoryAction();
        }
    }

    public void changeDirectoryAction() {
        File directory = new File(this.directoryTextField.getText());
        if (directory.exists() && directory.isDirectory()) {
            this.refreshTree();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static OKCancelDialog createDialog(ContentChooser cc2, Frame parent, String title, String helpSetMapID) {
        OKCancelDialog contentChooserDialog = new OKCancelDialog(cc2, parent, title, helpSetMapID);
        ((Component)contentChooserDialog).setBounds(10, 10, 400, 500);
        contentChooserDialog.setLocationRelativeTo(parent);
        return contentChooserDialog;
    }

    public FileContentsDescriptor getContentsMap() {
        return this.fileDirectoryMap;
    }

    private Vector getSelectedFilesFrom(TreePath tp, File rootDirectory) {
        Vector<File> v2 = new Vector<File>();
        Object o2 = tp.getLastPathComponent();
        if (o2 instanceof DefaultMutableTreeNode) {
            File f2 = (File)((DefaultMutableTreeNode)o2).getUserObject();
            if (f2.isDirectory()) {
                try {
                    Iterator itr = FileUtil.getAllFilesUnder(f2, this.filenameFilter).iterator();
                    while (itr.hasNext()) {
                        File next = (File)itr.next();
                        File absolute = new File(f2, next.toString());
                        File relativeFile = FileUtil.relativize(rootDirectory, absolute);
                        v2.add(relativeFile);
                    }
                }
                catch (Throwable ioe) {
                    JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("contentchooser.error_obtaining_all", "There was an error obtaining all the files. \nThere may be too many !\n")) + ioe);
                    return v2;
                }
            } else {
                File relativeFile = FileUtil.relativize(rootDirectory, f2);
                v2.add(relativeFile);
            }
        }
        return v2;
    }

    private TreeModel getTreeModelFor(File directory) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(directory);
        DefaultTreeModel tm = new DefaultTreeModel(root, true);
        this.updateDirectoryChildren(root, directory);
        return tm;
    }

    private void initializeLayout(String topText, String listLabel, String directoryLabel, File defaultDirectory) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        JTextArea label = new JTextArea(topText);
        label.setEditable(false);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBackground(UIManager.getColor("Panel.background"));
        UIUtils.makeFontPlain(label);
        label.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.add("North", label);
        this.directoryTextField = new JTextField(defaultDirectory.getAbsolutePath());
        JButton browseButton = new JButton(localStrings.getLocalString("contentchooser.browse_button", "Browse..."));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ContentChooser.this.browseAction();
            }
        });
        JPanel directoryPanel = new JPanel();
        directoryPanel.setLayout(new BorderLayout());
        directoryPanel.setBorder(new TitledBorder(directoryLabel));
        directoryPanel.add("Center", this.directoryTextField);
        directoryPanel.add("East", browseButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        UIUtils.limitVertically(directoryPanel);
        mainPanel.add(directoryPanel);
        this.directoryContentsTree = new JTree();
        this.directoryContentsTree.setRootVisible(false);
        this.directoryContentsTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ContentChooser.this.updateForPathExpansion(event.getPath());
            }
        });
        this.directoryContentsTree.setCellRenderer(new FileTreeNodeRenderer());
        JPanel listP = new JPanel();
        listP.setLayout(new BorderLayout());
        listP.add(new JScrollPane(this.directoryContentsTree));
        mainPanel.add(listP);
        JPanel contentsPanel = new JPanel();
        contentsPanel.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        JButton addButton = new JButton(localStrings.getLocalString("contentchooser.add_button", "Add"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ContentChooser.this.addAction();
            }
        });
        JButton removeButton = new JButton(localStrings.getLocalString("contentchooser.remove_button", "Remove"));
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ContentChooser.this.removeAction();
            }
        });
        this.directoryTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                ContentChooser.this.changeDirectoryAction();
            }
        });
        this.directoryTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (UIUtils.isEnterKey(ke)) {
                    ContentChooser.this.changeDirectoryAction();
                }
            }
        });
        buttonsPanel.add(addButton);
        buttonsPanel.add(removeButton);
        DefaultListModel dlm = new DefaultListModel();
        this.contentsList = new JList();
        this.contentsList.setModel(dlm);
        contentsPanel.add("Center", new JScrollPane(this.contentsList));
        contentsPanel.add("North", buttonsPanel);
        contentsPanel.setBorder(new TitledBorder(listLabel));
        mainPanel.add(contentsPanel);
        this.add("Center", mainPanel);
    }

    public void refreshList() {
        TreeSet sortedSet = new TreeSet();
        Enumeration e10 = this.fileDirectoryMap.getFiles();
        while (e10.hasMoreElements()) {
            sortedSet.add(e10.nextElement());
        }
        DefaultListModel dlm = new DefaultListModel();
        Iterator itr = sortedSet.iterator();
        while (itr.hasNext()) {
            dlm.addElement(itr.next());
        }
        this.contentsList.setModel(dlm);
    }

    public void refreshTree() {
        TreeModel tm = this.getTreeModelFor(new File(this.directoryTextField.getText()));
        this.directoryContentsTree.setModel(tm);
    }

    public void removeAction() {
        Object[] toRemove = this.contentsList.getSelectedValues();
        int i2 = 0;
        while (i2 < toRemove.length) {
            this.fileDirectoryMap.removeFile((File)toRemove[i2]);
            ++i2;
        }
        this.refreshList();
    }

    public void setContentsMap(FileContentsDescriptor fileDirectoryMap) {
        this.fileDirectoryMap = fileDirectoryMap;
        this.refreshList();
    }

    private void updateDirectoryChildren(DefaultMutableTreeNode dmtn, File directory) {
        File[] subDirectories = directory.listFiles(this.filenameFilter);
        TreeSet<File> sortedFiles = new TreeSet<File>();
        int i2 = 0;
        while (i2 < subDirectories.length) {
            sortedFiles.add(subDirectories[i2]);
            ++i2;
        }
        Iterator itr = sortedFiles.iterator();
        while (itr.hasNext()) {
            File next = (File)itr.next();
            DefaultMutableTreeNode node = null;
            if (next.isDirectory()) {
                node = new DefaultMutableTreeNode(next, true);
                node = new DefaultMutableTreeNode(next, true);
            } else {
                node = new DefaultMutableTreeNode(next, false);
            }
            dmtn.add(node);
        }
        ((DefaultTreeModel)this.directoryContentsTree.getModel()).reload(dmtn);
    }

    void updateForPathExpansion(TreePath tp) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        File f2 = (File)node.getUserObject();
        if (f2.isDirectory()) {
            this.updateDirectoryChildren(node, f2);
        }
    }
}

