/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.ApplicationView;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends JComboBox {
    static final int OFFSET = 16;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo(TreeModel aTreeModel) {
        this.setModel(new TreeToListModel(aTreeModel));
        this.setRenderer(new ListEntryRenderer());
    }

    public Object getSelectedDescriptor() {
        ListEntry le = (ListEntry)this.getSelectedItem();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)le.object();
        return dmtn.getUserObject();
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(5, 5, 300, 300);
        f2.show();
        DefaultTreeModel dtm = new DefaultTreeModel(new DefaultMutableTreeNode("Danny"));
        TreeCombo tc = new TreeCombo(dtm);
        f2.getContentPane().add(tc);
    }

    public void setModel(TreeModel aTreeModel) {
        this.setModel(new TreeToListModel(aTreeModel));
        this.setRenderer(new ListEntryRenderer());
    }

    public void setSelectedDescriptor(Object object) {
        Enumeration e10 = ((TreeToListModel)this.getModel()).cache.elements();
        while (e10.hasMoreElements()) {
            ListEntry le = (ListEntry)e10.nextElement();
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)le.object();
            if (dmtn.getUserObject() != object) continue;
            this.setSelectedItem(le);
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        void addListEntry(Object anObject, int level, boolean isNode) {
            this.cache.addElement(new ListEntry(anObject, level, isNode));
        }

        void cacheTree(Object anObject, int level) {
            if (this.source.isLeaf(anObject)) {
                this.addListEntry(anObject, level, false);
            } else {
                int c10 = this.source.getChildCount(anObject);
                if (level > 0) {
                    this.addListEntry(anObject, level, true);
                }
                ++level;
                int i2 = 0;
                while (i2 < c10) {
                    Object child = this.source.getChild(anObject, i2);
                    this.cacheTree(child, level);
                    ++i2;
                }
                --level;
            }
        }

        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public void setSelectedItem(Object anObject) {
            this.currentValue = anObject;
            this.fireContentsChanged(this, -1, -1);
        }

        public void treeNodesChanged(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e10) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }
    }

    class ListEntry {
        Object object;
        int level;
        boolean isNode;

        public ListEntry(Object anObject, int aLevel, boolean isNode) {
            this.object = anObject;
            this.level = aLevel;
            this.isNode = isNode;
        }

        public boolean isNode() {
            return this.isNode;
        }

        public int level() {
            return this.level;
        }

        public Object object() {
            return this.object;
        }
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        ImageIcon leafIcon = UIUtils.getImageIconFor(UIUtils.APPLICATION_ICON);
        ImageIcon nodeIcon = UIUtils.getImageIconFor(UIUtils.EJB_BUNDLE_ICON);

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListEntry listEntry = (ListEntry)value;
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)listEntry.object();
            if (listEntry != null) {
                this.setText(listEntry.object().toString());
                this.setIcon(ApplicationView.getIconForDescriptor(dmtn.getUserObject()));
                Border border = index != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (isSelected) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

