/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class EnvironmentInspector
extends JPanel
implements Inspector,
TableInspector {
    EnvironmentEntriesTable environmentEntriesTable;
    JButton addPB;
    JButton delPB;
    JTextArea descriptionText;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector = EnvironmentInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EnvironmentInspector")));
    WritableJndiNameEnvironment descriptor;
    String inspectorMode = "DeveloperMode";
    String[] envValueTypes = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Long", "java.lang.Float"};
    String[] envValueTypesExternal = new String[]{"String", "Boolean", "Integer", "Double", "Byte", "Short", "Long", "Float"};
    private static final String JAVA_LANG = "java.lang.";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EnvironmentInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public EnvironmentInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void addEnvironmentPropertyAction() {
        this.editingStopped();
        this.environmentEntriesTable.getSelectionModel().clearSelection();
        EnvironmentProperty ep2 = new EnvironmentProperty("", "", "");
        this.descriptor.addEnvironmentProperty(ep2);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deSelectAction() {
        this.descriptionText.setText("");
        this.descriptionText.setEnabled(false);
    }

    public void editingStopped() {
        this.environmentEntriesTable.editingStopped(new ChangeEvent(this));
    }

    JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = EnvironmentInspector.class$("javax.swing.JFrame")), this);
    }

    EnvironmentProperty getSelectedEnvironmentProperty() {
        EnvironmentProperty envirProp = null;
        envirProp = this.getTableModel().getRow(this.environmentEntriesTable.getSelectedRow());
        return envirProp;
    }

    int getSelectedEnvironmentPropertyIndex() {
        int minIndex;
        int index = -1;
        ListSelectionModel lsm = this.environmentEntriesTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            index = minIndex;
        }
        return index;
    }

    EnvironmentEntriesTableModel getTableModel() {
        return (EnvironmentEntriesTableModel)this.environmentEntriesTable.getModel();
    }

    private void initializeLayout() {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        this.setLayout(gb1);
        JPanel environmentEntriesPanel = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        environmentEntriesPanel.setLayout(gb2);
        environmentEntriesPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.environmententries", "Environment entries referenced in code")));
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(environmentEntriesPanel, c10);
        this.add(environmentEntriesPanel);
        this.environmentEntriesTable = new EnvironmentEntriesTable(new EnvironmentEntriesTableModel(new HashSet()));
        this.environmentEntriesTable.setAutoResizeMode(4);
        this.environmentEntriesTable.getSelectionModel().addListSelectionListener(new EnvironmentEntriesSelectionListener());
        JScrollPane environmentEntriesTablePane = new JScrollPane(this.environmentEntriesTable);
        environmentEntriesTablePane.setBorder(BorderFactory.createLoweredBevelBorder());
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.75;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(environmentEntriesTablePane, c10);
        environmentEntriesPanel.add(environmentEntriesTablePane);
        JPanel environmentEntriesButtonPanel = new JPanel();
        environmentEntriesButtonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        gb2.setConstraints(environmentEntriesButtonPanel, c10);
        environmentEntriesPanel.add(environmentEntriesButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        environmentEntriesButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EnvironmentInspector.this.addEnvironmentPropertyAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete..."));
        environmentEntriesButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                EnvironmentInspector.this.removeEnvironmentPropertyAction();
            }
        });
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:"));
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 0, 5);
        gb2.setConstraints(descriptionLabel, c10);
        environmentEntriesPanel.add(descriptionLabel);
        this.descriptionText = new JTextArea();
        JScrollPane descriptionTextPane = new JScrollPane(this.descriptionText);
        c10.weightx = 0.5;
        c10.weighty = 0.25;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        gb2.setConstraints(descriptionTextPane, c10);
        environmentEntriesPanel.add(descriptionTextPane);
        this.descriptionText.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent me) {
                EnvironmentInspector.this.storeDescription();
            }
        });
        this.descriptionText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    EnvironmentInspector.this.storeDescription();
                }
            }
        });
        this.deSelectAction();
    }

    boolean isValidValueForJavaType(String value, String javaType) {
        boolean isValidValue;
        block4: {
            isValidValue = false;
            if (value != null) {
                value = value.trim();
            }
            try {
                if (value != null && value.length() > 0) {
                    Class<?> cls = Class.forName(javaType);
                    Class[] paramClasses = new Class[]{Class.forName("java.lang.String")};
                    Constructor<?> strConstructor = cls.getConstructor(paramClasses);
                    Object[] args = new Object[]{value};
                    Object obj = strConstructor.newInstance(args);
                }
                isValidValue = true;
            }
            catch (Exception exception) {
                isValidValue = false;
                JFrame frame = this.getFrame();
                if (frame == null) break block4;
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.illegalvalue", "Illegal value '{0} You must enter a value of type {1}", new Object[]{value, javaType}));
            }
        }
        return isValidValue;
    }

    public static void main(String[] args) {
        final EnvironmentInspector ei2 = new EnvironmentInspector("DeveloperMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbSessionDescriptor descriptor = new EjbSessionDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setObject(descriptor);
            }
        });
        ei2.setObject(descriptor);
    }

    protected void refresh() {
        ((InspectorTableModel)this.environmentEntriesTable.getModel()).updateTableData(this.descriptor.getEnvironmentProperties());
        this.environmentEntriesTable.sizeColumnsToFit(0);
        this.showDescription(this.getSelectedEnvironmentProperty());
    }

    private void removeEnvironmentPropertyAction() {
        this.editingStopped();
        EnvironmentProperty ep2 = this.getSelectedEnvironmentProperty();
        if (ep2 != null) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedenvproperty", "Are you sure you want to delete the selected environment entry?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleteenvproperty", "Delete environment entry"), 0);
            if (n2 == 0) {
                this.descriptor.removeEnvironmentProperty(ep2);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectenvpropertyfromlist", "You must first select an environment property from list"));
        }
    }

    private void selectAction() {
        this.descriptionText.setEnabled(true);
        this.showDescription(this.getSelectedEnvironmentProperty());
    }

    public void setInspectorMode(String mode) {
        this.inspectorMode = mode;
    }

    public void setObject(Object o2) {
        if (o2 instanceof WritableJndiNameEnvironment) {
            WritableJndiNameEnvironment previousDescriptor = this.descriptor;
            this.descriptor = (WritableJndiNameEnvironment)o2;
            if (!this.descriptor.equals(previousDescriptor)) {
                this.editingStopped();
                this.environmentEntriesTable.getSelectionModel().clearSelection();
            }
            this.refresh();
        }
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    private void showDescription(EnvironmentProperty envirProp) {
        if (envirProp != null) {
            this.descriptionText.setText(envirProp.getDescription());
        } else {
            this.descriptionText.setText("");
        }
    }

    private void storeDescription() {
        EnvironmentProperty envirProp = this.getSelectedEnvironmentProperty();
        if (envirProp != null) {
            envirProp.setDescription(this.descriptionText.getText());
        }
    }

    class EnvironmentEntriesSelectionListener
    implements ListSelectionListener {
        EnvironmentEntriesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            boolean isAdjusting = e10.getValueIsAdjusting();
            if (isAdjusting) {
                return;
            }
            if (sm.isSelectionEmpty()) {
                EnvironmentInspector.this.deSelectAction();
            } else {
                EnvironmentInspector.this.selectAction();
            }
        }
    }

    private class EnvironmentEntriesTable
    extends InspectorTable {
        public EnvironmentEntriesTable(EnvironmentEntriesTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tableofenventries", "Table of environment entries"));
            this.setSelectionMode(0);
            this.setupTypeColumn();
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>(EnvironmentInspector.this.envValueTypesExternal);
            typeComboBox.addItemListener(new EnvEntryTypeItemListener());
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText("Click to edit property type");
            typeColumn.setCellRenderer(renderer);
        }
    }

    class EnvEntryTypeItemListener
    implements ItemListener {
        EnvEntryTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
        }
    }

    public class EnvironmentEntriesTableModel
    extends InspectorTableModel {
        public EnvironmentEntriesTableModel(Set environmentProperties) {
            super(new ArrayList(environmentProperties), new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.entry", "Coded Entry"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.type", "Type"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.value", "Value")});
        }

        public EnvironmentProperty getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (EnvironmentProperty)this.data.get(index);
        }

        public Object getValueAt(int row, int col) {
            EnvironmentProperty environProperty = (EnvironmentProperty)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = environProperty.getName();
                    break;
                }
                case 1: {
                    String type = environProperty.getType();
                    if (type.indexOf(EnvironmentInspector.JAVA_LANG) == 0) {
                        type = type.substring(EnvironmentInspector.JAVA_LANG.length());
                    }
                    value = type;
                    break;
                }
                case 2: {
                    value = environProperty.getValue();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            EnvironmentProperty environProperty = this.getRow(row);
            if (environProperty == null) {
                return;
            }
            switch (col) {
                case 0: {
                    environProperty.setName(value.toString());
                    ((Descriptor)((Object)EnvironmentInspector.this.descriptor)).changed();
                    return;
                }
                case 1: {
                    String javaType = (String)value;
                    if (javaType.indexOf(EnvironmentInspector.JAVA_LANG) == -1) {
                        javaType = EnvironmentInspector.JAVA_LANG + javaType;
                    }
                    if (javaType.equals(environProperty.getType())) break;
                    environProperty.setType(javaType);
                    this.setValueAt("", row, 2);
                    break;
                }
                case 2: {
                    String javaType = environProperty.getType();
                    String oldValue = environProperty.getValue();
                    try {
                        environProperty.setValue(value.toString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(null, String.valueOf(value.toString()) + localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.notlegaltypeenventry", " is not a legal value for this environment entry type"));
                    }
                    break;
                }
            }
            ((Descriptor)((Object)EnvironmentInspector.this.descriptor)).changed();
        }
    }
}

