/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class MimeMappingDialog
extends JDialog
implements Inspector {
    WebBundleDescriptor descriptor;
    MimeMappingTableModel mimeMappingTableModel;
    MimeMappingTable mimeMappingTable;
    JButton okPB;
    JButton cancelPB;
    JButton helpPB;
    JButton addPB;
    JButton deletePB;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$MimeMappingDialog != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$MimeMappingDialog : (class$com$sun$enterprise$tools$deployment$ui$descriptor$MimeMappingDialog = MimeMappingDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.MimeMappingDialog")));
    private static String helpSetMapID = "WWMime";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$MimeMappingDialog;

    public MimeMappingDialog(Frame frame, boolean modal) {
        super(frame, "Mime Mappings", modal);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                MimeMappingDialog.this.cancelAction();
            }
        });
        JPanel contentPane = new JPanel();
        contentPane.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.mimemappings", "Mime mappings"));
        contentPane.setPreferredSize(new Dimension(450, 380));
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        this.mimeMappingTableModel = new MimeMappingTableModel();
        this.mimeMappingTable = new MimeMappingTable(this.mimeMappingTableModel);
        JScrollPane mimeMappingTablePane = new JScrollPane(this.mimeMappingTable);
        this.mimeMappingTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        c10.weighty = 0.3;
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 3;
        c10.insets = new Insets(5, 5, 0, 5);
        gridbag.setConstraints(mimeMappingTablePane, c10);
        contentPane.add(mimeMappingTablePane);
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new GridLayout(3, 1, 5, 5));
        this.okPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.okbutton", "OK"));
        dialogButtonPanel.add(this.okPB);
        this.okPB.setMnemonic('O');
        this.okPB.setActionCommand("OK");
        this.okPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                MimeMappingDialog.this.okAction();
            }
        });
        this.cancelPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cancelbutton", "Cancel"));
        dialogButtonPanel.add(this.cancelPB);
        this.cancelPB.setMnemonic('C');
        this.cancelPB.setActionCommand("Cancel");
        this.cancelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                MimeMappingDialog.this.cancelAction();
            }
        });
        this.helpPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.helpbutton", "Help"));
        dialogButtonPanel.add(this.helpPB);
        this.helpPB.setMnemonic('H');
        this.helpPB.setActionCommand("Help");
        DeployToolActions.enableHelpOnButton(this.helpPB, helpSetMapID);
        c10.weighty = 0.0;
        c10.weightx = 0.0;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(10, 20, 3, 5);
        gridbag.setConstraints(dialogButtonPanel, c10);
        contentPane.add(dialogButtonPanel);
        JPanel tableButtonPanel = new JPanel();
        tableButtonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        tableButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                MimeMappingDialog.this.addAction();
            }
        });
        this.deletePB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete"));
        tableButtonPanel.add(this.deletePB);
        this.deletePB.setMnemonic('D');
        this.deletePB.setActionCommand("Delete");
        this.deletePB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                MimeMappingDialog.this.deleteAction();
            }
        });
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        c10.weighty = 0.0;
        c10.weightx = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        gridbag.setConstraints(tableButtonPanel, c10);
        contentPane.add(tableButtonPanel);
        this.setContentPane(contentPane);
    }

    private void addAction() {
        this.editingStopped();
        this.mimeMappingTableModel.addRow("", "");
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteAction() {
        this.editingStopped();
        int selectedRow = this.mimeMappingTable.getSelectedRow();
        if (selectedRow > -1) {
            this.mimeMappingTableModel.deleteRow(selectedRow);
        }
    }

    public void editingStopped() {
        this.mimeMappingTable.editingStopped(new ChangeEvent(this));
    }

    private void okAction() {
        this.editingStopped();
        this.writeTableToModel();
        ((Component)this).setVisible(false);
    }

    public void refresh() {
        this.mimeMappingTableModel = new MimeMappingTableModel();
        Enumeration mimeMappings = this.descriptor.getMimeMappings();
        while (mimeMappings.hasMoreElements()) {
            MimeMappingDescriptor mimeMapping = (MimeMappingDescriptor)mimeMappings.nextElement();
            this.mimeMappingTableModel.addRow(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
        this.mimeMappingTable.setModel(this.mimeMappingTableModel);
        this.mimeMappingTable.sizeColumnsToFit(0);
    }

    public void setObject(Object o2) {
        if (o2 instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor)o2;
            this.refresh();
        }
    }

    private void writeTableToModel() {
        this.descriptor.setMimeMappings(this.mimeMappingTableModel.getMimeMappings());
    }

    private class MimeMappingTable
    extends InspectorTable {
        public MimeMappingTable(MimeMappingTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.tableofcmfield", "Table of container managed field"));
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditnext", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }
    }

    public class MimeMappingTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        String[] columnNames = new String[]{MimeMappingDialog.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.extension", "Extension"), MimeMappingDialog.access$4().getLocalString("enterprise.tools.deployment.ui.descriptor.mimetype", "Mime Type")};

        public void addRow(String extension, String mimeType) {
            FieldInfo field = new FieldInfo();
            field.extension = extension;
            field.mimeType = mimeType;
            this.fields.add(field);
            this.fireTableRowsInserted(this.fields.size() - 1, this.fields.size() - 1);
        }

        public void deleteRow(int index) {
            this.fields.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public Set getMimeMappings() {
            HashSet<MimeMappingDescriptor> mmds = new HashSet<MimeMappingDescriptor>();
            int i2 = 0;
            while (i2 < this.getRowCount()) {
                FieldInfo next = (FieldInfo)this.fields.get(i2);
                MimeMappingDescriptor mmd = new MimeMappingDescriptor(next.extension, next.mimeType);
                mmds.add(mmd);
                ++i2;
            }
            return mmds;
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            fieldInfo.setElement(col, value);
        }

        private class FieldInfo {
            String extension;
            String mimeType;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.extension;
                        break;
                    }
                    case 1: {
                        elem = this.mimeType;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.extension = elem.toString();
                        break;
                    }
                    case 1: {
                        this.mimeType = elem.toString();
                        break;
                    }
                }
            }
        }
    }
}

