/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;

public class WebAppContextParametersInspector
extends JPanel
implements Inspector,
TableInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector = WebAppContextParametersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppContextParametersInspector")));
    WebBundleDescriptor descriptor;
    private InspectorTable contextParametersTable = new InspectorTable();
    private static String helpSetMapID = "WIContext";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector;

    public WebAppContextParametersInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
    }

    public void addAction() {
        this.editingStopped();
        this.contextParametersTable.getSelectionModel().clearSelection();
        this.descriptor.addContextParameter(new EnvironmentProperty("", "", ""));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deleteAction() {
        this.editingStopped();
        int i2 = this.contextParametersTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.askdelete", "Are you sure you want to delete selected parameter?"), "Delete parameter", 0);
            if (n2 == 0) {
                String key = (String)((ContextParametersTableModel)this.contextParametersTable.getModel()).getValueAt(i2, 0);
                Enumeration e10 = this.descriptor.getContextParameters();
                while (e10.hasMoreElements()) {
                    EnvironmentProperty ep2 = (EnvironmentProperty)e10.nextElement();
                    if (!ep2.getName().equals(key)) continue;
                    this.descriptor.removeContextParameter(ep2);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.warnselect", "You must first select a parameter from the list"));
        }
    }

    public void editingStopped() {
        this.contextParametersTable.editingStopped(new ChangeEvent(this));
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        ContextParametersTableModel tableModel = new ContextParametersTableModel();
        this.contextParametersTable.setAutoResizeMode(4);
        this.contextParametersTable.setModel(tableModel);
        this.contextParametersTable.setSelectionMode(0);
        JPanel cpPanel = new JPanel();
        cpPanel.setLayout(new BorderLayout());
        cpPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        cpPanel.add(new JScrollPane(this.contextParametersTable));
        this.add("Center", cpPanel);
        JButton addButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        JButton deleteButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete..."));
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        buttonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        buttonPanel.add(addButton);
        buttonPanel.add(deleteButton);
        JPanel wrapperPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        wrapperPanel.setLayout(gb);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.anchor = 10;
        c10.fill = 2;
        gb.setConstraints(buttonPanel, c10);
        wrapperPanel.add(buttonPanel);
        this.add("East", wrapperPanel);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.addAction();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.deleteAction();
            }
        });
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(0, 0, 300, 300);
        f2.getContentPane().add(new WebAppContextParametersInspector());
        f2.show();
    }

    private void refresh() {
        ((InspectorTableModel)this.contextParametersTable.getModel()).updateTableData(this.descriptor.getContextParametersSet());
        this.contextParametersTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebBundleDescriptor) {
            WebBundleDescriptor previousDescriptor = this.descriptor;
            this.descriptor = (WebBundleDescriptor)object;
            if (!this.descriptor.equals(previousDescriptor)) {
                this.editingStopped();
                this.contextParametersTable.getSelectionModel().clearSelection();
            }
            this.refresh();
        }
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    class ContextParametersTableModel
    extends InspectorTableModel {
        public ContextParametersTableModel() {
            super(new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contextparam", "Context Parameter"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.value", "Value")});
        }

        public EnvironmentProperty get(int i2) {
            return (EnvironmentProperty)this.data.get(i2);
        }

        List getContextParameters() {
            return this.data;
        }

        public EnvironmentProperty getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (EnvironmentProperty)this.data.get(index);
        }

        public Object getValueAt(int row, int col) {
            EnvironmentProperty contextParam = (EnvironmentProperty)this.data.get(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = contextParam.getName();
                    break;
                }
                case 1: {
                    value = contextParam.getValue();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            EnvironmentProperty contextParam = this.getRow(row);
            if (contextParam == null) {
                return;
            }
            switch (col) {
                case 0: {
                    contextParam.setName(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                    break;
                }
                case 1: {
                    contextParam.setValue(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                    break;
                }
            }
        }
    }
}

