/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;

public class WebComponentAliasesInspector
extends JPanel
implements Inspector,
TableInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector = WebComponentAliasesInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentAliasesInspector")));
    WebComponentDescriptorImpl descriptor;
    private InspectorTable urlMappingTable = new InspectorTable();
    private static String helpSetMapID = "CIAlias";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentAliasesInspector;

    public WebComponentAliasesInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
    }

    public void addAction() {
        this.editingStopped();
        this.urlMappingTable.getSelectionModel().clearSelection();
        this.descriptor.addUrlPattern("");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void deleteAction() {
        this.editingStopped();
        int i2 = this.urlMappingTable.getSelectedRow();
        if (i2 != -1) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleteselectedalias", "Are you sure you want to delete the selected alias?"), "Delete alias", 0);
            if (n2 == 0) {
                String urlPattern = (String)((UrlMappingTableModel)this.urlMappingTable.getModel()).getValueAt(i2, 0);
                this.descriptor.removeUrlPattern(urlPattern);
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectaliasfromlist", "You must first select an alias from the list"));
        }
    }

    public void editingStopped() {
        this.urlMappingTable.editingStopped(new ChangeEvent(this));
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        UrlMappingTableModel tableModel = new UrlMappingTableModel();
        this.urlMappingTable.setAutoResizeMode(4);
        this.urlMappingTable.setModel(tableModel);
        this.urlMappingTable.setSelectionMode(0);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setLayout(new BorderLayout());
        mappingPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        mappingPanel.add(new JScrollPane(this.urlMappingTable));
        this.add("Center", mappingPanel);
        JButton addButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add", "Add"));
        JButton deleteButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.delete", "Delete"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        buttonPanel.add(addButton);
        buttonPanel.add(Box.createVerticalStrut(5));
        buttonPanel.add(deleteButton);
        buttonPanel.add(Box.createGlue());
        this.add("East", buttonPanel);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentAliasesInspector.this.addAction();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentAliasesInspector.this.deleteAction();
            }
        });
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(0, 0, 300, 300);
        f2.getContentPane().add(new WebComponentAliasesInspector());
        f2.show();
    }

    private void refresh() {
        ((InspectorTableModel)this.urlMappingTable.getModel()).updateTableData(this.descriptor.getUrlPatternsSet());
        this.urlMappingTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof WebComponentDescriptorImpl) {
            WebComponentDescriptorImpl previousDescriptor = this.descriptor;
            this.descriptor = (WebComponentDescriptorImpl)object;
            if (!this.descriptor.equals(previousDescriptor)) {
                this.editingStopped();
                this.urlMappingTable.getSelectionModel().clearSelection();
            }
            this.refresh();
        }
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    class UrlMappingTableModel
    extends InspectorTableModel {
        public UrlMappingTableModel() {
            super(new String[]{localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.urlmappings", "URL Mappings")});
        }

        public String get(int i2) {
            return (String)this.data.get(i2);
        }

        public String getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (String)this.data.get(index);
        }

        List getUrlMappings() {
            return this.data;
        }

        public Object getValueAt(int row, int col) {
            return this.data.get(row);
        }

        public void setValueAt(Object value, int row, int col) {
            String urlPattern = this.getRow(row);
            if (urlPattern != null) {
                WebComponentAliasesInspector.this.descriptor.removeUrlPattern(urlPattern);
            }
            WebComponentAliasesInspector.this.descriptor.addUrlPattern((String)value);
        }
    }
}

