/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.generators;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.generators.GeneratorException;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarAccess;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.tools.javac.Main;

public class Generator {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$generators$Generator != null ? class$com$sun$enterprise$tools$generators$Generator : (class$com$sun$enterprise$tools$generators$Generator = Generator.class$("com.sun.enterprise.tools.generators.Generator")));
    private static DeploymentSession session;
    private static String applicationName;
    Vector generators = new Vector();
    Vector generatedFiles = new Vector();
    private static final String fs;
    private static final char fsc;
    private static final String ps;
    private static final String ORG_OMG_STUB_PREFIX;
    private static final String COM_SUN_PREFIX;
    private static String rmic;
    private static File tmpDir;
    private static File appTmpDir;
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$Generator;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$HomeGenerator;
    static /* synthetic */ Class class$com$sun$enterprise$tools$generators$WrapperGenerator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$util$JarClassLoader;

    static {
        fs = System.getProperty("file.separator");
        fsc = fs.charAt(0);
        ps = System.getProperty("path.separator");
        ORG_OMG_STUB_PREFIX = "org" + fs + "omg" + fs + "stub";
        COM_SUN_PREFIX = "com" + fs + "sun" + fs;
        String eHome = System.getProperty("com.sun.enterprise.home");
        if (eHome == null) {
            eHome = "tmp";
        }
        String hostname = Utility.getLocalHost();
        String tmpDirName = String.valueOf(eHome) + File.separator + "repository" + File.separator + hostname + File.separator + "gnrtrTMP";
        tmpDir = new File(tmpDirName == null ? "tmp" : tmpDirName);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        rmic = String.valueOf(System.getProperty("java.home")) + fs + "bin" + fs + "java";
    }

    public Generator() {
        this.generators.addElement(class$com$sun$enterprise$tools$generators$HomeGenerator != null ? class$com$sun$enterprise$tools$generators$HomeGenerator : (class$com$sun$enterprise$tools$generators$HomeGenerator = Generator.class$("com.sun.enterprise.tools.generators.HomeGenerator")));
        this.generators.addElement(class$com$sun$enterprise$tools$generators$WrapperGenerator != null ? class$com$sun$enterprise$tools$generators$WrapperGenerator : (class$com$sun$enterprise$tools$generators$WrapperGenerator = Generator.class$("com.sun.enterprise.tools.generators.WrapperGenerator")));
    }

    public static void addGeneratedFiles(Vector dds, Vector allGeneratedFiles, Vector allClientFiles) {
        int ddIndex = 0;
        while (ddIndex < dds.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)dds.elementAt(ddIndex);
            GeneratedNames names = new GeneratedNames(dd2);
            String homeStubClass = String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getHomeStubClass();
            allGeneratedFiles.addElement(homeStubClass);
            allClientFiles.addElement(homeStubClass);
            String tieClassName = String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getHomeTieClass();
            allGeneratedFiles.addElement(tieClassName);
            String remoteStub = String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getRemoteStubClass();
            allGeneratedFiles.addElement(remoteStub);
            allClientFiles.addElement(remoteStub);
            String ejbObjectTie = String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getEjbObjectTieClass();
            allGeneratedFiles.addElement(ejbObjectTie);
            ++ddIndex;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void compileAll(File jarFile, Vector allGeneratedFiles) throws GeneratorException, IOException {
        sun.rmi.rmic.Main comp;
        Main compiler;
        if (allGeneratedFiles.size() == 0) {
            System.out.println(localStrings.getLocalString("generator.nothing_to_compile", "No code generation required"));
            Generator.progressEvent("Ejb Compilation complete", session);
            Generator.progressEvent("Ejb Compilation complete", session);
            return;
        }
        Generator.progress(localStrings.getLocalString("generator.compiling_wrapper", "Compiling wrapper code."));
        Enumeration e10 = allGeneratedFiles.elements();
        int size = allGeneratedFiles.size();
        String[] javacArgs = new String[4 + size];
        int cnt = 0;
        javacArgs[cnt++] = "-d";
        javacArgs[cnt++] = Generator.getTempDirectory().toString();
        javacArgs[cnt++] = "-classpath";
        javacArgs[cnt++] = String.valueOf(System.getProperty("java.class.path")) + ps + jarFile + ps + Generator.getTempDirectory().toString();
        while (e10.hasMoreElements()) {
            String file = (String)e10.nextElement();
            javacArgs[cnt++] = file;
            System.out.println(localStrings.getLocalString("generator.compile", "Compiling {0} ...", new Object[]{file}));
        }
        try {
            compiler = new Main((OutputStream)System.err, "javac");
        }
        catch (Throwable t2) {
            System.err.println(t2);
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Could not invoke javac.");
        }
        if (!compiler.compile(javacArgs)) {
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Compilation failed.");
        }
        if (session.isCancelled()) {
            return;
        }
        Generator.progressEvent("Ejb Compilation complete", session);
        Generator.progress(localStrings.getLocalString("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."));
        int i2 = 0;
        while (i2 < allGeneratedFiles.size()) {
            String javaFile = (String)allGeneratedFiles.elementAt(i2);
            String classFile = String.valueOf(javaFile.substring(0, javaFile.indexOf(".java"))) + ".class";
            allGeneratedFiles.setElementAt(classFile, i2);
            ++i2;
        }
        Enumeration e12 = allGeneratedFiles.elements();
        String[] rmicArgs = new String[9 + allGeneratedFiles.size() * 2];
        int rmicCnt = 0;
        rmicArgs[rmicCnt++] = "-iiop";
        rmicArgs[rmicCnt++] = "-poa";
        rmicArgs[rmicCnt++] = "-alwaysgenerate";
        rmicArgs[rmicCnt++] = "-keepgenerated";
        rmicArgs[rmicCnt++] = "-nolocalstubs";
        rmicArgs[rmicCnt++] = "-classpath";
        rmicArgs[rmicCnt++] = String.valueOf(System.getProperty("java.class.path")) + ps + jarFile + ps + Generator.getTempDirectory();
        rmicArgs[rmicCnt++] = "-d";
        rmicArgs[rmicCnt++] = Generator.getTempDirectory().toString();
        String cname = "";
        while (e12.hasMoreElements()) {
            String file = (String)e12.nextElement();
            String className = Generator.getClassName(file);
            System.out.println("rmic " + className + "...");
            rmicArgs[rmicCnt++] = "-transactional";
            rmicArgs[rmicCnt++] = className;
            cname = String.valueOf(cname) + " " + className;
        }
        try {
            comp = new sun.rmi.rmic.Main(System.err, "rmic");
        }
        catch (Throwable t3) {
            t3.printStackTrace();
            System.err.println("Could not invoke rmic..");
            throw new GeneratorException("Could not invoke rmic");
        }
        if (!comp.compile(rmicArgs)) {
            System.err.println("rmic compilation failed...");
            throw new GeneratorException("rmic compilation failed.");
        }
        if (session.isCancelled()) {
            return;
        }
        Generator.progressEvent("Ejb Compilation complete", session);
    }

    public static String cookJar(String appName, File original, File dst, File clientDst, Vector allGeneratedFiles, Vector allClientFiles) throws IOException {
        int sz = allGeneratedFiles.size();
        int clientSz = allClientFiles.size();
        boolean index = false;
        boolean clientIndex = false;
        Vector<String> genFilesUnique = new Vector<String>();
        Vector<String> clientGenFilesUnique = new Vector<String>();
        int i2 = 0;
        while (i2 < allGeneratedFiles.size()) {
            String nextFileToAdd = (String)allGeneratedFiles.elementAt(i2);
            if (!genFilesUnique.contains(nextFileToAdd)) {
                genFilesUnique.addElement(nextFileToAdd);
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < allClientFiles.size()) {
            String nextFileToAdd = (String)allClientFiles.elementAt(k2);
            if (!clientGenFilesUnique.contains(nextFileToAdd)) {
                clientGenFilesUnique.addElement(nextFileToAdd);
            }
            ++k2;
        }
        Generator.progress(localStrings.getLocalString("generator.making_client_jars", "making client JARs"));
        Generator.progressEvent("Client JARs made", session);
        Generator.makeJar(appName, original, dst, genFilesUnique);
        Generator.progress(localStrings.getLocalString("generator.making_server_jars", "making server JARs"));
        Generator.makeJar(appName, original, clientDst, clientGenFilesUnique);
        Generator.progressEvent("Server JARs made", session);
        return dst.toString();
    }

    OutputStream createOutputStream(String className) throws IOException {
        String fileName = this.getFileName(className);
        File file = new File(fileName);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        this.generatedFiles.addElement(fileName);
        return new FileOutputStream(fileName);
    }

    private static boolean ddHasUniqueInterfaces(Vector deploymentDescriptors, EjbDescriptor ddToCheck) {
        boolean hasUniqueInterfaces = true;
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor currentDD = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (currentDD.getHomeClassName().equals(ddToCheck.getHomeClassName()) && currentDD.getRemoteClassName().equals(ddToCheck.getRemoteClassName()) && currentDD.getEjbClassName().equals(ddToCheck.getEjbClassName())) {
                hasUniqueInterfaces = false;
                break;
            }
            ++i2;
        }
        return hasUniqueInterfaces;
    }

    private static boolean descriptorRequiresCodeGen(EjbDescriptor desc, File oldServerJar, File ejbJar) {
        boolean codeGenRequired = false;
        HashSet<String> allInterfaces = new HashSet<String>();
        String homeName = desc.getHomeClassName();
        String remoteName = desc.getRemoteClassName();
        allInterfaces.add(homeName);
        allInterfaces.add(remoteName);
        try {
            JarClassLoader jcl = new JarClassLoader(ejbJar.toString());
            Set homeSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, homeName, "javax.ejb.EJBHome");
            Set remoteSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, remoteName, "javax.ejb.EJBObject");
            allInterfaces.addAll(homeSuperInterfaces);
            allInterfaces.addAll(remoteSuperInterfaces);
            Iterator iter = allInterfaces.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                String entryName = String.valueOf(className.replace('.', fsc)) + ".class";
                if (FileUtil.jarEntriesEqual(oldServerJar, entryName, ejbJar, entryName)) continue;
                codeGenRequired = true;
                break;
            }
        }
        catch (Exception e10) {
            codeGenRequired = true;
        }
        return codeGenRequired;
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
    }

    public void generateAll(File jarFile, JarClassLoader cl2, EjbDescriptor dd2) throws GeneratorException, IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Generator.progress(localStrings.getLocalString("generator.gen_wrapper_code", "Generating wrapper code {0}", new Object[]{dd2.getName()}));
        int i2 = 0;
        while (i2 < this.generators.size()) {
            Class c10 = (Class)this.generators.elementAt(i2);
            Class[] argTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : Generator.class$("java.lang.String"), class$com$sun$enterprise$deployment$EjbDescriptor != null ? class$com$sun$enterprise$deployment$EjbDescriptor : Generator.class$("com.sun.enterprise.deployment.EjbDescriptor"), class$com$sun$enterprise$util$JarClassLoader != null ? class$com$sun$enterprise$util$JarClassLoader : Generator.class$("com.sun.enterprise.util.JarClassLoader")};
            Constructor constructor = c10.getConstructor(argTypes);
            Object[] argObjects = new Object[]{Generator.getApplicationName(), dd2, cl2};
            Generator generator = null;
            try {
                generator = (Generator)constructor.newInstance(argObjects);
            }
            catch (InvocationTargetException exc) {
                exc.getTargetException().printStackTrace();
                throw exc;
            }
            OutputStream out = this.createOutputStream(generator.generatingClass());
            generator.generate(out);
            out.close();
            ++i2;
        }
    }

    public String generatingClass() {
        return null;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    static String getBaseName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return className;
        }
        return className.substring(dot + 1);
    }

    static String getClassName(String fileName) {
        String className = fileName;
        if (className.startsWith(Generator.getTempDirectory().toString())) {
            className = className.substring(Generator.getTempDirectory().toString().length());
        }
        if (className.indexOf(".java") != -1) {
            className = className.substring(0, className.indexOf(".java"));
        } else if (className.indexOf(".class") != -1) {
            className = className.substring(0, className.indexOf(".class"));
        }
        className = className.replace(fsc, '.');
        if (className.charAt(0) == '.') {
            className = className.substring(1);
        }
        return className;
    }

    private static Vector getDeploymentDescriptorsIn(File file, JarClassLoader jcl) throws Exception {
        Vector deploymentDescriptors = new Vector();
        System.out.println("Parse deployment descriptor as XML");
        Application application = ApplicationArchivist.open(file);
        Enumeration e10 = application.getEjbDescriptors().elements();
        while (e10.hasMoreElements()) {
            deploymentDescriptors.addElement(e10.nextElement());
        }
        return deploymentDescriptors;
    }

    String getFileName(String className) {
        return String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + className.replace('.', fsc) + ".java";
    }

    static String getPackageName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return className.substring(0, dot);
    }

    private static File getTempDirectory() {
        return appTmpDir;
    }

    public static File getTempDirectory(String appName) {
        return new File(tmpDir, appName);
    }

    public static void main(String[] args) {
        ORBManager.init(args, null);
        int i2 = 0;
        while (i2 < args.length) {
            try {
                String cookedJar = args[i2].substring(0, args[i2].lastIndexOf(46));
                String clientJar = String.valueOf(cookedJar) + "Client.jar";
                cookedJar = String.valueOf(cookedJar) + "Cooked.jar";
                File file = new File(cookedJar);
                File clientFile = new File(clientJar);
                Generator.preDeploy("main", new File(args[i2]), file, clientFile, null, null);
            }
            catch (GeneratorException ex2) {
                System.out.println(ex2);
            }
            catch (ClassNotFoundException ex3) {
                System.err.println(ex3);
            }
            catch (IOException ex4) {
                System.err.println(ex4);
            }
            catch (Exception ex5) {
                ex5.printStackTrace();
            }
            ++i2;
        }
        System.exit(0);
    }

    public static void makeJar(String appName, File inputJarFile, File outputJarFile, Vector files) throws IOException {
        if (outputJarFile.exists()) {
            System.out.println("Warning: " + outputJarFile + " already exists.");
        }
        FileOutputStream fos = new FileOutputStream(outputJarFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Archivist.addJarToOutput(zos, new JarFile(inputJarFile), new Vector());
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            String longName = (String)e10.nextElement();
            File file = new File(longName);
            String entryName = "";
            if (longName.startsWith(Generator.getTempDirectory(appName).toString())) {
                entryName = longName.substring(Generator.getTempDirectory(appName).toString().length());
                if (entryName.charAt(0) == fsc) {
                    entryName = entryName.substring(1);
                }
            } else {
                throw new RuntimeException("error");
            }
            entryName = entryName.replace(fsc, '/');
            FileInputStream fis = new FileInputStream(file);
            zos.putNextEntry(new ZipEntry(entryName));
            Archivist.copy(fis, zos);
            zos.closeEntry();
            fis.close();
        }
        zos.close();
        fos.close();
    }

    public static String preDeploy(String appName, File srcJar, File dstJar, File clientDstJar, DeploymentSession session, File oldServerJar) throws GeneratorException, ClassNotFoundException, IOException, Exception {
        Generator.setSession(session, appName);
        Vector deploymentDescriptors = null;
        final JarClassLoader jcl = new JarClassLoader();
        jcl.addJar(srcJar.toString());
        File gntrDir = Generator.getTempDirectory();
        gntrDir.mkdirs();
        jcl.addDir(Generator.getTempDirectory().toURL());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(jcl);
                return null;
            }
        });
        try {
            deploymentDescriptors = Generator.getDeploymentDescriptorsIn(srcJar, jcl);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.out.println("There was an error in opening the JAR file.");
        }
        Vector<EjbDescriptor> descriptorsWithUniqueInterfaces = new Vector<EjbDescriptor>();
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (Generator.ddHasUniqueInterfaces(descriptorsWithUniqueInterfaces, dd2)) {
                descriptorsWithUniqueInterfaces.add(dd2);
            }
            ++i2;
        }
        Vector<EjbDescriptor> descriptorsRequiringCodeGen = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> reusableDescriptors = new Vector<EjbDescriptor>();
        Vector allGeneratedFiles = new Vector();
        if (oldServerJar != null) {
            Hashtable<EjbBundleDescriptor, File> allEjbJars = new Hashtable<EjbBundleDescriptor, File>();
            Application app = ApplicationArchivist.open(srcJar);
            int i3 = 0;
            while (i3 < descriptorsWithUniqueInterfaces.size()) {
                EjbDescriptor desc = (EjbDescriptor)descriptorsWithUniqueInterfaces.elementAt(i3);
                EjbBundleDescriptor bundleDesc = desc.getEjbBundleDescriptor();
                File ejbJar = (File)allEjbJars.get(bundleDesc);
                if (ejbJar == null) {
                    ejbJar = new File(String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + "temp__ejb" + i3);
                    app.getApplicationArchivist().extractBundleToFile(bundleDesc, ejbJar);
                    allEjbJars.put(bundleDesc, ejbJar);
                }
                if (Generator.descriptorRequiresCodeGen(desc, oldServerJar, ejbJar)) {
                    descriptorsRequiringCodeGen.add(desc);
                } else {
                    reusableDescriptors.add(desc);
                }
                ++i3;
            }
        } else {
            descriptorsRequiringCodeGen = descriptorsWithUniqueInterfaces;
        }
        Generator[] generators = new Generator[descriptorsRequiringCodeGen.size()];
        Generator.progress(localStrings.getLocalString("generator.processing_beans", "Processing beans..."));
        int i4 = 0;
        while (i4 < descriptorsRequiringCodeGen.size()) {
            generators[i4] = new Generator();
            generators[i4].generateAll(srcJar, jcl, (EjbDescriptor)descriptorsRequiringCodeGen.elementAt(i4));
            int j2 = 0;
            while (j2 < generators[i4].generatedFiles.size()) {
                Object elem = generators[i4].generatedFiles.elementAt(j2);
                if (!allGeneratedFiles.contains(elem)) {
                    allGeneratedFiles.addElement(elem);
                }
                ++j2;
            }
            if (session.isCancelled()) {
                return "";
            }
            ++i4;
        }
        Generator.progressEvent("Ejb Code Generation complete", session);
        Generator.compileAll(srcJar, allGeneratedFiles);
        Generator.processReusableGeneratedFiles(reusableDescriptors, allGeneratedFiles, oldServerJar);
        if (session.isCancelled()) {
            return "";
        }
        Vector allClientFiles = new Vector();
        Generator.addGeneratedFiles(descriptorsWithUniqueInterfaces, allGeneratedFiles, allClientFiles);
        if (session.isCancelled()) {
            return "";
        }
        String s2 = Generator.cookJar(appName, srcJar, dstJar, clientDstJar, allGeneratedFiles, allClientFiles);
        Generator.setSession(null, "");
        return s2;
    }

    protected String printType(Class cls) {
        if (cls.isArray()) {
            return String.valueOf(this.printType(cls.getComponentType())) + "[]";
        }
        return cls.getName();
    }

    private static void processReusableGeneratedFiles(Vector descriptors, Vector allGeneratedFiles, File oldServerJar) throws IOException {
        if (oldServerJar == null || descriptors.size() == 0) {
            return;
        }
        int FILES_PER_DESC = 6;
        int totalNumFiles = descriptors.size() * 6;
        String[] files = new String[totalNumFiles];
        int i2 = 0;
        while (i2 < descriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)descriptors.elementAt(i2);
            GeneratedNames names = new GeneratedNames(desc);
            allGeneratedFiles.add(String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getEjbObjectImplClass());
            allGeneratedFiles.add(String.valueOf(String.valueOf(Generator.getTempDirectory())) + fs + names.getHomeImplClass());
            int baseFileIndex = i2 * 6;
            files[baseFileIndex] = names.getEjbObjectImplClass();
            files[baseFileIndex + 1] = names.getHomeImplClass();
            files[baseFileIndex + 2] = names.getHomeTieClass();
            files[baseFileIndex + 3] = names.getHomeStubClass();
            files[baseFileIndex + 4] = names.getRemoteStubClass();
            files[baseFileIndex + 5] = names.getEjbObjectTieClass();
            ++i2;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(oldServerJar);
            JarAccess.extract(inputStream, files, Generator.getTempDirectory().toString());
        }
        finally {
            Object var9_11 = null;
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    private static void progress(String message) {
        block2: {
            if (session == null) break block2;
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    private static void progressEvent(String eventType, DeploymentSession session) {
        block2: {
            if (session == null) break block2;
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    protected Method[] removeDups(Method[] orig) {
        Vector<Method> nodups = new Vector<Method>();
        int i2 = 0;
        while (i2 < orig.length) {
            Method m1 = orig[i2];
            boolean dup = false;
            Enumeration e10 = nodups.elements();
            while (e10.hasMoreElements()) {
                Class<?>[] m2parms;
                Class<?>[] m1parms;
                Method m2 = (Method)e10.nextElement();
                if (!m1.getName().equals(m2.getName()) || (m1parms = m1.getParameterTypes()).length != (m2parms = m2.getParameterTypes()).length) continue;
                boolean parmsDup = true;
                int j2 = 0;
                while (j2 < m2parms.length) {
                    if (m1parms[j2] != m2parms[j2]) {
                        parmsDup = false;
                        break;
                    }
                    ++j2;
                }
                if (!parmsDup) continue;
                dup = true;
                if (!m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) break;
                nodups.remove(m2);
                nodups.add(m1);
                break;
            }
            if (!dup) {
                nodups.add(m1);
            }
            ++i2;
        }
        return nodups.toArray(new Method[nodups.size()]);
    }

    public static void setSession(DeploymentSession sessionObject, String appName) {
        session = sessionObject;
        applicationName = appName;
        appTmpDir = new File(tmpDir, applicationName);
        appTmpDir.mkdirs();
    }

    private static class GeneratedNames {
        private String homeImplClass;
        private String homeTieClass;
        private String homeStubClass;
        private String remoteStubClass;
        private String ejbObjectTieClass;
        private String ejbObjectImplClass;

        public GeneratedNames(EjbDescriptor desc) {
            String ejbName = desc.getEjbClassName().replace('.', fsc);
            String homeName = desc.getHomeClassName().replace('.', fsc);
            String remoteInterfaceName = desc.getRemoteClassName().replace('.', fsc);
            String ejbClassName = ejbName;
            String ejbPackageName = "";
            int idx = ejbName.lastIndexOf(fsc);
            if (idx != -1) {
                ejbClassName = ejbName.substring(idx + 1, ejbName.length());
                ejbPackageName = ejbName.substring(0, idx + 1);
            }
            this.ejbObjectTieClass = String.valueOf(ejbPackageName) + "_" + ejbClassName + "_EJBObjectImpl_Tie.class";
            if (ejbName.startsWith(COM_SUN_PREFIX)) {
                this.ejbObjectTieClass = String.valueOf(ORG_OMG_STUB_PREFIX) + fs + this.ejbObjectTieClass;
            }
            this.ejbObjectImplClass = String.valueOf(ejbPackageName) + ejbClassName + "_EJBObjectImpl.class";
            String homeClassName = homeName;
            String homePackageName = "";
            idx = homeName.lastIndexOf(fsc);
            if (idx != -1) {
                homeClassName = homeName.substring(idx + 1, homeName.length());
                homePackageName = homeName.substring(0, idx + 1);
            }
            this.homeImplClass = String.valueOf(ejbPackageName) + homeClassName + "Impl.class";
            this.homeTieClass = String.valueOf(ejbPackageName) + "_" + homeClassName + "Impl_Tie.class";
            if (ejbName.startsWith(COM_SUN_PREFIX)) {
                this.homeTieClass = String.valueOf(ORG_OMG_STUB_PREFIX) + fs + this.homeTieClass;
            }
            this.homeStubClass = String.valueOf(homePackageName) + "_" + homeClassName + "_Stub.class";
            if (homeName.startsWith(COM_SUN_PREFIX)) {
                this.homeStubClass = String.valueOf(ORG_OMG_STUB_PREFIX) + fs + this.homeStubClass;
            }
            String remoteClassName = remoteInterfaceName;
            String remotePackageName = "";
            idx = remoteInterfaceName.lastIndexOf(fsc);
            if (idx != -1) {
                remoteClassName = remoteInterfaceName.substring(idx + 1, remoteInterfaceName.length());
                remotePackageName = remoteInterfaceName.substring(0, idx + 1);
            }
            this.remoteStubClass = String.valueOf(remotePackageName) + "_" + remoteClassName + "_Stub.class";
            if (remoteInterfaceName.startsWith(COM_SUN_PREFIX)) {
                this.remoteStubClass = String.valueOf(ORG_OMG_STUB_PREFIX) + fs + this.remoteStubClass;
            }
        }

        public String getEjbObjectImplClass() {
            return this.ejbObjectImplClass;
        }

        public String getEjbObjectTieClass() {
            return this.ejbObjectTieClass;
        }

        public String getHomeImplClass() {
            return this.homeImplClass;
        }

        public String getHomeStubClass() {
            return this.homeStubClass;
        }

        public String getHomeTieClass() {
            return this.homeTieClass;
        }

        public String getRemoteStubClass() {
            return this.remoteStubClass;
        }
    }
}

