/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultsRecord;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgr;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AppCheckMgrImpl
extends CheckMgr
implements AppCheckMgr {
    private static Vector test = new Vector();
    private static Vector allAppResults = new Vector();
    boolean allIsWell = true;

    boolean AllTestNamesFromPropsFile() {
        test = new Vector();
        boolean allIsWell = true;
        if (this.debug) {
            System.out.println(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.TestnamesPropsFile", "About to get all test names from props file."));
        }
        File inputFile = AppCheckMgrImpl.getAppTestsFileFor("TestNamesApp.conf");
        try {
            FileReader in = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(in);
            String ln = null;
            while ((ln = buf_reader.readLine()) != null) {
                test.addElement(ln);
            }
            buf_reader.close();
            in.close();
        }
        catch (FileNotFoundException e10) {
            Verifier.debug(e10);
            this.setStatus(false);
        }
        catch (IOException e11) {
            Verifier.debug(e11);
            this.setStatus(false);
        }
        return allIsWell;
    }

    public boolean check(Application descriptor) {
        this.allIsWell = true;
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.AppCheckMgr.check", "inside AppCheckMgr.check for [ {0} ]", new Object[]{descriptor.getName()}));
            System.out.println("[ " + descriptor + " ]");
        }
        this.setStatus(this.AllTestNamesFromPropsFile());
        if (this.allIsWell) {
            Hashtable<String, Result> warningResults = new Hashtable<String, Result>();
            Hashtable<String, Result> failedResults = new Hashtable<String, Result>();
            Hashtable<String, Result> okayResults = new Hashtable<String, Result>();
            Hashtable<String, Result> naResults = new Hashtable<String, Result>();
            if (this.debug) {
                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.RunAllTests", "Now run all tests against Application [ {0} ]", new Object[]{descriptor.getName()}));
            }
            int i2 = 0;
            while (i2 < test.size()) {
                try {
                    Class<?> c10 = Class.forName((String)test.elementAt(i2));
                    try {
                        AppCheck t2 = (AppCheck)c10.newInstance();
                        Result r2 = new Result();
                        try {
                            r2 = t2.check(descriptor);
                            r2.setComponentName(descriptor.getName());
                        }
                        catch (Throwable tt) {
                            if (this.debug) {
                                System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{tt.toString()}));
                            }
                            Verifier.debug(tt);
                            r2.init(c10);
                            r2.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{tt.toString()}));
                            r2.setComponentName(descriptor.getName());
                        }
                        this.fireStateChanged(r2);
                        if (r2.getStatus() == 1) {
                            if (this.debug) {
                                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.status.FAILED", " {0}  [ FAILED ]", new Object[]{r2.getTestName()}));
                            }
                            failedResults.put(r2.getTestName(), r2);
                            this.setStatus(false);
                        } else if (r2.getStatus() == 0) {
                            if (this.debug) {
                                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.status.PASSED", " {0}  [ PASSED ]", new Object[]{r2.getTestName()}));
                            }
                            okayResults.put(r2.getTestName(), r2);
                        } else if (r2.getStatus() == 2) {
                            if (this.debug) {
                                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.status.WARNING", " {0}  [ WARNING ]", new Object[]{r2.getTestName()}));
                            }
                            warningResults.put(r2.getTestName(), r2);
                        } else if (r2.getStatus() == 3 || r2.getStatus() == 4 || r2.getStatus() == 5) {
                            if (this.debug) {
                                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.status.NOT_APPLICABLE", " {0}  [ NOT_APPLICABLE ]", new Object[]{r2.getTestName()}));
                            }
                            naResults.put(r2.getTestName(), r2);
                        }
                    }
                    catch (InstantiationException e10) {
                        Verifier.debug(e10);
                        this.setStatus(false);
                    }
                    catch (IllegalAccessException e11) {
                        Verifier.debug(e11);
                        this.setStatus(false);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Verifier.debug("Application test class [ " + (String)test.elementAt(i2) + " ] not found.");
                }
                ++i2;
            }
            ResultsRecord hashTableResults = new ResultsRecord();
            hashTableResults.setPassedResults(okayResults);
            hashTableResults.setFailedResults(failedResults);
            hashTableResults.setNaResults(naResults);
            hashTableResults.setWarningResults(warningResults);
            allAppResults.addElement(hashTableResults);
        }
        Iterator itr = descriptor.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor nextDescriptor = (EjbBundleDescriptor)itr.next();
            if (this.debug) {
                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.Calling.EjbCheckMgrImpl.check", "about to call EjbCheckMgrImpl.check"));
            }
            this.setStatus(JarCheckImpl.getEjbCheckMgrImpl().check(nextDescriptor));
            if (!this.debug) continue;
            System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.TestedDescriptor", " AppCheckMgrImpl:Tested descriptor =>[ {0} ]<=", new Object[]{nextDescriptor.getName()}));
            System.out.println("=>[ " + nextDescriptor + " ]<=");
        }
        Iterator itr2 = descriptor.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor nextDescriptor = (WebBundleDescriptor)itr2.next();
            if (this.debug) {
                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.Calling.WebCheckMgrImpl.check", "about to call WebCheckMgrImpl.check"));
            }
            this.setStatus(JarCheckImpl.getWebCheckMgrImpl().check(nextDescriptor));
            if (!this.debug) continue;
            System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.TestedDescriptor", " AppCheckMgrImpl:Tested descriptor =>[ {0} ]<=", new Object[]{nextDescriptor.getName()}));
            System.out.println("=>[ " + nextDescriptor + " ]<=");
        }
        Iterator itr3 = descriptor.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor nextDescriptor = (ApplicationClientDescriptor)itr3.next();
            if (this.debug) {
                System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.Calling.AppClientCheckMgrImpl.check", "about to call AppClientCheckMgrImpl.check"));
            }
            this.setStatus(JarCheckImpl.getAppClientCheckMgrImpl().check(nextDescriptor));
            if (!this.debug) continue;
            System.out.println(smh.getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.TestedDescriptor", " AppCheckMgrImpl:Tested descriptor =>[ {0} ]<=", new Object[]{nextDescriptor.getName()}));
            System.out.println("=>[ " + nextDescriptor + " ]<=");
        }
        return this.allIsWell;
    }

    public static void clearAllAppResults() {
        allAppResults.clear();
    }

    public static Vector getAllAppResults() {
        return allAppResults;
    }

    public static File getAppTestsFileFor(String filename) {
        File f2 = new File(System.getProperty("com.sun.enterprise.home"));
        f2 = new File(f2, "config");
        f2 = new File(f2, "verifier");
        f2 = new File(f2, filename);
        if (Verifier.getDebug()) {
            System.out.println(StringManagerHelper.getLocalStringsManager().getLocalString("com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl.RetrievingTestnames", "Retrieving Test names from [ {0} ]", new Object[]{f2.toString()}));
        }
        return new File(f2.toString());
    }

    public static Vector getTests() {
        return test;
    }

    void setStatus(boolean s2) {
        if (this.allIsWell) {
            this.allIsWell = s2;
        }
    }
}

