/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.tools.verifier.gui.ResultsPanel;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MainPanel
extends JPanel
implements Runnable {
    ResultsPanel resultsPanel = new ResultsPanel();
    Verifier verifier;
    ControlPanel verifierControls;
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    JLabel statusLabel = new JLabel(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
    Enumeration components;
    Descriptor application = null;
    Thread running = null;

    public MainPanel(JFrame parent, Verifier v2) {
        this(parent, null, v2);
    }

    public MainPanel(JFrame parent, String jarFileName, Verifier v2) {
        super(new BorderLayout(), true);
        this.verifier = v2;
        this.verifierControls = new ControlPanel(parent);
        this.setJarFilename(jarFileName);
        this.add("North", this.verifierControls);
        this.add("Center", this.resultsPanel);
        this.add("South", this.statusLabel);
        this.verifierControls.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (MainPanel.this.getFileList().hasMoreElements()) {
                    MainPanel.this.resultsPanel.clearOldResults();
                    MainPanel.this.clearAllResultsVectors();
                    MainPanel.this.start();
                } else {
                    JOptionPane.showMessageDialog(MainPanel.this.verifierControls, String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles", "You must first select file to verify.")) + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles2", "Use the Add button to select file to be verified, then click on OK button."));
                }
            }
        });
        this.verifierControls.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (MainFrame.getExitOnClose()) {
                    System.exit(0);
                } else {
                    MainPanel.this.stop();
                    MainPanel.this.enableOK();
                    MainPanel.this.enableClose();
                    MainPanel.this.reset();
                    try {
                        Class<?> cls = Class.forName("javax.swing.JFrame");
                        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(cls, MainPanel.this.resultsPanel);
                        ((Component)frame).setVisible(false);
                    }
                    catch (ClassNotFoundException ex2) {
                        ex2.getMessage();
                    }
                }
            }
        });
    }

    private void clearAllResultsVectors() {
        EjbCheckMgrImpl.clearAllEJBResults();
        WebCheckMgrImpl.clearAllWebResults();
        AppClientCheckMgrImpl.clearAllAppClientResults();
        AppCheckMgrImpl.clearAllAppResults();
    }

    public void clearResults() {
        this.resultsPanel.clearResults();
    }

    void disableClose() {
        this.verifierControls.closeButton.setEnabled(false);
    }

    void disableOK() {
        this.verifierControls.okButton.setEnabled(false);
    }

    void enableClose() {
        this.verifierControls.closeButton.setEnabled(true);
    }

    void enableOK() {
        this.verifierControls.okButton.setEnabled(true);
    }

    public Enumeration getFileList() {
        return this.verifierControls.listModel.elements();
    }

    public ControlPanel getVerifierControlPanel() {
        return this.verifierControls;
    }

    public void reset() {
        this.resultsPanel.clearOldResults();
        this.resultsPanel.clearResults();
        this.verifierControls.removeAllJarFiles();
        this.clearAllResultsVectors();
        this.verifier.resetApplication();
    }

    public void run() {
        this.disableOK();
        JarCheckImpl jarCheckImpl = new JarCheckImpl();
        while (this.components.hasMoreElements() && this.running != null) {
            Descriptor application;
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_LoadingFile", "Loading file..."));
            File jarFile = (File)this.components.nextElement();
            String jarName = jarFile.getAbsolutePath();
            try {
                application = this.verifier.loadJar(jarName);
            }
            catch (Throwable t2) {
                Descriptor.setBoundsChecking(true);
                JOptionPane.showMessageDialog(this, String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{jarName, t2.getMessage()})) + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoadingContactHostAdmin", "Please consult your host administrator."));
                this.resultsPanel.addDetailText(String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{jarName, t2.getMessage()})) + "\n");
                this.running = null;
                break;
            }
            if (application == null) {
                this.resultsPanel.addDetailText(String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{jarName, this.verifier.getExceptionMessage()})) + "\n");
                this.running = null;
                Descriptor.setBoundsChecking(true);
                break;
            }
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Testing", "Testing {0}...", new Object[]{application.getName()}));
            try {
                if (jarCheckImpl.check(application)) {
                    this.resultsPanel.addDetailText(String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.AllTestsPassed", "{0}: All tests passed.", new Object[]{application.getName()})) + "\n");
                } else {
                    this.resultsPanel.addDetailText(String.valueOf(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.SomeTestsFailed", "{0}: Some tests failed.", new Object[]{application.getName()})) + "\n");
                }
                Descriptor.setBoundsChecking(true);
            }
            catch (Throwable throwable) {
                Descriptor.setBoundsChecking(true);
            }
            if (!(application instanceof Application)) continue;
            Verifier.cleanTMPFiles();
        }
        if (this.running != null) {
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_WritingReport", "Writing report..."));
            if (!this.verifier.writeDetails()) {
                this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ProblemWritingReport", "There was a problem writing the report file."));
                this.resultsPanel.addDetailText("\n" + this.verifier.getExceptionMessage() + "\n");
            }
        }
        this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
        this.enableOK();
        this.enableClose();
        this.running = null;
    }

    public void setJarFilename(String jarFileName) {
        File jarFile;
        if (jarFileName != null && (jarFile = new File(jarFileName)).exists()) {
            this.getVerifierControlPanel().addJarFile(jarFile);
        }
    }

    public void setStatus(String stat) {
        this.statusLabel.setText(stat);
    }

    public void start() {
        if (this.running == null) {
            this.components = this.getFileList();
            this.clearResults();
            this.running = new Thread(this);
            this.running.setPriority(1);
            this.running.start();
        }
    }

    public void stop() {
        if (this.running != null) {
            this.running = null;
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Closed", "Closed"));
        }
    }
}

