/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModulesExistWeb
implements AppCheck {
    boolean debug = Verifier.getDebug();

    public Result check(Application descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneFailed = false;
            Iterator itr = descriptor.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                Object var9_8;
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                if (wbd.getArchivist().getArchiveUri().equals("")) continue;
                ZipFile jarFile = null;
                try {
                    try {
                        File applicationJarFile = new File(Verifier.getEarFile());
                        jarFile = new JarFile(applicationJarFile);
                        ZipEntry deploymentEntry = ((JarFile)jarFile).getEntry(wbd.getArchivist().getArchiveUri());
                        if (deploymentEntry != null) {
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "J2EE Web module [ {0} ] exists within [ {1} ].", new Object[]{wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                        } else {
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: J2EE Web module [ {0} ] does not exist within [ {1} ].", new Object[]{wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                        }
                        jarFile.close();
                    }
                    catch (FileNotFoundException ex2) {
                        Verifier.debug(ex2);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: File not found trying to read J2EE module file [ {0} ] within [ {1} ]", new Object[]{wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                    }
                    catch (IOException ex3) {
                        Verifier.debug(ex3);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", " Error: IO Error trying to read J2EE module file [ {0} ] within [ {1} ]", new Object[]{wbd.getArchivist().getArchiveUri(), descriptor.getName()}));
                    }
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

