/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.Set;

public class SecurityRolesRefs
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor || descriptor instanceof EjbSessionDescriptor) {
            Set roleReferences = descriptor.getRoleReferences();
            Iterator roleRefsIterator = roleReferences.iterator();
            EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
            Set roles = bundleDescriptor.getRoles();
            Iterator roleIterator = roles.iterator();
            Role role = null;
            RoleReference roleReference = null;
            boolean found = false;
            boolean oneFailed = false;
            if (roleRefsIterator.hasNext()) {
                while (roleRefsIterator.hasNext()) {
                    found = false;
                    roleReference = (RoleReference)roleRefsIterator.next();
                    while (roleIterator.hasNext()) {
                        role = (Role)roleIterator.next();
                        if (!role.getName().equals(roleReference.getValue())) continue;
                        found = true;
                        roleIterator = roles.iterator();
                        break;
                    }
                    if (!found) {
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Erro: The security role reference [ {0} ] has no corresponding linked security role name [ {1} ]", new Object[]{roleReference.getName(), roleReference.getValue()}));
                        if (oneFailed) continue;
                        oneFailed = true;
                        continue;
                    }
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The security role reference [ {0} ] has corresponding linked security role name [ {1} ]", new Object[]{roleReference.getName(), roleReference.getValue()}));
                }
            } else {
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "There are no role references within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                return result;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
        return result;
    }
}

