/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class TransactionDemarcationBeanManaged
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        try {
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                String transactionType = descriptor.getTransactionType();
                if (EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) {
                    ContainerTransaction containerTransaction = null;
                    if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                        Enumeration ee2 = descriptor.getMethodContainerTransactions().keys();
                        while (ee2.hasMoreElements()) {
                            MethodDescriptor methodDescriptor = (MethodDescriptor)ee2.nextElement();
                            containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                            try {
                                String transactionAttribute = containerTransaction.getTransactionAttribute();
                                if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.   The Application Assembler must not define transaction attributes for an enterprise bean [ {2} ] with bean-managed transaction demarcation.", new Object[]{transactionAttribute, methodDescriptor.getName(), descriptor.getName()}));
                                    continue;
                                }
                                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for an enterprise bean [ {2} ] with bean-managed transaction demarcation.", new Object[]{transactionAttribute, methodDescriptor.getName(), descriptor.getName()}));
                            }
                            catch (NullPointerException nullPointerException) {
                                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed1", "Valid: TransactionAttribute is null for method [ {0} ] in bean [ {1} ]", new Object[]{methodDescriptor.getName(), descriptor.getName()}));
                                return result;
                            }
                        }
                    } else {
                        result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed2", "Valid: There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                    }
                    return result;
                }
                result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Bean [ {0} ] is not [ {1} ] managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), EjbDescriptor.BEAN_TRANSACTION_TYPE, transactionType}));
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
            return result;
        }
        catch (Throwable t2) {
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t2.getMessage(), descriptor.getName()}));
            return result;
        }
    }
}

