/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EjbClassStaticFieldsFinal
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        try {
            JarClassLoader jcl = JarClassLoader.getInstance();
            Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
            boolean oneFailed = false;
            boolean badField = false;
            Field[] fields = c10.getDeclaredFields();
            int i2 = 0;
            while (i2 < fields.length) {
                block15: {
                    block14: {
                        int modifiers;
                        badField = false;
                        if (fields[i2].getName().indexOf("$") != -1 || !Modifier.isStatic(modifiers = fields[i2].getModifiers())) break block14;
                        if (Modifier.isFinal(modifiers)) break block15;
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        badField = true;
                    }
                    if (badField) {
                        result.warning(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: Field [ {0} ] defined within bean class [ {1} ] is defined as static, but not defined as final.  An enterprise Bean must not use read/write static fields. Using read-only static fields is allowed.", new Object[]{fields[i2].getName(), descriptor.getEjbClassName()}));
                    }
                }
                ++i2;
            }
            if (!oneFailed) {
                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This bean class [ {0} ] has defined any and all static fields as final.", new Object[]{descriptor.getEjbClassName()}));
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
        }
        catch (Exception e11) {
            Verifier.debug(e11);
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: [ {0} ] class encountered [ {1} ]", new Object[]{descriptor.getEjbClassName(), e11.getMessage()}));
        }
        catch (Throwable t2) {
            result.warning(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
        }
        return result;
    }
}

