/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;

public class CmpFieldsTransient
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence)) {
                JarClassLoader jcl = JarClassLoader.getInstance();
                boolean oneFailed = false;
                boolean badField = false;
                Iterator itr = ((EjbEntityDescriptor)descriptor).getPersistentFields().iterator();
                while (itr.hasNext()) {
                    FieldDescriptor nextPersistentField = (FieldDescriptor)itr.next();
                    badField = false;
                    boolean foundField = false;
                    Class<?> c12 = null;
                    try {
                        Class<?> c10 = jcl.loadClass(((EjbEntityDescriptor)descriptor).getEjbClassName());
                        do {
                            try {
                                c12 = c10;
                                Field f2 = c10.getDeclaredField(nextPersistentField.getName());
                                foundField = true;
                                int modifiers = f2.getModifiers();
                                if (!Modifier.isTransient(modifiers)) continue;
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                if (!(badField = true)) continue;
                                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Field [ {0} ] defined within entity bean class [ {1} ] is defined as transient.  Container managed field must not be defined in the entity bean class as transient.", new Object[]{nextPersistentField.getName(), c10.getName()}));
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                foundField = false;
                            }
                        } while ((c10 = c10.getSuperclass()) != null && !foundField);
                        if (!foundField) {
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException1", "Error: [ {0} ] field not found within class [ {1} ]", new Object[]{nextPersistentField.getName(), ((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                        }
                    }
                    catch (ClassNotFoundException e10) {
                        Verifier.debug(e10);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                    }
                    if (oneFailed) continue;
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This entity bean class [ {0} ] has defined [ {1} ] container managed field as non-transient field.", new Object[]{c12.getName(), nextPersistentField.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

