/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class BeanFieldsTransient
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(((EjbSessionDescriptor)descriptor).getEjbClassName());
                boolean oneFailed = false;
                boolean badField = false;
                Field[] fields = c10.getDeclaredFields();
                int i2 = 0;
                while (i2 < fields.length) {
                    badField = false;
                    int modifiers = fields[i2].getModifiers();
                    if (Modifier.isTransient(modifiers)) {
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        if (badField = true) {
                            result.warning(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: Field [ {0} ] defined within session bean class [ {1} ] is defined as transient.  Session bean fields should not be defined in the session bean class as transient.", new Object[]{fields[i2].getName(), ((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                        }
                    }
                    ++i2;
                }
                if (!oneFailed) {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "This session bean class [ {0} ] has defined all fields as non-transient fields.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
            }
            catch (Throwable t2) {
                result.warning(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

